import { formsModule } from 'common/js/modules';

var app = formsModule;

app.service('formsModuleService', [
	'$http',
	function($http) {
		this.getForms = function() {
			return $http.get('forms.do');
		};

		this.getWorkflows = function() {
			return $http.get('proxy/workflow');
		};

		this.getWorkflowsOfFolder = function(folderId) {
			return $http.get('proxy/workflow?folderId=' + folderId);
		};

		this.getFolders = function() {
			return $http.get('proxy/folders?type=83');
		};

		this.getWorkflow = function(workfowId) {
			return $http.get('proxy/workflow/' + workflowId);
		};

		this.deploy = function(workflowId) {
			return $http.post('proxy/workflow/' + workflowId + '/Action/Deploy', {});
		};

		this.cloneWorkflow = function(workflowToClone, newWorkflowName) {
			return $http.post('proxy/workflow/' + workflowToClone + '/clone?newname=' + encodeURIComponent(newWorkflowName));
		};

		this.takeOwnerShip = function(workflowId) {
			return $http.post('proxy/workflow/' + workflowId + '/takeownership');
		};

		this.deleteWorkflow = function(workflowId) {
			return $http.delete('proxy/workflow/' + workflowId);
		};

		this.saveProperties = function(workflowId, properties) {
			return $http.put('proxy/workflow/' + workflowId + '/properties', JSON.stringify(properties));
		};

		this.getVersionHistory = function(workflowId) {
			return $http.get('proxy/workflow/' + workflowId + '/history');
		};

		let _convertJSON2XML = function(obj) {
			return _.reduce(
				obj,
				(acc, val, key) => {
					const inner = _.isObject(val) ? _convertJSON2XML(val) : val;
					return acc + `<${key}>${inner}</${key}>`;
				},
				''
			);
		};

		this.startWorkflow = function(workFlowName, workFlowInputs) {
			let inputsString = _convertJSON2XML({ inputs: workFlowInputs });
			return $http.post(`${cv.contextPath}/api/wapi/${workFlowName}`, inputsString, {
				headers: { 'Content-Type': 'application/xml', Accept: 'application/json' }
			});
		};

		this.createWorkflowSchedule = function(obj) {
			return $http.post('workflowSchedule.do', {
				schedule: obj.schedule,
				workflowName: obj.workflowName,
				workflowId: obj.workflowId,
				workflowInput: obj.workflowInput
			});
		};

		this.modifyWorkflowSchedule = function(obj) {
			return $http.post('modifyWorkflowSchedule.do', {
				schedule: obj.schedule,
				taskId: obj.taskId,
				subTaskId: obj.subTaskId,
				workflowInput: obj.workflowInput
			});
		};

		this.getWorkflowSchedules = function(workflowId) {
			return $http.get('proxy/workflow/' + workflowId + '/schedules');
		};

		this.getSchedules = function(workflowId) {
			return $http.get(workflowId ? 'proxy/workflow/' + workflowId + '/schedules' : 'proxy/schedules?isWorkflow=true');
		};

		this.getEmailApproval = function() {
			return $http.get('proxy/workflow_editor/approval');
		};

		this.saveEmailApproval = function(properties) {
			return $http.post('emailApprovalProperties.do', {
				mailbox: properties.mailbox,
				folder: properties.folder,
				host: properties.host,
				enable: properties.enable,
				mailBoxPwd: properties.mailBoxPwd,
				pwdChanged: properties.pwdChanged
			});
		};

		this.getConfigForm = function(workflowId) {
			return $http.post('retrieveInputFormForRules.do', {
				fetchConfigForm: true,
				workflowId: workflowId
			});
		};

		this.saveConfigForm = function(workflowId, configForm) {
			return $http.post('saveWfConfiguration.do', {
				workflowId: workflowId,
				configVals: JSON.stringify(configForm ? configForm : {})
			});
		};

		this.importWorkflow = function(data) {
			return $http.post('importWorkflow.do', data, {
				transformRequest: angular.identity,
				headers: {
					'Content-Type': undefined
				}
			});
		};
	}
]);

export default app;
