import { formsModule } from 'common/js/modules';

var app = formsModule;

app.filter('filterWorkflows', [
	function() {
		return function(forms, keyword, tag) {
			let filtered = [];
			var reg = new RegExp(keyword, 'i');

			if (tag && tag.loadAllWorkflows != undefined && tag.loadAllWorkflows === true) {
				angular.forEach(forms, function(form) {
					filtered.push(form);
				});
			} else {
				if (forms) {
					angular.forEach(forms, function(form) {
						if (reg.test(form.entity.workflowName)) {
							filtered.push(form);
						}
					});
				}
			}

			return filtered;
		};
	}
]);

app.filter('filterTags', [
	function() {
		return function(formWithTags, keyword) {
			let filtered = [];
			let forms = [];
			var reg = new RegExp(keyword, 'i');

			if (formWithTags) {
				angular.forEach(formWithTags, function(tag) {
					forms = [];

					tag.loadAllWorkflows = false;

					if (reg.test(tag.name)) {
						tag.loadAllWorkflows = true;
						filtered.push(tag);
					} else {
						_.forEach(tag.forms, function(form) {
							if (reg.test(form.entity.workflowName)) {
								forms.push(form);
								return false;
							}
						});

						if (forms.length) {
							filtered.push(tag);
						}
					}
				});
			}

			return filtered;
		};
	}
]);

export default app;
