/**
 * @author kharkut
 */
import { formsModule } from 'common/js/modules';
import 'modules/forms/js/services/forms.svc.js';
import 'modules/forms/js/filter/forms.filter.js';
import 'modules/forms/js/directives/forms.directive.js';

export class FormsController {
	constructor($scope, cvUtil, $stateParams, formsModuleService, $location, cvLoc) {
		const FULL_PAGE_CONTAINER = '#formContainer';
		this.cvUtil = cvUtil;
		this.$stateParams = $stateParams;
		this.$scope = $scope;

		let vm = this;
		let activeTab = 0;

		vm.$scope.keyword = '';
		vm.$scope.loading = true;

		let wfInfo = {};
		let invokeForm = false;
		let url = $location.url();
		let wfParams = Forms.getWorkflowParams(url);
		Forms.populateLocalizedStringMap();

		if (wfParams.workflowId) {
			activeTab = 0;
			invokeForm = true;
			wfInfo.workflowId = wfParams.workflowId;
		}

		if (wfParams.workflowName) {
			activeTab = 0;
			invokeForm = true;
			wfInfo.workflowName = wfParams.workflowName;
		}

		if (wfParams.interactionId) {
			activeTab = 1;
			invokeForm = true;
			wfInfo.interactionId = wfParams.interactionId;
		}
		if (wfParams.interactionName) {
			activeTab = 1;
			invokeForm = true;
			wfInfo.interactionName = wfParams.interactionName;
		}

		if (invokeForm) {
			wfInfo.targetElement = FULL_PAGE_CONTAINER;
			wfInfo.invokedFromACFormsURL = true;
			wfInfo.acURL = $location.url();
			openForm(wfInfo);
		}

		vm.$scope.activeTab = activeTab;

		vm.$scope.actionsTabClicked = function() {
			vm.$scope.isActionsTab = true;
		};

		vm.$scope.loadForms = function() {
			vm.$scope.isActionsTab = false;
			vm.$scope.showError = false;
			if (!vm.$scope.formWithTags) {
				formsModuleService.getForms().success(function(data) {
					if (data.errorCode && data.errorCode === 1) {
						vm.$scope.showError = true;
						vm.$scope.errorMessage = cvLoc('error.workflows.loading');
					} else if (data.container) {
						var workflowList = data.container;
						var tagMap = {};
						var tagList = [];
						var unTaggedWorkflows = [];
						let index = 0;

						for (index = 0; index < workflowList.length; index++) {
							var currWorkflow = workflowList[index];
							if (currWorkflow.tags && currWorkflow.tags != '') {
								var tags = currWorkflow.tags.split(';');
								for (var tagIndex = 0; tagIndex < tags.length; tagIndex++) {
									var currTag = tags[tagIndex];
									var tagWorkflows = tagMap[currTag];
									if (tagWorkflows == undefined) {
										tagWorkflows = [];
									}
									tagWorkflows.push(currWorkflow);
									tagMap[currTag] = tagWorkflows;
									if (tagList.indexOf(currTag) == -1) {
										tagList.push(currTag);
									}
								}
							} else {
								unTaggedWorkflows.push(currWorkflow);
							}
						}

						//sort tag names
						tagList.sort();

						var unTaggedTitle = '';
						if (tagList.length > 0) {
							unTaggedTitle = 'Untagged';
						}

						let formWithTags = [];

						for (index = 0; index < tagList.length; index++) {
							var currTag = tagList[index];
							formWithTags.push({
								id: 'wfTag_' + index,
								name: currTag,
								forms: tagMap[currTag]
							});
						}

						if (unTaggedWorkflows.length) {
							formWithTags.push({
								id: 'wfTag_' + index,
								name: unTaggedTitle,
								forms: unTaggedWorkflows
							});
						}

						vm.$scope.formWithTags = formWithTags;
					}
					vm.$scope.pendingActions = data.pendingActions;
					vm.$scope.loading = false;
					/*
					 * if(vm.$scope.pendingActions && vm.$scope.pendingActions > 0){ vm.$scope.activeTab = 1; }
					 */
				});
			}
		};

		vm.$scope.openWorkflow = function($event, form) {
			$event.preventDefault();
			openForm({ workflowId: form.entity.workflowId, targetElement: FULL_PAGE_CONTAINER });
		};
	}
}

FormsController.$inject = ['$scope', 'cvUtil', '$stateParams', 'formsModuleService', '$location', 'cvLoc'];

formsModule.controller('FormsController', FormsController);
