<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.emailTemplate"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.events"></cv:cvMessages>
</script>
<div class="row bootstrap-wrapper">
    <div class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
        <form name="emailTemplate" class="form-horizontal cv-email-template-detail" ng-submit="vm.handleEdit()" novalidate autocomplete="off" ng-if="!vm.isLoading">
			<h1 class="page-header">{{ vm.getPageTitle() }} <span class="paran-text" data-ng-show="!vm.isNewTemplate()">{{vm.getEmailType()}}</span></h1>
            <div class="panel panel-default">
                <div class="panel-body">
					<div class="form-group">
						<label class="col-xs-12 col-lg-3" for="templateName"><cv:msg key="emailTemplates.label.templateName" bundle="emailTemplate"/></label>
						<div class="col-xs-12 col-lg-6">
							<input type="text" name="templateName" id="templateName" ng-model="vm.emailTemplate.name" required />
							<span class="help-block" ng-show="vm.requiredFieldHasError(emailTemplate.templateName)"><cv:msg key="emailTemplates.msg.error.name" bundle="emailTemplate"/></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-xs-12 col-lg-3" for="templateDesc"><cv:msg key="header.description" bundle="events"/></label>
						<div class="col-xs-12 col-lg-6">
							<textarea name="templateDesc" id="templateDesc" ng-model="vm.emailTemplate.description" required></textarea>
							<span class="help-block" ng-show="vm.requiredFieldHasError(emailTemplate.templateDesc)"><cv:msg key="emailTemplates.msg.error.description" bundle="emailTemplate"/></span>
						</div>
					</div>
					<div class="form-group" data-ng-show="vm.isNewTemplate()">
						<label class="col-xs-12 col-lg-3" for="templateType"><cv:msg key="emailTemplates.label.emailType" bundle="emailTemplate"/></label>
						<div class="col-xs-12 col-lg-6">
							<!-- <span class="form-readonly-disabled" ng-if="vm.emailTemplate.isDefault" title="Email type cannot be modified for default templates">{{vm.getEmailType()}} (default template)</span> -->
							<select name="templateType" ng-disabled="disableEmailType" id="templateType" ng-model="vm.emailTemplate.typeId" ng-change="vm.handleEmailTypeChange({{vm.emailTemplate.typeId}})" ng-options="emailType.id as emailType.label for emailType in vm.emailTypes"
								required></select>
							<span class="help-block" ng-show="vm.requiredFieldHasError(emailTemplate.templateType)"><cv:msg key="emailTemplates.msg.error.emailType" bundle="emailTemplate"/></span>
						</div>
					</div>
					<div class="form-group" data-ng-show="!vm.isTenantAdmin && vm.currentEmailType">
						<label class="col-xs-12 col-lg-3" for="templateCompany"><cv:msg key="label.name" bundle="subscriptions"/></label>
						<div class="col-xs-12 col-lg-6">
							 <select data-ng-show="vm.isNewTemplate() && !vm.currentEmailType.isMSPAdminOnly" name="templateCompany" id="templateCompany" ng-model="vm.emailTemplate.companyId"
							 ng-options="company.id as company.name for company in vm.companies"
								 required></select>
 							<span class="help-block" data-ng-show="vm.requiredFieldHasError(emailTemplate.templateCompany)"><cv:msg key="emailTemplates.msg.error.company" bundle="emailTemplate"/></span>
 							<span class="form-readonly" data-ng-show="vm.isNewTemplate() && vm.currentEmailType.isMSPAdminOnly">{{vm.emailTemplate.companyName}}</span>
							<span class="form-readonly" data-ng-show="!vm.isNewTemplate()">{{vm.emailTemplate.companyName}}</span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-xs-12 col-lg-3" for="templateLocale"><cv:msg key="emailTemplates.label.templateLocale" bundle="emailTemplate"/></label>
						<div class="col-xs-12 col-lg-6">
							<select name="templateLocale" id="templateLocale" ng-model="vm.emailTemplate.locale" ng-options="locale.localeId as locale.displayString for locale in vm.locales"
								required></select>
							<span class="help-block" ng-show="vm.requiredFieldHasError(emailTemplate.templateLocale)"><cv:msg key="emailTemplates.msg.error.templateLocale" bundle="emailTemplate"/></span>
						</div>
					</div>
				</div>
			</div>
			<div class="panel panel-default">
				<div class="panel-body">
					<uib-accordion close-others="true" class="text-left" >
						<div uib-accordion-group data-ng-init="vm.statusCustAddresses=false" data-is-open="vm.statusCustAddresses">
							<uib-accordion-heading><i class="glyphicon"	data-ng-class="{'glyphicon-chevron-down': vm.statusCustAddresses, 'glyphicon-chevron-right': !vm.statusCustAddresses}"></i>
							<cv:msg key="emailTemplates.label.customizedAddressFields" bundle="emailTemplate"/>
							<cv-help-component help-text="<cv:msg key="emailTemplates.msg.helpCustomization" bundle="emailTemplate"/>"></cv-help-component>
							</uib-accordion-heading>
							<div class="panel">
								<div class="form-group">
									<label class="col-xs-12 col-lg-3" for="templateFromName"><cv:msg key="emailTemplates.label.fromName" bundle="emailTemplate"/><span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span></label>
									<div class="col-xs-12 col-lg-6">
										<input type="text" name="templateFromName" ng-model="vm.emailTemplate.fromName" id="templateFromName"  />
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-lg-3" for="templateFromEmail"><cv:msg key="emailTemplates.label.fromEmail" bundle="emailTemplate"/><span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span></label>
									<div class="col-xs-12 col-lg-6">
										<input type="text" name="templateFromEmail" ng-model="vm.emailTemplate.fromEmail" id="templateFromEmail" />
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-lg-3" for="templateCc"><cv:msg key="emailTemplates.label.cc" bundle="emailTemplate"/><span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span></label>
									<div class="col-xs-12 col-lg-6">
										<input type="text" name="templateCc" ng-model="vm.emailTemplate.cc" id="templateCc" />
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-lg-3" for="templateBcc"><cv:msg key="emailTemplates.label.bcc" bundle="emailTemplate"/><span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span></label>
									<div class="col-xs-12 col-lg-6">
										<input type="text" name="templateBcc" ng-model="vm.emailTemplate.bcc" id="templateBcc" />
									</div>
								</div>
							</div>
						</div>
					</uib-accordion>
					<!--uncomment below warning once change to load tokens are loaded based on type is done-->
					<!-- <div class="alert alert-warning" ng-if="vm.hasEmailTypeChanged()">
						<button id="emailTemplateDetail_button_#4439" type="button" class="close" ng-click="vm.handleDismissNotice()"><span aria-hidden="true">&times;</span></button> 
						<p>The email template type has changed, please note that only tokens for <strong>{{vm.emailTemplate.typeName}}</strong> will work correctly in the email Subject and Body.</p>
					</div> -->
                    <div class="form-group">
                        <label class="col-xs-12 col-lg-3" for="templateSubject">
							<cv:msg key="emailTemplates.label.subject" bundle="emailTemplate"/>
							<small data-ng-show="vm.emailTemplate.typeId">-
								<a href="javascript:void(0);" ng-click="vm.handleSubjectRestore()"><cv:msg key="emailTemplates.label.restoreDefault" bundle="emailTemplate"/></a>
								<cv-help-component help-text="<cv:msg key="emailTemplates.msg.helpRestore" bundle="emailTemplate"/>"></cv-help-component>
							</small>
						</label>
                        <div class="col-xs-12 col-lg-6">
							<input type="text" name="templateSubject" ng-model="vm.emailTemplate.subject" id="templateSubject" required />
							<span class="help-block" ng-show="vm.requiredFieldHasError(emailTemplate.templateSubject)"><cv:msg key="emailTemplates.msg.error.subject" bundle="emailTemplate"/></span>
                        </div>
					</div>
					<div class="form-group" data-ng-show="vm.emailTemplate.typeId">
						<label class="col-xs-12 col-lg-3" ><cv:msg key="emailTemplates.label.emailBody" bundle="emailTemplate"/><small> -
								<a href="javascript:void(0);" ng-click="vm.handleBodyRestore()"><cv:msg key="emailTemplates.label.restoreDefault" bundle="emailTemplate"/></a>
								<cv-help-component help-text="<cv:msg key="emailTemplates.msg.helpRestore" bundle="emailTemplate"/>"></cv-help-component>
							</small></label>
						<div class="col-xs-12">
							<div class="cv-editor" id="cv-editor"></div>
							<!-- <iframe id="emailEditorFrame" data-ng-show="vm.emailEditorFrameSrc" src="{{vm.emailEditorFrameSrc}}"  marginheight="0" marginwidth="0" frameborder="0" width="100%" style="height: 350px"></iframe> -->
						</div>
					</div>
<!-- 					<p><small> -->
<!-- 						<a href="javascript:void(0);" ng-click="vm.handlePreviewEmail()">Preview email</a> -->
<!-- 					</small></p> -->
<!-- 					<div class="form-group" ng-show="!vm.isNewTemplate()" > -->
<!-- 						<label class="col-xs-12 col-lg-3" for="testEmailReceiver">Test email receiver</label> -->
<!-- 						<div class="col-xs-12 col-lg-3"> -->
<!-- 							<input type="text" name="testEmailReceiver" id="testEmailReceiver" ng-model="vm.testEmailReceiver" /> -->
<!-- 						</div> -->
<!-- 						<div class="col-xs-12 col-lg-6"> -->
<!-- 							<button id="emailTemplateDetail_button_#0394" type="button" class="btn btn-primary cvBusyOnAjax" ng-click="vm.handleSendSample()">Send test email</button>
<!-- 						</div> -->
<!-- 					</div> -->
                </div>
			</div>
            <div class="button-container">
             	<button id="emailTemplateDetail_button_#8708" type="button" ng-show="!vm.isNewTemplate()" class="btn btn-default cvBusyOnAjax" ng-click="vm.handleDelete()"><cv:msg key="Delete" bundle="messages"/></button> 
            	<button id="emailTemplateDetail_button_#3803" type="button" class="btn btn-primary cvBusyOnAjax" ng-click="vm.handlePreviewEmail()" data-ng-show="vm.emailTemplate.typeId"><cv:msg key="emailTemplates.label.previewEmail" bundle="emailTemplate"/></button> 
            	<button id="emailTemplateDetail_button_#9127" type="button" class="btn btn-primary cvBusyOnAjax" ng-click="vm.handleSendSample()" ng-show="!vm.isNewTemplate()"><cv:msg key="emailTemplates.label.sendTestEmail" bundle="emailTemplate"/></button> 
                <button id="emailTemplateDetail_button_#9663" type="submit" class="btn btn-primary cvBusyOnAjax" ng-disabled="emailTemplate.$invalid">{{vm.getActionLabel()}}</button> 
            </div>
        </form>
    </div>
</div>