export function cellNameTemplate(label, sref) {
	return `
        <a class="crop"
            title="{{${label}}}"
            ui-sref="${sref}"
        >{{${label}}}</a>
    `;
}

export function cellClickTemplate(label, handler) {
	return `
        <a class="crop"
            title="{{${label}}}"
            ng-click="${handler}"
            href="javascript:void(0);"
        >{{${label}}}</a>
    `;
}

export function cellBooleanTemplate(showCheckmark) {
	return `<span ng-if="${showCheckmark}">✓</span>`;
}

export function cellActionTemplate(actionItems = []) {
	let templateItems = [];

	actionItems.forEach(item => {
		let ngIf = item.condition !== undefined ? ` ng-if="${item.condition}"` : '';
		templateItems.push(`
            <li${ngIf}>
                <a href="javascript:void(0)" class="ui-grid-action-items" ng-click="${item.action}">
                    ${item.label}
                </a>
            </li>
        `);
	});

	return `
        <div class="btn-group" uib-dropdown>
            <a href class="uib-dropdown-toggle" uib-dropdown-toggle><span class="grid-action-icon"></span></a>
            <ul uib-dropdown-menu class="dropdown-menu" role="menu">${templateItems.join('')}</ul>
        </div>
    `;
}

export function cloneObjectInstance(obj) {
	// this will ensure instances of classes maintain the correct prototype
	// a basic Object.assign({}, obj) would not do that
	return Object.assign(Object.create(Object.getPrototypeOf(obj)), obj);
}

// locale slugs are taken from WebContent/common/headerUserSettings.jsp#73
// Divya provided ID mappings, no mapping for pl
// this will be replaced by a new service in the following form:
// https://updatecenter.commvault.com/Form.aspx?BuildID=1100080&FormID=46599
//export const supportedLocales = [
//    {
//        id: 0,
//        locale: 'en'
//    },{
//        // this value was added due to the fact cv.locale is set to 'en_US' when not testing locally
//        // supportedLocales is also used to populate the values in the Locale select menu on the template detail page
//        // this means having this value here produces 2 English options
//        id: 0,
//        locale: 'en_US'
//    },{
//        id: 8,
//        locale: 'es'
//    },{
//        id: 3,
//        locale: 'es_MX'
//    },{
//        id: 9,
//        locale: 'de'
//    },{
//        id: 6,
//        locale: 'fr'
//    },{
//        id: 2,
//        locale: 'fr_CA'
//    },{
//        id: 7,
//        locale: 'ja'
//    },{
//        id: 11,
//        locale: 'ko'
//    },{
//        id: 10,
//        locale: 'ru'
//    },{
//        id: 1,
//        locale: 'zh'
//    },{
//        id: 13,
//        locale: 'zh_TW'
//    },{
//        id: 12, // just a guess :-)
//        locale: 'pl'
//    }
//];

export class DataModelToViewModel {
	constructor(vmMapping, dataModel) {
		this._vmMapping = vmMapping;
		this._dataModel = dataModel;

		this.mapDataToVm(vmMapping, dataModel);
	}

	get data() {
		let data = Object.assign({}, this._dataModel);
		this.mapVmToData(this._vmMapping, data);
		return data;
	}

	mapDataToVm(mapping, data = {}, vm) {
		mapping = mapping !== undefined ? mapping : this._vmMapping;
		vm = vm !== undefined ? vm : this;

		for (let vmProperty in mapping) {
			let dataProperty = mapping[vmProperty];
			if (/\./.test(dataProperty)) {
				// contains a period
				vm[vmProperty] = this._getDeepProperty(data, dataProperty);
			} else if (typeof dataProperty === 'object') {
				this.mapDataToVm(dataProperty, data[dataProperty], vm[vmProperty]);
			} else {
				vm[vmProperty] = data.hasOwnProperty(dataProperty) ? data[dataProperty] : undefined;
			}
		}
	}

	// hat tip https://stackoverflow.com/questions/6491463/accessing-nested-javascript-objects-with-string-key
	_getDeepProperty(obj = {}, propertyPath) {
		propertyPath = propertyPath.replace(/\[(\w+)\]/g, '.$1'); // convert indexes to properties
		propertyPath = propertyPath.replace(/^\./, ''); // strip a leading dot
		let properties = propertyPath.split('.');
		for (let i = 0, n = properties.length; i < n; ++i) {
			let property = properties[i];
			if (property in obj) {
				obj = obj[property];
			} else {
				return;
			}
		}
		return obj;
	}

	mapVmToData(mapping, data = {}, vm) {
		mapping = mapping !== undefined ? mapping : this._vmMapping;
		vm = vm !== undefined ? vm : this;
		for (let vmProperty in mapping) {
			let dataProperty = mapping[vmProperty];
			if (/\./.test(dataProperty)) {
				// contains a period
				data = this._setDeepProperty(data, dataProperty, vm[vmProperty]);
			} else if (typeof dataProperty === 'object') {
				this.mapVmToData(dataProperty, data[dataProperty], vm[vmProperty]);
			} else {
				// hasOwnProperty doesn't work on Class getters…
				data[dataProperty] = vm.hasOwnProperty(vmProperty) || vm[vmProperty] !== undefined ? vm[vmProperty] : undefined;
			}
		}
	}

	_setDeepProperty(obj = {}, propertyPath, value) {
		propertyPath = propertyPath.replace(/\[(\w+)\]/g, '.$1'); // convert indexes to properties
		propertyPath = propertyPath.replace(/^\./, ''); // strip a leading dot

		let properties = propertyPath.split('.');
		let propertyPathLength = properties.length;
		let updatedObj = obj;
		let deepReference = updatedObj;

		for (let i = 0; i < propertyPathLength - 1; i++) {
			let property = properties[i];
			if (deepReference[property] === undefined) {
				deepReference[property] = {};
			}
			deepReference = deepReference[property];
		}
		deepReference[properties[propertyPathLength - 1]] = value;
		return updatedObj;
	}
}
