import { emailTemplatesModule } from 'common/js/modules';

function CvEmailPreviewCtrl() {}

CvEmailPreviewCtrl.$inject = [];

function CvEmailPreviewDirective() {
	return {
		restrict: 'E',
		controllerAs: 'vm',
		scope: true,
		bindToController: {
			content: '='
		},
		controller: CvEmailPreviewCtrl,
		link: function CvEmailPreviewLink(scope, element, attrs, vm) {
			const iframe = document.createElement('iframe');

			element[0].appendChild(iframe);

			var target = jQuery(iframe).contents()[0];
			target.open();
			target.write('<!doctype html><html><head></head><body></body></html>');
			target.close();

			var iframeBody = iframe.contentDocument.body;
			var iframeHead = iframe.contentDocument.head;

			// TODO: [email customization] - remove the dynamic insertion of the css file once the master template is updated and includes basic style references

			var iframeCss = document.createElement('link');
			iframeCss.href = `${appUtil.appRoot}common/css/cvEmailPreview.normalize.css`;
			iframeCss.rel = 'stylesheet';
			iframeCss.type = 'text/css';

			iframeHead.appendChild(iframeCss);
			scope.$watch('vm.content', function() {
				iframeBody.innerHTML = vm.content;
			});
		}
	};
}

CvEmailPreviewDirective.$inject = [];

emailTemplatesModule.directive('cvEmailPreview', CvEmailPreviewDirective);

export default emailTemplatesModule;
