import { emailTemplatesModule } from 'common/js/modules';

function CvCkeditorTokensDirective() {
	return {
		restrict: 'A',
		controllerAs: 'vm',
		scope: {
			cvCkeditorTokens: '='
		},
		require: ['?ckeditor'],
		link: function CvCkeditorTokensLink(scope, element, attrs, ctrls) {
			let ckeditor = ctrls[0];

			if (ckeditor === undefined) {
				return;
			}

			let vm = scope;
			let tokenPlugin;

			vm.cvCkeditorTokens = vm.cvCkeditorTokens ? vm.cvCkeditorTokens : [];

			ckeditor.ready().then(() => {
				ckeditor.instance.on('tokensInit', function(event) {
					tokenPlugin = event.data;
					updateTokens(true);
				});
			});

			function updateTokens(init = false) {
				if (tokenPlugin === undefined) {
					return;
				}

				if (!init) {
					// hat tip http://jsfiddle.net/q8r0dkc4/
					// remove the dom elements
					angular
						.element(tokenPlugin._.panel._.iframe.$)
						.contents()
						.find('ul')
						.remove();
					// reset structure
					tokenPlugin._.items = {};
					tokenPlugin._.list._.items = {};
				}

				vm.cvCkeditorTokens.forEach(token => {
					tokenPlugin.add(token[0], token[1], token[2]);
				});

				tokenPlugin._.committed = 0;
				tokenPlugin.commit();
			}

			scope.$watch('cvCkeditorTokens', val => {
				updateTokens();
			});
		}
	};
}

CvCkeditorTokensDirective.$inject = [];

emailTemplatesModule.directive('cvCkeditorTokens', CvCkeditorTokensDirective);

export default emailTemplatesModule;
