import 'modules/emailTemplates/js/services/emailTemplates.svc.js';
import 'modules/emailTemplates/js/services/emailPreviewModal.svc.js';

import { emailTemplatesModule } from 'common/js/modules';

import {
	IS_TENANT_ADMIN,
	//CKEDITOR_TOOLBAR_WITH_TOKENS_CONFIG,
	COMPANY_COMCELL,
	COMPANY_COMCELL_ID,
	CURRENT_COMPANY_ID
} from './../constants';

// temporary localization Email Template strings
//import './../temp.localization';

// dependencies injected/need by Angular
import '../services/emailTemplates.svc';
import '../services/emailPreviewModal.svc';
//import '../directives/cvCkeditorTokens.directive';
import Editor from '../../../../common/js/directives/editor.js';
import * as uploadImage from '../../../../common/js/directives/editor-uploadImage.js';
import * as tokens from '../../../../common/js/directives/editor-tokens.js';

// list of emails sent by Admin Console which are configurable
emailTemplatesModule.controller('EmailTemplateDetailCtrl', [
	'$stateParams',
	'EmailTemplatesService',
	'EmailPreviewModalService',
	'cvLoc',
	'cvBreadcrumbsTabsFactory',
	'$state',
	'$dialogs',
	'cvToaster',
	'$q',
	'$http',
	'$document',
	'$scope',
	'$window',
	'$uibModal',
	function EmailTemplateDetailCtrl(
		$stateParams,
		EmailTemplatesService,
		EmailPreviewModalService,
		cvLoc,
		cvBreadcrumbsTabsFactory,
		$state,
		$dialogs,
		cvToaster,
		$q,
		$http,
		$document,
		$scope,
		$window,
		$modal
	) {
		let emailTemplateId = $stateParams.emailTemplateId;
		let vm = this;

		//let locales = EmailTemplatesService.getSupportedLocales();
		let ctrlAction = false;
		let cloneId;

		vm.isTenantAdmin = IS_TENANT_ADMIN;

		vm.isLoading = true;

		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('emailTemplates.label.emailTemplates'),
				// why not use state?
				link: '#emailTemplates'
			}
		]);

		vm.emailTemplate = {};
		vm.emailTypes = [];
		vm.emailTokens = [];

		//vm.locales = locales;
		vm.tokens = [];
		vm.companies = [];

		var iframeWrapperTemplateId = 0;
		if (/^new-?.*/.test(emailTemplateId)) {
			cloneId = emailTemplateId.split('new-').pop();
			ctrlAction = cloneId !== 'new' ? 'clone' : 'create';
			if (cloneId != 'new') {
				iframeWrapperTemplateId = cloneId;
			}
		} else {
			iframeWrapperTemplateId = emailTemplateId;
		}

		controllerInit();

		//    vm.editorOptions = {
		//        language: 'en',
		//        toolbar: CKEDITOR_TOOLBAR_WITH_TOKENS_CONFIG,
		//        extraPlugins: 'tokens,base64image',
		//        allowedContent: true
		//    };

		vm.testEmailReceiver = '';

		var isLeaving = false; //this is required because after confirm dialog is clicked yes, locationchangestart is fired again
		$scope.$on('$locationChangeStart', function(event, next, current) {
			var isEmailBodyModified = textEditor && textEditor.isModified();

			if (!isLeaving && isEmailBodyModified) {
				$dialogs.confirm(cvLoc('label.confirmNavigationTitle'), cvLoc('emailTemplates.msg.confirmNavigation'), {
					yesFunction: function() {
						isLeaving = true;
						$window.location.href = next;
					},
					noFunction: function() {
						event.preventDefault();
					}
				});
				event.preventDefault();
				return;
			}
		});

		function onSendEmailSuccess() {
			cvToaster.showSuccessMessage({
				message: cvLoc('emailTemplates.msg.sendEmailSuccessful')
			});
		}

		function onSendEmailFailure() {
			cvToaster.showErrorMessage({
				message: cvLoc('emailTemplates.msg.sendEmailFailure')
			});
		}

		function sendSampleMail() {
			vm.emailTemplate.sendTestEmail(vm.testEmailReceiver, vm.emailTokens).then(onSendEmailSuccess, onSendEmailFailure);
		}
		vm.handleSendSample = function() {
			let typeName = vm.emailTemplate.typeName;
			$dialogs.confirm(cvLoc('emailTemplates.label.confirmSendSample'), cvLoc('emailTemplates.msg.confirmSendSample'), {
				noFunction: function() {},
				yesFunction: function() {
					if (textEditor) {
						vm.emailTemplate.emailBody = textEditor.getText();
					}

					vm.emailTemplate.save().then(sendSampleMail);
				}
			});
		};

		vm.handleEdit = function() {
			let templateName = vm.emailTemplate.name;
			if (textEditor) {
				if (textEditor.isTextSecure() === false) {
					cvToaster.showErrorMessage({
						message:
							cvLoc('emailTemplates.msg.saveFailure', `<b>${templateName}</b><br />`) +
							cvLoc('editor.msg.error.unsecureEditorText')
					});
				} else {
					vm.emailTemplate.emailBody = textEditor.getText();
					vm.emailTemplate.save().then(onSaveSuccess, onSaveFailure);
				}
			}

			function onSaveSuccess(res) {
				textEditor.setText(emailTemplate.emailBody, true);
				cvToaster.showSuccessMessage({
					message: cvLoc('emailTemplates.msg.saveSuccessful', `<b>${templateName}</b>`)
				});

				$state.go('emailTemplates');
			}

			function onSaveFailure(err) {
				if (err && err.data) {
					cvToaster.showErrorMessage({
						message: cvLoc('emailTemplates.msg.saveFailure', `<b>${templateName}</b><br />${err.data.errorMessage}`)
					});
				}
			}
		};

		vm.handleDelete = function() {
			let templateName = vm.emailTemplate.name;

			$dialogs.confirm(
				cvLoc('emailTemplates.label.confirmDelete'),
				cvLoc('emailTemplates.msg.confirmDelete', `<b>${templateName}</b>`),
				{
					noFunction: function() {},
					yesFunction: function() {
						vm.emailTemplate.remove().then(onDeleteSuccess, onDeleteFailure);
					}
				}
			);

			function onDeleteSuccess() {
				cvToaster.showSuccessMessage({
					message: cvLoc('emailTemplates.msg.deleteSuccessful', `<b>${templateName}</b>`)
				});
				$state.go('emailTemplates');
			}

			function onDeleteFailure(err) {
				if (err) {
					cvToaster.showErrorMessage({
						message: cvLoc('emailTemplates.msg.deleteFailure', `<b>${templateName}</b>`)
					});
				}
			}
		};

		vm.handlePreviewEmail = function() {
			if (textEditor) {
				vm.emailTemplate.emailBody = textEditor.getText();
			}
			EmailPreviewModalService.openModal(vm.emailTemplate, vm.emailTokens);
		};

		vm.handleEmailTypeChange = function(oldType) {
			if (vm.emailTemplate.typeId) {
				var emailBody;
				if (textEditor) {
					emailBody = textEditor.getText();
				}
				//display confirm dialog, if user has draft template
				if (textEditor && textEditor.isModified()) {
					//if(emailBody && emailBody != ""){
					var typeChangeModal = $modal.open({
						template: `
	                		<div class="modal-header dialog-header-confirm">
								<h4 class="modal-title">
									<span class="glyphicon glyphicon-check"></span>
									{{::modCtrl.confirmLabel}}
								</h4>
							</div>

							<div class="modal-body bootstrap-wrapper">
								<div class="form-group">
									<div>{{::modCtrl.confirmMsg}}</div>
									<input id="checkbox1" class="" type="checkbox" checked="true" ng-model="modCtrl.restoreDefaultCheck"/>
	                				<label for="checkbox1">{{::modCtrl.restoreDefault}}</label>
	                			</div>
	                		</div>

							<div class="modal-footer">
									<button type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="modCtrl.cancel()">
										{{::modCtrl.no}}
									</button>
									<button type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="modCtrl.ok()">
										{{::modCtrl.yes}}
									</button>
							</div>
	                		`,
						background: 'static',
						windowClass: 'confirm-dialog',
						//ariaLabelledBy: 'deleteConfirmModal',// what?
						controllerAs: 'modCtrl',
						controller: [
							'$uibModalInstance',
							'cvLoc',
							'$scope',
							function($uibModalInstance, modalScope) {
								var self = this;

								// localization
								self.confirmLabel = cvLoc('emailTemplates.label.confirmTypeChange');
								self.confirmMsg = cvLoc('emailTemplates.msg.confirmTypeChange');
								self.yes = cvLoc('button.yes');
								self.no = cvLoc('button.no');
								self.restoreDefault = cvLoc('emailTemplates.label.restoreDefault');

								self.restoreDefaultCheck = true;
								self.ok = function() {
									if (self.restoreDefaultCheck) {
										// restore system default body and subject
										restoreBody(true);
										restoreSubject();
									} else {
										// clear the body and subject
										$scope.clearView();
										vm.emailTemplate.subject = '';
									}
									$uibModalInstance.close();
								};
								self.cancel = function() {
									vm.emailTemplate.typeId = oldType;
									$uibModalInstance.close();
								};
							}
						]
					});

					typeChangeModal.result.catch(function() {
						// if the user clicks the x button
						vm.emailTemplate.typeId = oldType;
					});
				} else {
					//vm.emailEditorFrameSrc = "emailEditorWrapper.do?templateId=" + iframeWrapperTemplateId + "&type=" + vm.emailTemplate.typeId;
					let emailType = getEmailType(vm.emailTemplate.typeId);
					vm.currentEmailType = emailType;

					if (textEditor) {
						restoreBody(true);
						restoreSubject();
						textEditor.getAndProcessTokens(vm.emailTemplate.typeId);
					} else {
						restoreBody(true, true); // restores the body and starts the Editor
						restoreSubject();
					}
				}
			}
		};

		vm.handleSubjectRestore = function() {
			let typeName = vm.emailTemplate.typeName;
			$dialogs.confirm(
				cvLoc('emailTemplates.label.confirmSubjectRestore'),
				cvLoc('emailTemplates.msg.confirmSubjectRestore', `<strong>${typeName}</strong>`),
				{
					noFunction: function() {},
					yesFunction: function() {
						restoreSubject();
					}
				}
			);
		};

		function restoreSubject() {
			EmailTemplatesService.getEmailTypeById(vm.emailTemplate.typeId, vm.emailTemplate.locale).then(emailType => {
				vm.emailTemplate.subject = emailType.defaultSubject;
			});
		}

		vm.handleBodyRestore = function() {
			let typeName = vm.emailTemplate.typeName;
			$dialogs.confirm(
				cvLoc('emailTemplates.label.confirmBodyRestore'),
				cvLoc('emailTemplates.msg.confirmBodyRestore', `<strong>${typeName}</strong>`),
				{
					noFunction: function() {},
					yesFunction: function() {
						restoreBody(true);
					}
				}
			);
		};

		function restoreBody(original, startTheEditor) {
			EmailTemplatesService.getEmailTypeById(vm.emailTemplate.typeId, vm.emailTemplate.locale).then(emailType => {
				vm.emailTemplate.emailBody = emailType.defaultBody;
				if (textEditor) {
					// kendo editor already exists
					textEditor.setText(emailType.defaultBody, original); // set it as the original text if original is true
				} else if (startTheEditor) {
					// editor needs to be started now
					startEditor({ emailBody: vm.emailTemplate.emailBody });
				}

				vm.handleDismissNotice();
			});
		}

		vm.handleDismissNotice = function() {
			let emailType = getEmailType(vm.emailTemplate.typeId);
			vm.currentEmailType = emailType;
		};

		vm.isNewTemplate = function() {
			return vm.emailTemplate.id === undefined ? true : false;
		};

		vm.hasEmailTypeChanged = function() {
			return vm.currentEmailType === undefined ? false : vm.currentEmailType.id !== vm.emailTemplate.typeId;
		};

		vm.hasCustomSubject = function() {
			let emailType = getEmailType(vm.emailTemplate.typeId);
			return emailType === undefined ? false : emailType.defaultSubject !== vm.emailTemplate.subject;
		};

		vm.hasCustomBody = function() {
			let emailType = getEmailType(vm.emailTemplate.typeId);
			return emailType === undefined ? false : emailType.defaultBody !== vm.emailTemplate.emailBody;
		};

		vm.getPageTitle = function() {
			if (vm.isNewTemplate()) {
				return cvLoc('emailTemplates.label.addTemplate');
			} else {
				return cvLoc('emailTemplates.label.editTemplate');
			}
		};

		vm.getEmailType = function() {
			if (vm.emailTemplate.typeId) {
				return getEmailType(vm.emailTemplate.typeId).label;
			}
			return '';
		};

		vm.getLocaleName = function() {
			return EmailTemplatesService.getLocaleNameById(vm.emailTemplate.locale);
		};

		vm.getActionLabel = function() {
			return vm.isNewTemplate() ? 'Create Template' : 'Save Template';
		};

		vm.requiredFieldHasError = function(field) {
			return field && field.$error.required && !field.$pristine;
		};

		function updateCommCellCompanyName() {
			if (vm.emailTemplate.companyId === 0) {
				vm.emailTemplate.companyName = COMPANY_COMCELL;
			}
		}

		// in the absence of using route resolvers, this is probably the best approach
		// to "pre-fetch" the data required for this page
		function controllerInit() {
			$q.all([
				fetchCompanies(),
				EmailTemplatesService.getEmailTypes(),
				EmailTemplatesService.getSupportedLocales()
			]).then(res => {
				vm.companies = res[0];
				vm.emailTypes = res[1];
				vm.locales = res[2];
				switch (ctrlAction) {
					case 'clone':
						EmailTemplatesService.getEmailTemplateById(cloneId).then(emailTemplate => {
							vm.emailTemplate = emailTemplate.clone();
							vm.emailTemplate.companyId = CURRENT_COMPANY_ID;
							updateCommCellCompanyName();
							vm.emailTemplate.getEmailTokens().then(updateEditorTokens);
							vm.handleDismissNotice();
							if (vm.emailTemplate.typeId) {
								//vm.emailEditorFrameSrc = "emailEditorWrapper.do?templateId=" + iframeWrapperTemplateId + "&type=" + vm.emailTemplate.typeId;
							}
							vm.isLoading = false;
							startEditor();
						});
						break;
					case 'create':
						vm.emailTemplate = EmailTemplatesService.createTemplate();
						vm.emailTemplate.companyId = CURRENT_COMPANY_ID;
						updateCommCellCompanyName();
						vm.emailTemplate.getEmailTokens().then(updateEditorTokens);
						vm.isLoading = false;
						break;
					default:
						fetchEmailTemplate(emailTemplateId).then(emailTemplate => {
							if (vm.emailTemplate.typeId) {
								//vm.emailEditorFrameSrc = "emailEditorWrapper.do?templateId=" + iframeWrapperTemplateId + "&type=" + vm.emailTemplate.typeId;
							}
							vm.isLoading = false;
							startEditor(emailTemplate);
						});
				}

				// check for url parameters
				var startingEmailType = cvUtil.getParameter('emailType');
				if (false === _.isNil(startingEmailType) && false === _.isEmpty(startingEmailType)) {
					var nType = parseInt(startingEmailType, 10); //parse with radix
					if (!isNaN(nType)) {
						// enforce the email type
						vm.emailTemplate.typeId = nType;
						vm.handleEmailTypeChange();
						// disable so the user can't change the selection
						$scope.disableEmailType = true;
					}
				}
			});
		}

		function fetchCompanies() {
			// this is actually available in 2 different services but it's probably easier to just replicate this here
			// WebContent/vsa/js/services/subscriptions.svc.js
			// WebContent/adminConsole/js/services/security.svc.js

			// this service does not return the current company?
			return $http.get('organizations.do').then(res => {
				var companyArray = res.data.map(company => {
					return {
						id: company.shortName.id,
						name: company.shortName.domainName
					};
				});
				companyArray.push({ id: COMPANY_COMCELL_ID, name: COMPANY_COMCELL });
				return companyArray;
			});
		}

		function fetchEmailTemplate(emailTemplateId) {
			let emailTemplate = EmailTemplatesService.getEmailTemplateById(emailTemplateId);

			emailTemplate.then(onRequestSuccess, onRequestFailure);

			function onRequestSuccess(res) {
				vm.emailTemplate = res;
				updateCommCellCompanyName();
				vm.emailTemplate.getEmailTokens().then(updateEditorTokens);
				vm.handleDismissNotice();
			}

			function onRequestFailure(err) {
				// TODO: [email-templates] handle error
			}

			return emailTemplate;
		}
		//	function loadTokensForTemplateType(tokens){
		//		//need to filter tokens based on type. TO DO
		////		var editorIFrame = document.getElementById('emailEditorFrame');
		////		if(editorIFrame && editorIFrame.contentWindow ){
		////			editorIFrame.contentWindow.loadTokensForType(tokens);
		////		}
		//	}
		function updateEditorTokens(tokens) {
			vm.emailTokens = tokens.map(token => {
				let name = cvLoc(`emailTemplates.token.${token.name}`);
				return [`$${token.name}$`, name, name];
			});
		}

		function getEmailType(typeId) {
			let emailType = vm.emailTypes.filter(emailType => emailType.id === typeId);
			return emailType.length === 1 ? emailType.pop() : undefined;
		}

		function startEditor(emailTemplate) {
			// starts the editor after the end of the digest cycle
			var watch = $scope.$watch(undefined, function() {
				// Wait for the end of the digest cycle for the ng-if to render
				if ($('#cv-editor')[0]) {
					watch(); // unregister the watch
					// retrieve the template and render the text editor
					if (!textEditorTemplate) {
						EmailTemplatesService.getTemplate().then(function(editorTemplate) {
							textEditorTemplate = editorTemplate.data;
							if (!textEditor) {
								textEditor = new Editor(editorParams, $('#cv-editor'), textEditorTemplate, cvLoc, {
									uploadImage: uploadImage,
									tokens: tokens
								});
								if (emailTemplate) {
									textEditor.setText(emailTemplate.emailBody, true);
								} else {
									textEditor.setText('', true);
								}
							}
							textEditor.getAndProcessTokens(vm.emailTemplate.typeId);
						});
					}
				}
			});
		}

		var editorParams = {
			maxFileSize: 500000,
			tools: [
				'bold',
				'italic',
				'underline',
				'strikethrough',
				'subscript',
				'superscript',
				'cleanFormatting',
				'tokens',
				'insertUnorderedList',
				'insertOrderedList',
				'indent',
				'outdent',
				'justifyLeft',
				'justifyCenter',
				'justifyRight',
				'justifyFull',
				'createLink',
				'unlink',
				'uploadImage',
				'formatting',
				'fontName',
				'fontSize',
				'foreColor',
				'backColor',
				'viewHtml'
			],
			getTokens: function(n) {
				return vm.emailTemplate.getEmailTokens();
			},
			processTokens: function(tokens) {
				var data = [];
				for (let i = 0; i < tokens.length; i++) {
					data.push({
						text: tokens[i].name,
						value: '$' + tokens[i].name + '$',
						title: cvLoc('emailTemplates.token.' + tokens[i].name)
					});
				}
				return data;
			}
		};
		var textEditor;
		var textEditorTemplate;
		$scope.clearView = function() {
			textEditor.setText('', true);
		};
	}
]);

export default emailTemplatesModule;
