import 'modules/emailTemplates/js/services/emailTemplates.svc.js';

import { emailTemplatesModule } from 'common/js/modules';

import { cloneObjectInstance } from '../util';

// dependencies
import '../services/emailTemplates.svc';
import '../directives/cvEmailPreview.directive';

emailTemplatesModule.controller('EmailPreviewModalCtrl', [
	'$uibModalInstance',
	'EmailTemplatesService',
	'emailTemplate',
	'emailTokens',
	'cvLoc',
	function EmailPreviewModalCtrl($uibModalInstance, EmailTemplatesService, emailTemplate, emailTokens, cvLoc) {
		let vm = this;
		let locales = EmailTemplatesService.getSupportedLocales();

		vm.emailPreview = '';

		emailTemplate.generateEmailPreview(emailTokens).then(res => {
			var locSubject = cvLoc('emailTemplates.label.subject');
			vm.emailPreview = `<div class='subject'>${locSubject} : ${res.template.subject}</div>
            <div class='emailBody'> ${res.template.emailBody}</div>`;
		});

		/**
		 * When the cancel button is pressed.
		 */
		vm.cancel = function cancel() {
			$uibModalInstance.dismiss();
		};

		vm.saveTemplate = function saveTemplate() {
			// vm.emailTemplate.save().then(onRequestSuccess, onRequestFailure);

			function onRequestSuccess(res) {
				$uibModalInstance.close(res);
			}
			function onRequestFailure(err) {
				// TODO: [email-templates] handle erro
				$uibModalInstance.dismiss(vm.emailTemplate.name);
			}
		};
	}
]);

export default emailTemplatesModule;
