<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>

<div class="row">
	<div class="col-md-12">
		<span data-ng-if="dataLoaded">
			<h1 class="float-left" data-ng-if="!distributedStorageObject.canManage" data-ng-bind="distributedStorageObject.distributedStorage.distributedStorageName"></h1>
			<div class="float-left" data-ng-if="distributedStorageObject.canManage"> <cv-changename obj='distributedStorageObjectWrapper' service-method='changeDistributedStorageName.do' callback="changeDistributedStorageNameCallback">
			</cv-changename></div>
		</span>
		<span>
			<cv-capability-links data-ng-if="dataLoaded" cv-permitted-options="permittedOptions"></cv-capability-links>
		</span>
	</div>
</div>

<div class="row">
	<div class="col-md-6" data-ng-if="dataLoaded">
		<cv-tile-component data-ac-id="distStorageDetails-label_general-subscriptions" data-title='<cv:msg key="label.general" bundle="subscriptions"/>' loader="dataLoaded">
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.clusterUrl" bundle="servers" /></span>
					<a data-ng-if= "distributedStorageObject.canManage" class="pageDetailColumn" data-ng-click="openClusterInNewTab()">{{distributedStorageObject.url}}</a>
					<span data-ng-if= "!distributedStorageObject.canManage" class="pageDetailColumn" data-ng-bind="distributedStorageObject.url"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.username" bundle="servers" /></span>
					<span class="pageDetailColumn crop" data-ng-bind="distributedStorageObject.credential.record.userName" data-ng-click="openClusterInNewTab()"></span>
				</li>
			</ul>
			<div class="page-details-box-links" data-ng-if="distributedStorageObject.canManage">
				<a href="" data-ng-click="editGeneralTile()">
					<cv:msg key="action.edit" bundle="collections" />
				</a>
			</div>
		</cv-tile-component>
	</div>
	<div class="col-md-6" data-ng-if="dataLoaded">
		<cv-security-component
		 	entity-type="securityAssociations.entityType"
		 	associations="securityAssociations.securityObject"
		 	associations-loaded="securityAssociations.loadSecurityAssociations"
		 	generic-entity="securityAssociations.genericEntity"
		></cv-security-component>
	</div>
</div>
