<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<cv-tab-nav data-ng-if="repGroupDetail.replicationGroupsDetailsLoaded"></cv-tab-nav>
<div class="row" data-ng-if="!repGroupDetail.replicationGroupsDetailsLoaded && !repGroupDetail.replicationGroupsDetailsFailed && repGroupDetail.selectedTabIndex !== 0">
	<div class="col-md-6">
		<cv-tile-component loader="repGroupDetail.replicationGroupsDetailsLoaded">
		</cv-tile-component>
		<cv-tile-component loader="repGroupDetail.replicationGroupsDetailsLoaded">
		</cv-tile-component>
	</div>

	<div class="col-md-6">
		<cv-tile-component loader="repGroupDetail.replicationGroupsDetailsLoaded">
		</cv-tile-component>
		<cv-tile-component loader="repGroupDetail.replicationGroupsDetailsLoaded">
		</cv-tile-component>
	</div>
</div>

<div class="row" data-ng-if="repGroupDetail.replicationGroupsDetailsFailed">
	<span class="col-md-12 server-message {{repGroupDetail.serverMessage.type}}" data-ng-bind="repGroupDetail.serverMessage.message"></span>
</div>

<!-- Overview tab -->
<div>
	<div data-ng-show="repGroupDetail.selectedTabIndex === 0">
		<div class="overviewTab" data-ng-if="!repGroupDetail.replicationGroupsDetailsFailed">
			<div class="row">
				<div class="col-md-6">
					<cv-tile-component title='<cv:msg key="label.replicationGroupsDetail" bundle="replicationGroups"/>' loader="repGroupDetail.replicationGroupsDetailsLoaded">
						<ul class="group list-style-secondary">
							<!-- Source hypervisor -->
							<li class="group" id="repGrpVSA-sourceClient">
								<span class="pageDetailColumn">
									<cv:msg key="header.clientName" bundle="replicationGroups"/>
								</span>

								<a href="#/servers/{{repGroupDetail.taskDetail.forUI.clientId}}"
								 data-ng-bind="repGroupDetail.taskDetail.forUI.clientName">
								 </a>
							</li>

							<!-- Destination target/hypervisor -->
							<li class="group" id="repGrpVSA-destHyperV">
								<!-- when there is no target, use destination hypervisor -->
								<span class="pageDetailColumn" data-ng-if="repGroupDetail.taskDetail.forUI.destinationLabel===null">
									<cv:msg key="header.destinationHypervisor" bundle="replicationGroups"/>
								</span>
								<span class="pageDetailColumn" data-ng-if="repGroupDetail.taskDetail.forUI.destinationLabel===null && repGroupDetail.taskDetail.forUI.destinationId === null"><cv:msg key="label.notSet" bundle="replicationGroups"/></span>

								<!-- when target is not hidden -->
								<span class="pageDetailColumn" data-ng-if="repGroupDetail.taskDetail.forUI.destinationLabel!==null"
									data-ng-bind="repGroupDetail.taskDetail.forUI.destinationLabel">
								</span>
								<span class="pageDetailColumn"  data-ng-if="!repGroupDetail.isEndUser || (repGroupDetail.isEndUser && !repGroupDetail.isRecoveryTarget)">
									<a data-ng-if="repGroupDetail.taskDetail.forUI.destinationId !== null"
								      href="{{repGroupDetail.taskDetail.forUI.destinationUrl}}"
									  data-ng-bind="repGroupDetail.taskDetail.forUI.destinationName"></a>
								</span>
								
								<span class="pageDetailColumn"  data-ng-if="repGroupDetail.isEndUser && repGroupDetail.isRecoveryTarget">
									<cv-help-text help-label="{{repGroupDetail.taskDetail.forUI.destinationName}}" help-text="'<cv:msg key='label.noTargetViewPermission' bundle='profiles'></cv:msg>'" ></cv-help-text>
								</span>
								
								<span data-ng-if="repGroupDetail.taskDetail.forUI.destinationId === null" class="pageDetailColumn"
									data-ng-bind="repGroupDetail.taskDetail.forUI.destinationName"></span>
							</li>

							<!-- Destination Vendors  -->
							 <li class="group"id="repGrpVSA-destVendor">
							 	<span class="pageDetailColumn">
							 		<cv:msg key="header.destinationVendor" bundle="vmsJs"/>
					            </span>
					            <span class="pageDetailColumn" data-ng-bind="repGroupDetail.taskDetail.forUI.vendorType"></span>
				             </li>

							<!-- State status replication group  -->
							<li class="group" id="repGrpVSA-repGrpStatus">
								<span class="pageDetailColumn">
									<cv:msg key="label.replicationType" bundle="replicationGroups"/>
								</span>
								<span class="pageDetailColumn" data-ng-bind="repGroupDetail.taskDetail.forUI.replicationType"></span>
							</li>

							<!-- Replication group status label -->
							<li class="group">
								<span class="pageDetailColumn"><cv:msg key="label.enableLiveSync" bundle="dr"/></span>
								<span class="pageDetailColumn" data-ng-disabled="repGroupDetail.editMode.enableDisable">
									<toggle-control status="!repGroupDetail.taskDetail.forUI.isDisabled"
										data-ng-click="repGroupDetail.enableDisableReplicationGroup()"></toggle-control>
								</span>
							</li>
						</ul>
					</cv-tile-component>
				</div>
			</div>

			<!-- Replication monitor (Periodic only) -->
			<div class="row col-md-12 navigation" data-ng-if="repGroupDetail.isPeriodic" >
				<cv-tile-component loader="repGroupDetail.replicationGroupsDetailsLoaded"
				data-ng-if="!repGroupDetail.replicationGroupsDetailsLoaded">
				</cv-tile-component>
				<cv-replication-monitor
					data-ng-if="repGroupDetail.replicationGroupsDetailsLoaded"
					task-id="repGroupDetail.taskId"
					app-type-id="repGroupDetail.taskDetail.forUI.appTypeId">
				</cv-replication-monitor>
				<br />
			</div>

			<!-- Replication pair (Continuous)  -->
			<div class="row col-md-12 navigation" data-ng-if="repGroupDetail.isContinuous">
				<cv-tile-component loader="repGroupDetail.replicationGroupsDetailsLoaded"
				data-ng-if="!repGroupDetail.replicationGroupsDetailsLoaded">
				</cv-tile-component>
				<cv-replication-continuous-monitor
					data-ng-if="repGroupDetail.replicationGroupsDetailsLoaded && repGroupDetail.siteInfo"
					site-info="repGroupDetail.siteInfo"
					is-detail="true"
					grid-title="repGroupDetail.gridTitle">
			     </cv-replication-continuous-monitor>
			</div>
		</div>
	</div>

	<!-- Configuration tab  -->
	<div data-ng-if="repGroupDetail.selectedTabIndex===1">
		<div class="row" data-ng-if="!repGroupDetail.replicationGroupsDetailsFailed && repGroupDetail.isPeriodic">
			<div class="profile-info col-md-6">
				<!-- RPO  -->
				<cv-tile-component
					data-ng-if="repGroupDetail.replicationGroupsDetailsLoaded"
					data-ac-id="label_sla-profiles"
					data-title='<cv:msg key="label.rpo" bundle="profiles"/>' help-text="<cv:msg key="info.help.rpo" bundle="profiles"/>{{repGroupDetail.slaHelpText}}" loader="repGroupDetail.replicationInfo">
					<ul class="group list-style-secondary"  data-ng-if="repGroupDetail.enableSimplifiedLiveSync && repGroupDetail.replicationInfo">
						<cv-replication-frequency
							show-edit="true"
							sla-info="repGroupDetail.slaInfo"
							model="repGroupDetail.model"
							profile-id="repGroupDetail.profileId"
							backup-schedule="repGroupDetail.backupSchedule">
						</cv-replication-frequency>
						<cv-replication-operation-window task-id="repGroupDetail.taskId" schedule-name="repGroupDetail.taskDetail.forUI.replicationGroupName"></cv-replication-operation-window>
					</ul>
				</cv-tile-component>

				<!-- Replication destination  -->
				<cv-tile-component
					data-title='{{repGroupDetail.model.replicationDestinationLabel}}'
					loader="repGroupDetail.replicationInfo">
					<cv-plan-storage-pool
						data-ng-if="repGroupDetail.replicationInfo"
				  		profile-details="repGroupDetail.replicationInfo"
					  	plan-sub-type="repGroupDetail.planSubType"
					  	show-edit="repGroupDetail.showEdit"
					  	data-title="repGroupDetail.model.replicationDestinationLabel">
					</cv-plan-storage-pool>

					<ul class="group list-style-secondary" data-ng-if="repGroupDetail.storagePolicyCopyList &&
					repGroupDetail.storagePolicyCopyList.length > 1">
						<li id="selectCopyForReplication" title='<cv:msg key="label.copyForReplication" bundle="replicationGroups"/>' class="group">
							<span class="pageDetail-three-columns-first" >
								<cv:msg key="label.copyForReplication" bundle="replicationGroups"/>
							</span>
							<span data-ng-if="!repGroupDetail.editMode.replicationCopy.inEditMode">
								<span class="pageDetail-three-columns-second" title='{{repGroupDetail.taskDetail.forUI.replicationCopy}}' data-ng-bind="repGroupDetail.taskDetail.forUI.replicationCopy"></span>
								<a title='<cv:msg key="action.edit" bundle="collections"/>' class="pageDetail-three-columns-third" data-ng-click="repGroupDetail.toggleEdit(repGroupDetail.CONSTANT.replicationCopy)">
									<cv:msg key="action.edit" bundle="collections"/>
								</a>
							</span>

							<span class="pageDetailColumn inline-editor"
							data-ng-if="repGroupDetail.editMode.replicationCopy.inEditMode"
							data-ng-disabled="repGroupDetail.editMode.replicationCopy.isLoading">
								<div class="inline-editor-input">
									<isteven-multi-select id="replicationCopy_isteven-multi-select_#5064"
									input-model="repGroupDetail.storagePolicyCopyList"
									output-model="repGroupDetail.storagePolicy"
									button-label="copyName"
									item-label="copyName"
									tick-property="selected"
									directive-id="replicationCopyId"
									search-property="copyName" helper-elements="reset filter"
									max-labels="1"
									selection-mode="single"></isteven-multi-select>
								</div>
								<span class="inline-editor-buttons">
									<a title='<cv:msg key="label.confirmAction" bundle="replicationGroups"/>' class="horizontal-link-button"
									data-ng-click="repGroupDetail.updateSelectedValues(repGroupDetail.storagePolicy, repGroupDetail.CONSTANT.replicationCopy)">
									<i class="glyphicon glyphicon-ok"></i></a>
									<a title='<cv:msg key="button.cancel" bundle="replicationGroups"/>' data-ng-click="repGroupDetail.updateSelectedValues(null, repGroupDetail.CONSTANT.replicationCopy)"><i class="glyphicon glyphicon-remove"></i></a>
								</span>
							</span>
						</li>
					</ul>
				</cv-tile-component>
			</div>

			<!-- Advance Options  -->
			<div class="col-md-6" data-ng-if="repGroupDetail.isPeriodic && repGroupDetail.replicationGroupsDetailsLoaded">
				<cv-tile-component  data-ac-id="replicationGroupsDetail-label_replicationGroupsDetail-advancedOptions" title='<cv:msg key="label.advanced.options" bundle="restore"/>'>
					<ul class="group list-style-secondary" >
						<!-- VM Power On/OFF  -->
						<li class="group" id="repGrpVSA-powerOnVmAfterRestore"
						 data-ng-if="repGroupDetail.showPowerOnOption" title='<cv:msg key="label.powerOn.replication" bundle="restore"/>'>
							<span class="pageDetailColumn"><cv:msg key="label.powerOn.replication" bundle="restore"/></span>
							<span class="pageDetail-three-columns-second"
							data-ng-disabled="repGroupDetail.editMode.powerOnVmAfterRestore"
							title='{{repGroupDetail.updateToolTips(repGroupDetail.CONSTANT.powerOnVmAfterRestore)}}'>
								<toggle-control status="repGroupDetail.toggleStatus.powerOnVmAfterRestore"
								data-ng-click="repGroupDetail.toggleControlClick(repGroupDetail.CONSTANT.powerOnVmAfterRestore)"></toggle-control>
							</span>
						</li>

						<!-- Disk Provision - Can't edit -->
						<li data-ng-if="repGroupDetail.taskDetail.forUI.diskOption"
						id="repGrpVSA-diskProvisioning"
						title='<cv:msg key="label.diskProvisioning" bundle="collectionsJs"/>' class="group">
							<span class="pageDetailColumn" title='<cv:msg key="label.diskProvisioning" bundle="collectionsJs"/>' >
								<cv:msg key="label.diskProvisioning" bundle="collectionsJs"/></span>
							</span>
							<span title='{{repGroupDetail.taskDetail.forUI.diskOption}}' class="pageDetailColumn" data-ng-bind="repGroupDetail.taskDetail.forUI.diskOption"></span>
						</li>

						<!-- Transport mode -->
						<li data-ng-if="repGroupDetail.taskDetail.forUI.transportMode" title='<cv:msg key="header.transportMode" bundle="vmsJs"/>' id="repGrpVSA-transportMode" class="group">
							<span class="pageDetail-three-columns-first" >
								<cv:msg key="header.transportMode" bundle="vmsJs"/>
							</span>
							<span data-ng-if="!repGroupDetail.editMode.transportMode.inEditMode">
								<span class="pageDetail-three-columns-second lesser-width" title='{{repGroupDetail.taskDetail.forUI.transportMode}}' data-ng-bind="repGroupDetail.taskDetail.forUI.transportMode"></span>
								<a title='<cv:msg key="action.edit" bundle="collections"/>' class="pageDetail-three-columns-third" data-ng-click="repGroupDetail.toggleEdit(repGroupDetail.CONSTANT.transportMode)">
									<cv:msg key="action.edit" bundle="collections"/>
								</a>
							</span>

							<span class="pageDetail-three-columns-second lesser-width inline-editor" data-ng-if="repGroupDetail.editMode.transportMode.inEditMode"
							data-ng-disabled="repGroupDetail.editMode.transportMode.isLoading">
								<div class="inline-editor-input">
									<isteven-multi-select id="transportMode_isteven-multi-select_#5064"
									input-model="repGroupDetail.transportModeTypes" output-model="repGroupDetail.selectedTransportMode"
									output-properties="value id selected name" button-label="name"
									item-label="name"
									tick-property="selected"
									directive-id="transportModeId"
									search-property="name" helper-elements="reset filter"
									max-labels="1"
									selection-mode="single"></isteven-multi-select>
								</div>
								<span class="inline-editor-buttons">
									<a title='<cv:msg key="label.confirmAction" bundle="replicationGroups"/>' class="horizontal-link-button"
									data-ng-click="repGroupDetail.updateSelectedValues(repGroupDetail.selectedTransportMode, repGroupDetail.CONSTANT.transportMode)">
									<i class="glyphicon glyphicon-ok"></i></a>
									<a title='<cv:msg key="button.cancel" bundle="replicationGroups"/>' data-ng-click="repGroupDetail.updateSelectedValues(null, repGroupDetail.CONSTANT.transportMode)"><i class="glyphicon glyphicon-remove"></i></a>
								</span>
							</span>
						</li>

						<!-- passUnconditionalOverride -->
						<li class="group" data-ng-if="repGroupDetail.taskDetail.forUI.showPassUnconditionalOverwrite" id="repGrpVSA-passUnconditionalOverride"><span class="pageDetailColumn">
							<cv:msg key="warning.overwriteVM" bundle="restore"/></span>

							<span class="pageDetail-three-columns-second" for="passUnconditionalOverride"
							data-ng-disabled="repGroupDetail.editMode.passUnconditionalOverride"
							title='{{repGroupDetail.updateToolTips(repGroupDetail.CONSTANT.passUnconditionalOverride)}}'>
								<toggle-control status="repGroupDetail.toggleStatus.passUnconditionalOverride"
								for="passUnconditionalOverride"
								data-ng-click="repGroupDetail.toggleControlClick(repGroupDetail.CONSTANT.passUnconditionalOverride)"></toggle-control>
							</span>
						</li>

						<!-- deployVmWhenFailover -->
						<li class="group" data-ng-if="repGroupDetail.showDeployVmWhenFailover" id="repGrpVSA-deployVmWhenFailover"><span class="pageDetailColumn"><cv:msg key="label.deployVmDuringFailover" bundle="replicationGroups"/></span>
							<span class="pageDetail-three-columns-second"
							data-ng-disabled="repGroupDetail.editMode.deployVmWhenFailover"
							title='{{repGroupDetail.updateToolTips(repGroupDetail.CONSTANT.deployVmWhenFailover)}}'>
								<toggle-control status="repGroupDetail.toggleStatus.deployVmWhenFailover"
								data-ng-click="repGroupDetail.toggleControlClick(repGroupDetail.CONSTANT.deployVmWhenFailover)"></toggle-control>
							</span>
						</li>

							<!-- Snapshot on Source -->
						<li data-ng-if="repGroupDetail.taskDetail.forUI.showSnapshotEngine" title='<cv:msg key="label.snapshotEngineOnSource" bundle="replicationGroups"/>'
						id="repGrpVSA-snapShotEngine" class="group">
							<span class="pageDetail-three-columns-first" >
								<cv:msg key="label.snapshotEngineOnSource" bundle="replicationGroups"/>
							</span>
							<span data-ng-if="!repGroupDetail.editMode.snapShotEngine.inEditMode">
								<span class="pageDetail-three-columns-second lesser-width" title='{{repGroupDetail.taskDetail.forUI.snapShotEngine}}' data-ng-bind="repGroupDetail.taskDetail.forUI.snapShotEngine"></span>
								<a title='<cv:msg key="action.edit" bundle="collections"/>' class="pageDetail-three-columns-third" data-ng-click="repGroupDetail.toggleEdit(repGroupDetail.CONSTANT.snapShotEngine)" data-ng-if="repGroupDetail.showSnapEdit">
									<cv:msg key="action.edit" bundle="collections"/>
								</a>
							</span>

							<span class="pageDetail-three-columns-second lesser-width inline-editor" data-ng-if="repGroupDetail.editMode.snapShotEngine.inEditMode"
							data-ng-disabled="repGroupDetail.editMode.snapShotEngine.isLoading">
								<div class="inline-editor-input">
									<isteven-multi-select id="snapShotEngine_isteven-multi-select_#5064"
									input-model="repGroupDetail.snapEngineList" output-model="repGroupDetail.selectedSnapShotEngine"
									button-label="name"
									item-label="name"
									tick-property="selected"
									directive-id="snapShotEngineId"
									search-property="name" helper-elements="reset filter"
									max-labels="1"
									selection-mode="single"></isteven-multi-select>
								</div>
								<span class="inline-editor-buttons">
									<a title='<cv:msg key="label.confirmAction" bundle="replicationGroups"/>' class="horizontal-link-button"
									data-ng-click="repGroupDetail.updateSelectedValues(repGroupDetail.selectedSnapShotEngine, repGroupDetail.CONSTANT.snapShotEngine)">
									<i class="glyphicon glyphicon-ok"></i></a>
									<a title='<cv:msg key="button.cancel" bundle="replicationGroups"/>' data-ng-click="repGroupDetail.updateSelectedValues(null, repGroupDetail.CONSTANT.snapShotEngine)"><i class="glyphicon glyphicon-remove"></i></a>
								</span>
							</span>
						</li>

						<!-- Max snapshots per DRVM  -->
						<li data-ng-if="repGroupDetail.taskDetail.forUI.showMaxSnapshot" title='<cv:msg key="label.noOfRecoveryPoints" bundle="serversJs"/>'
						id="repGrpVSA-nMaxSnapshotsPerDRVM" class="group">
							<span class="pageDetail-three-columns-first" >
								<cv:msg key="label.noOfRecoveryPoints" bundle="serversJs" />
							</span>
							<span data-ng-if="!repGroupDetail.editMode.nMaxSnapshotsPerDRVM.inEditMode">
								<span class="pageDetail-three-columns-second lesser-width" title='{{repGroupDetail.taskDetail.forUI.nMaxSnapshotsPerDRVM}}' data-ng-bind="repGroupDetail.taskDetail.forUI.nMaxSnapshotsPerDRVM"></span>
								<a title='<cv:msg key="action.edit" bundle="collections"/>' class="pageDetail-three-columns-third" data-ng-click="repGroupDetail.toggleEdit(repGroupDetail.CONSTANT.nMaxSnapshotsPerDRVM)">
									<cv:msg key="action.edit" bundle="collections"/>
								</a>
							</span>

							<span class="pageDetail-three-columns-third lesser-width inline-editor" data-ng-if="repGroupDetail.editMode.nMaxSnapshotsPerDRVM.inEditMode"
							data-ng-disabled="repGroupDetail.editMode.nMaxSnapshotsPerDRVM.isLoading">
								<div class="inline-editor-input">
									<input type="number"
										id="nMaxSnapshotsPerDRVM"
										name="nMaxSnapshotsPerDRVM"
										data-ng-model="repGroupDetail.taskDetail.forUI.nMaxSnapshotsPerDRVM"
										min="0" max="10"
										step="1"
										data-ng-change="repGroupDetail.maxSnapshotChanged(repGroupDetail.taskDetail.forUI.nMaxSnapshotsPerDRVM)"/>
								</div>
								<span class="inline-editor-buttons">
									<a title='<cv:msg key="label.confirmAction" bundle="replicationGroups"/>'
									class="horizontal-link-button"
									data-ng-click="repGroupDetail.updateSelectedValues(repGroupDetail.taskDetail.forUI.nMaxSnapshotsPerDRVM, repGroupDetail.CONSTANT.nMaxSnapshotsPerDRVM)">
										<i class="glyphicon glyphicon-ok"></i>
									</a>
									<a title='<cv:msg key="button.cancel" bundle="replicationGroups"/>' data-ng-click="repGroupDetail.updateSelectedValues(null, repGroupDetail.CONSTANT.nMaxSnapshotsPerDRVM, repGroupDetail.taskDetail.nMaxSnapshotsPerDRVM, true)"><i class="glyphicon glyphicon-remove"></i></a>
								</span>
							</span>

							<div data-ng-if="repGroupDetail.nMaxSnapshotsError.message">
								<span class="col-xs-6"  ></span>
								<span class="pageDetailColumn error small"
								data-ng-bind="repGroupDetail.nMaxSnapshotsError.message" ></span>
							</div>
						</li>


					</ul>
				</cv-tile-component>
			</div>
			<!--End Advance Options  -->
		</div>
		
		<div class="col-md-6" data-ng-if="repGroupDetail.isContinuous">
			<!-- Recovery type -->
			<cv-tile-component
				data-ng-if="repGroupDetail.replicationGroupsDetailsLoaded"
				data-ac-id="label_recoveryOptions"
				data-title='<cv:msg key="label.recoveryOptions" bundle="blrJs"/>'
				loader="repGroupDetail.replicationInfo">
				<ul class="group list-style-secondary" 
					data-ng-if="repGroupDetail.enableSimplifiedLiveSync && repGroupDetail.replicationInfo">
					<li class="group"><span class="pageDetailColumn"><cv:msg key="label.recoveryType" bundle="vmsJs"></cv:msg></span>
						<span class="pageDetailColumn" data-ng-bind="repGroupDetail.blrDetailInfo.additionalInfo.recoveryType"></span></li>
				
					<div data-ng-if='repGroupDetail.blrDetailInfo.blrRecoveryOpts.recoveryType === "GRANULARV2"'>
						<li class="group"><span class="pageDetailColumn"><cv:msg key="label.rpStore" bundle="blrJs"/></span>
							<span class="pageDetailColumn" data-ng-bind="repGroupDetail.blrDetailInfo.blrRecoveryOpts.granularV2.rpStoreName"></span></li>
						<li class="group"><span class="pageDetailColumn"><cv:msg key="label.ccrpInterval" bundle="blrJs"/></span>
							<span class="pageDetailColumn" data-ng-bind="repGroupDetail.blrDetailInfo.additionalInfo.ccrpInterval"></span></li>
						<li class="group" data-ng-if="repGroupDetail.blrDetailInfo.additionalInfo.acrpInterval"><span class="pageDetailColumn"><cv:msg key="label.acrpInterval" bundle="blrJs"/></span>
							<span class="pageDetailColumn" data-ng-bind="repGroupDetail.blrDetailInfo.additionalInfo.acrpInterval"></span></li>
						<li class="group" data-ng-if="repGroupDetail.blrDetailInfo.additionalInfo.rpMergeDelay"><span class="pageDetailColumn"><cv:msg key="label.rpMergeDelay" bundle="blrJs"/></span>
							<span class="pageDetailColumn" data-ng-bind="repGroupDetail.blrDetailInfo.additionalInfo.rpMergeDelay"></span></li>
						<li class="group"><span class="pageDetailColumn"><cv:msg key="label.rpRetention" bundle="blrJs"/></span>
							<span class="pageDetailColumn" data-ng-bind="repGroupDetail.blrDetailInfo.additionalInfo.rpRetention"></span></li>
						<li class="group" data-ng-if="repGroupDetail.blrDetailInfo.additionalInfo.maxRpInterval"><span class="pageDetailColumn"><cv:msg key="label.maxRpInterval" bundle="blrJs"/></span>
							<span class="pageDetailColumn" data-ng-bind="repGroupDetail.blrDetailInfo.additionalInfo.maxRpInterval"></span></li>
						<li class="group" data-ng-if="repGroupDetail.blrDetailInfo.additionalInfo.maxRpStoreOfflineTime"><span class="pageDetailColumn"><cv:msg key="label.maxRpStoreOfflineTime" bundle="blrJs"/></span>
							<span class="pageDetailColumn" data-ng-bind="repGroupDetail.blrDetailInfo.additionalInfo.maxRpStoreOfflineTime"></span></li>
						<li class="group"><span class="pageDetailColumn"><cv:msg key="label.useOffPeakSchedule" bundle="blrJs"/></span>
							<span class="pageDetailColumn" data-ng-bind="repGroupDetail.blrDetailInfo.additionalInfo.useOffPeakSchedule"></span></li>
					</div>
								
					<!-- State status replication group  -->
					<li class="group" id="repGrpVSA-repGrpStatus">
						<span class="pageDetailColumn"
							<cv:msg key="label.replicationType" bundle="replicationGroups"/>
						</span>
						<span class="pageDetailColumn" data-ng-bind="repGroupDetail.taskDetail.forUI.blrRecoveryOpts.replicationType"></span>
					</li>
				</ul>
				
				<div class="page-details-box-links" data-ng-if="repGroupDetail.taskDetail.forUI.showEditRecoveryOptions">
					<span><a class="page-action-item" href="" 
						data-ng-click="repGroupDetail.openEditRecoveryOptionsModal()"> <cv:msg
								key="action.edit" bundle="collections" />
					</a>
					</span>
				</div>
			</cv-tile-component>
		</div>

		<div class="col-md-6" data-ng-if="repGroupDetail.showAdvOptionsContinuous">
			<!-- Recovery type -->
			<cv-tile-component
				data-ng-if="repGroupDetail.replicationGroupsDetailsLoaded"
				data-ac-id="label_advancedOptions"
				data-title='<cv:msg key="label.advanced.options" bundle="restore"/>'
				loader="repGroupDetail.replicationInfo">
				<ul class="group list-style-secondary" >
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.guestCredentialsUserName" bundle="replicationGroups"></cv:msg></span>
						<span class="pageDetailColumn" data-ng-bind="repGroupDetail.taskDetail.forUI.vmGuestUserName"></span>
					</li>
				</ul>
			</cv-tile-component>
		</div>

		<!-- Replication configuration -->
		<div class="row col-md-12 navigation">
			<cv-tile-component
				data-ng-if="!repGroupDetail.replicationGroupsDetailsLoaded"
				loader="repGroupDetail.replicationGroupsDetailsLoaded"
				data-title='<cv:msg key="label.replicaitonGroupOptions" bundle="replicationGroups"/>' >

			</cv-tile-component>

			<cv-replication-groups-summary
				data-ng-if="repGroupDetail.showSummaryGrid"
				advanced-rst-options="repGroupDetail.taskDetail.forUI.advancedRstOptions"
				edit-mode="true"
				task-info="repGroupDetail.taskInfo"
				add="true"
				remove="true"
				vendor="repGroupDetail.taskDetail.forUI.vendorType"
				replication-type="repGroupDetail.taskDetail.forUI.replicationType"
				is-detail-page="true">
		     </cv-replication-groups-summary>

		     <cv-add-vm-content-directive 
		     	data-ng-if="repGroupDetail.showRulesGrid"
		     	vendor="repGroupDetail.taskDetail.sourceVendor" 
		     	client-id="repGroupDetail.taskDetail.forUI.clientId" 
		     	ctrl="repGroupDetail.ctrl"
				selected-content="repGroupDetail.selectedContent"
				show-add-rules="true">
			</cv-add-vm-content-directive>
		</div>
	</div>  <!--END CONFIGURATION TAB  -->
</div> <!-- END NEW UI  -->
