<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvEnum name="CvEntities.VMAllocationPolicyType"></cv:cvEnum>
	<cv:cvEnum name="TMMsg.DRReplicationType"></cv:cvEnum>
</script>
<div class="bootstrap-wrapper">
	<div class="panel panel-default setup-panel">
		<div class="panel-body setup-content">
			<div class="row">
				<div class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
					<form class="form-horizontal" id="repgrpSummaryForm" name="repgrpSummaryForm" autocomplete="off" cv-submit="repGrpSummaryCtrl.submitReplicationGroupTask()" cv-hide-api>
						<span data-ng-if="repGrpSummaryCtrl.serverMessage" class="col-xs-12 text-center server-message {{repGrpSummaryCtrl.serverMessage.type}}">{{repGrpSummaryCtrl.serverMessage.message}}</span>
						<div class="row">
							<div class="col-xs-12 col-md-6">
								<cv-tile-component data-title='<cv:msg key="label.selectContent" bundle="vmsJs" />'>
									<ul class="group list-style-secondary">
										<li class="group">
											<span class="pageDetailColumn"><cv:msg key="label.name" bundle="vmsJs"></cv:msg></span>
											<span class="pageDetailColumn" data-ng-bind="replicationGroup.name"></span>
										</li>
										<li class="group">
											<span class="pageDetailColumn"><cv:msg key="label.sourceHypervisor" bundle="dr"></cv:msg></span>
											<span data-ng-if="repGrpSummaryCtrl.sourceHyperVisor" class="pageDetailColumn" data-ng-bind="repGrpSummaryCtrl.sourceHyperVisor"></span>
										</li>
										<li class="group">
											<span class="pageDetailColumn"><cv:msg key="label.sourceVendor" bundle="replicationGroups"/></span>
											<span class="pageDetailColumn" data-ng-bind="repGrpSummaryCtrl.sourceVendor"></span>
										</li>
									</ul>
								</cv-tile-component>
							</div>
							<div class="col-xs-12 col-md-6">
								<cv-tile-component data-title='<cv:msg key="label.selectTarget" bundle="vmsJs" />'>
									<ul class="group list-style-secondary">
										<li class="group">
											<span class="pageDetailColumn"><cv:msg key="label.replicationTarget" bundle="restoreJs" /></span>
											<span class="pageDetailColumn" data-ng-bind="repGrpSummaryCtrl.selectedTarget"></span>
										</li>
										<li class="group" data-ng-if="repGrpSummaryCtrl.enableContinuousReplication">
											<span class="pageDetailColumn"><cv:msg key="label.replicationType" bundle="replicationGroups"/></span>
											<span class="pageDetailColumn" data-ng-bind="repGrpSummaryCtrl.replicationTypeText"></span>
										</li>
										<li class="group" id="destinationHypervisor" data-ng-if="repGrpSummaryCtrl.showDestinationHypervisor">
											<span class="pageDetailColumn"><cv:msg key="header.destinationHypervisor" bundle="replicationGroups"/></span>
											<span class="pageDetailColumn" data-ng-bind="repGrpSummaryCtrl.destinationHyperV.clientName"></span>
										</li>
										<li class="group">
											<span class="pageDetailColumn"><cv:msg key="header.destinationVendor" bundle="vmsJs"/></span>
											<span class="pageDetailColumn" data-ng-bind="repGrpSummaryCtrl.destinationVendorUI"></span>
										</li>
										<li class="group" data-ng-if="replicationGroup.replicationType === 1">	<!-- Periodic type -->
											<span class="pageDetailColumn"><cv:msg key="label.frequency" bundle="schedule" /></span>
											<span class="pageDetailColumn">
												<cv:msg key="label.incrementalFrequencyText" bundle="profiles"/> 
												<span data-ng-bind="replicationGroup.rpo.count" /> 
												<span data-ng-bind="replicationGroup.rpo.freq.name" />
											</span>
										</li>
									</ul>
								</cv-tile-component>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-12 col-md-6">
								<cv-tile-component data-title='<cv:msg key="label.storageCache" bundle="replicationGroups" />'>
									<div data-ng-switch="replicationGroup.replicationType">
										<!-- Periodic -->
										<div data-ng-switch-when="1">
											<ul class="group list-style-secondary">
												<li class="group" data-ng-if="replicationGroup.recoveryOptions.isSnapbackupEnabled">
													<span class="pageDetailColumn"><cv:msg key="label.useSnapshotOnSource" bundle="replicationGroups" /></span>
													<span class="pageDetailColumn" data-ng-bind="replicationGroup.recoveryOptions.snapEngine[0].name"></span>
												</li>
												<li class="group">
													<span class="pageDetailColumn"><cv:msg key="label.storage" bundle="storage"/></span>
													<span class="pageDetailColumn" data-ng-bind="repGrpSummaryCtrl.storageNames"></span>
												</li>
												<li class="group" id="enableSecondaryCopy" data-ng-if="replicationGroup.recoveryOptions.copy.enableSecondaryCopy">
													<span class="pageDetailColumn"><cv:msg key="label.replicateUsingSecondaryCopy" bundle="replicationGroups"/></span>
													<span class="pageDetailColumn"><cv:msg key="label.yes" bundle="messages" /> (<span data-ng-bind="replicationGroup.recoveryOptions.copy.secondary.storage[0].name"></span>)</span>
												</li>
											</ul>
										</div>
										<!-- Continuous -->
										<div data-ng-switch-when="2">
											<ul class="group list-style-secondary">
												<li class="group">
													<span class="pageDetailColumn"><cv:msg key="label.recoveryType" bundle="vmsJs" /></span>
													<span class="pageDetailColumn" data-ng-bind="replicationGroup.blrRecoveryOpts.type.name"></span>
												</li>
												<!-- Point in time recovery -->
												<li class="group" data-ng-if="replicationGroup.blrRecoveryOpts.recoveryType === 4">
													<span class="pageDetailColumn"><cv:msg key="label.rpStore" bundle="vmsJs"/></span>
													<span class="pageDetailColumn" data-ng-bind="replicationGroup.blrRecoveryOpts.rpStore[0].rpStoreName"></span>
												</li>
												<li class="group">
													<span class="pageDetailColumn"><cv:msg key="label.storage" bundle="storage"/></span>
													<span class="pageDetailColumn" data-ng-bind="repGrpSummaryCtrl.storageNames"></span>
												</li>
											</ul>
										</div>
									</div>
								</cv-tile-component>
							</div>
							<div class="col-xs-12 col-md-6">
								<cv-tile-component data-title='<cv:msg key="label.overrideOptions" bundle="vmsJs" />' data-ng-if="!repGrpSummaryCtrl.isOverrideOptionsNotEligible">
									<ul class="group list-style-secondary">
										<li class="group">
											<span class="pageDetailColumn"><cv:msg key="label.overrideVMs" bundle="replicationGroups"></cv:msg></span>
											<span class="pageDetailColumn" ng-cloak>{{replicationGroup.enableOverrideOptions ? 'button.yes': 'button.no' | cvLoc}}</span>
										</li>
									</ul>
								</cv-tile-component>
							</div>
						</div>
						<div class="row" data-ng-if="repGrpSummaryCtrl.advancedRstOptions && repGrpSummaryCtrl.summaryOptionsLoaded">
							<div class="col-xs-12">
								<cv-replication-groups-summary
									advanced-rst-options="repGrpSummaryCtrl.advancedRstOptions"
									vendor="repGrpSummaryCtrl.destinationVendor"
									replication-type="replicationGroup.attributes.replicationType">
								</cv-replication-groups-summary>
							</div>
						</div>

						<div class="button-container">
							<button id="summary_button_#6072" type="button" class="btn btn-default cvBusyOnAjax" data-ng-disabled="repGrpSummaryCtrl.taskSubmitting" data-ng-click="repGrpSummaryCtrl.goBackToPreviousStep()">
								<cv:msg key="previous" bundle="messages"></cv:msg>
							</button>
							<button id="summary_button_#9224" class="btn btn-primary cvBusyOnAjax margin-right-0" type="submit" data-ng-disabled="!repGrpSummaryCtrl.summaryOptionsLoaded || repGrpSummaryCtrl.taskSubmitting">
								<cv:msg key="Finish" bundle="messages"></cv:msg>
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>