<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.blrJs"></cv:cvMessages>
</script>
<script type="text/ng-template" id="storageLabel">
	<div data-ng-switch="replicationGroup.recoveryOptions.isSnapbackupEnabled" id="storageLabel">
		<div data-ng-switch-when="true">
			<label class="col-xs-12 col-sm-5" for="storage" ><cv:msg key="label.cache" bundle="replicationGroups"/></label>
		</div>
		<div data-ng-switch-default>
			<label class="col-xs-12 col-sm-5" for="storage" ><cv:msg key="label.storage" bundle="storage"/></label>
		</div>
	</div>
</script>
<div class="bootstrap-wrapper form-horizontal">
	<div class="panel panel-default setup-panel">
		<div class="panel-body setup-content">
			<div class="row">
				<div class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
					<form id="selectRecoveryOptionsForm" name="selectRecoveryOptionsForm" data-cv-submit="repGrpRecoveryCtrl.goToNextStep()" cv-hide-api>
					<!-- For the 'Periodic' Replication type -->
						<div data-ng-if="replicationGroup.replicationType === repGrpRecoveryCtrl.REP_TYPES.PERIODIC">
							<div class="form-group" data-ng-if="::repGrpRecoveryCtrl.showSnapEngineSelection">
								<div class="col-xs-12 col-sm-5">
									<input name="isSnapbackupEnabled" id="isSnapbackupEnabled" type="checkbox"
										data-ng-model="replicationGroup.recoveryOptions.isSnapbackupEnabled">
									<label for="isSnapbackupEnabled">
										<cv:msg key="label.useSnapshotOnSource" bundle="replicationGroups" />
									</label>
								</div>
								<div class="col-xs-12 col-sm-7" ng-disabled="!replicationGroup.recoveryOptions.isSnapbackupEnabled">
									<isteven-multi-select
										input-model="replicationGroup.recoveryOptions.snapEngineList"
										output-model="replicationGroup.recoveryOptions.snapEngine"
										button-label="name"
										item-label="name"
										tick-property="selected"
										selection-mode="single"
										class="isteven-multi-select"
										id="snapEngines"
										name="snapEngines"
										directive-id="snapEngines"
										search-property="name"
										max-height="400px"
										group-property="header"
										helper-elements="filter"
										translation="repGrpRecoveryCtrl.localLang">
									</isteven-multi-select>
									<div class="help-block" data-ng-if="repGrpRecoveryCtrl.snapEngineErr">
										<label><span data-ng-bind="repGrpRecoveryCtrl.snapEngineErr"/></label>
									</div>
								</div>
							</div>
							<div class="form-group">
								<div data-ng-include="'storageLabel'"> </div>
								<div class="col-xs-12 col-sm-7">
									<div class="input-group">
										<isteven-multi-select
											id="primaryStorage"
											name="storage"
											class="isteven-multi-select"
											input-model="replicationGroup.recoveryOptions.primaryStoragePool"
											output-model="replicationGroup.recoveryOptions.copy.primary.storage"
											item-label="name"
											button-label="name"
											tick-property="selected"
											selection-mode="single"
											max-labels="1"
											directive-id="primaryStorageSelect"
											group-property="msGroup"
											translation="repGrpRecoveryCtrl.localLang"
											on-item-click="repGrpRecoveryCtrl.onPrimaryStorageSelect()">
										</isteven-multi-select>
										<div class="help-block" data-ng-if="repGrpRecoveryCtrl.showStorageErrorMessage">
											<label><span data-ng-bind="repGrpRecoveryCtrl.showStorageErrorMessage.message"/></label>
										</div>
										<div class="help-block" data-ng-if="cv.selectRecoveryOptionsForm.getAttempted() && !repGrpRecoveryCtrl.isPrimaryCopySelectionValid">
											<cv:msg key="error.selectStorage" bundle="storage" />
										</div>
										<span class="input-group-btn">
											<a class="create-new-button" data-ng-click="repGrpRecoveryCtrl.addStorage()">
												<cv:msg key="createNew" bundle="messages"/>
											</a>
										</span>
									</div>
								</div>
							</div>
							<div class="form-group">
								<div class="col-xs-12">
									<cv-toggle toggle-name="replicationGroup.recoveryOptions.copy.enableSecondaryCopy" toggle-label="label.replicateUsingSecondaryCopy" value="replicationGroup.recoveryOptions.copy.enableSecondaryCopy"></cv-toggle>
								</div>
							</div>
							<div class="margin-left-10" data-ng-if="replicationGroup.recoveryOptions.copy.enableSecondaryCopy">
								<div class="form-group">
									<div data-ng-include="'storageLabel'"> </div>
									<div class="col-xs-12 col-sm-7">
										<isteven-multi-select
											id="secondaryStorage"
											name="storage"
											class="isteven-multi-select"
											input-model="replicationGroup.recoveryOptions.secondaryStoragePool"
											output-model="replicationGroup.recoveryOptions.copy.secondary.storage"
											item-label="name"
											button-label="name"
											tick-property="selected"
											selection-mode="single"
											max-labels="1"
											directive-id="secondaryStorageSelect"
											group-property="msGroup"
											translation="repGrpRecoveryCtrl.localLang"
											on-item-click="repGrpRecoveryCtrl.onSecondaryStorageSelect()">>
										</isteven-multi-select>
										<div class="help-block" data-ng-if="cv.selectRecoveryOptionsForm.getAttempted() && !repGrpRecoveryCtrl.isSecondaryCopySelectionValid">
											<cv:msg key="error.selectStorage" bundle="storage" />
										</div>
										<div class="help-block" data-ng-if="cv.selectRecoveryOptionsForm.getAttempted() && !repGrpRecoveryCtrl.storageSelectionsValid">
											<cv:msg key="error.duplicateStorage" bundle="storage" />
										</div>
									</div>
								</div>
							</div>
						</div>

						<!-- For the 'Continuous' Replication type -->		
						<div data-ng-if="replicationGroup.replicationType === repGrpRecoveryCtrl.REP_TYPES.CONTINUOUS">
							<cv-recovery-options model="replicationGroup.blrRecoveryOpts"/>
						</div>

						<div class="form-group">
							<div class="col-xs-12">
								<div class="button-container float-right">
									<button id="repGrpOverrideOptionsPrevious" type="button" class="btn btn-default cvBusyOnAjax" 
										data-ng-click="repGrpRecoveryCtrl.goBackToTarget()">
										<cv:msg key="previous" bundle="messages"></cv:msg>
									</button>
									<button id="repGrpOverrideOptionsNext" class="btn btn-primary cvBusyOnAjax margin-right-0" type="submit">
										<cv:msg key="Next" bundle="messages"></cv:msg>
									</button>
								</div>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
