<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvEnum name="CvEntities.VMAllocationPolicyType"></cv:cvEnum>
	<cv:cvEnum name="Common.VSVendor"></cv:cvEnum>
</script>

<div class="setup-title">
	<h1 data-ng-if="repGrpOverridesCtrl.isModal">
		<cv:msg key="label.overrideOptions" bundle="restore"/>
	</h1>
</div>

<div class="bootstrap-wrapper form-horizontal">
	<div data-ng-class="{'panel-body': repGrpOverridesCtrl.isModal, 'panel panel-default setup-panel': !repGrpOverridesCtrl.isModal}">
		<div data-ng-class="{'panel-body' : repGrpOverridesCtrl.isModal}">
			<div class="row">
				<div data-ng-class="{'col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2' : !repGrpOverridesCtrl.isModal}">
					<form id="overrideOptionsForm" name="overrideOptionsForm" data-cv-submit="goToSummary()" cv-hide-api>
						<div class="form-group">
							<div class="col-xs-12">
								<cv-toggle toggle-name="enableOverrideOptions" 
									toggle-label="label.overrideVMs"
									help-text="'info.overrideVMs'"
									value="replicationGroup.enableOverrideOptions"
									is-disabled="!repGrpOverridesCtrl.loadGrid"></cv-toggle>
							</div>
						</div>

						<div class="text-center" id="serverMessage">
							<span data-ng-if="serverMessage" class="col-xs-12 server-message {{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
						</div>

						<div data-ng-if="repGrpOverridesCtrl.loadGrid && replicationGroup.enableOverrideOptions">
							<cv-replication-groups-summary
								advanced-rst-options="replicationGroup.vmAdvRestOptions"
								vendor="vendor"
								replication-type="repGrpOverridesCtrl.replicationType"
								edit-mode="true"
								replication-group="replicationGroup"
								ctrl="ctrl"
								is-detail-page="isDetailPage">
							</cv-replication-groups-summary>
						</div>

						<div class="form-group">
							<div data-ng-class="{'col-xs-12': !repGrpOverridesCtrl.isDetailPage}">
								<div class="button-container">
									<button id="overrideOptions_button_#1836" type="button" class="btn btn-default cvBusyOnAjax" 
									data-ng-if="!repGrpOverridesCtrl.isDetailPage"
									data-ng-click="goBackToPreviouseStep()">
										<cv:msg key="previous" bundle="messages"></cv:msg>
									</button>
									<button type="button" data-ng-if="repGrpOverridesCtrl.isDetailPage"
										data-ng-click="repGrpOverridesCtrl.cancel()" class="btn btn-default cvBusyOnAjax">
										<cv:msg key="Cancel" bundle="messages" />
									</button>
									<button id="overrideOptions_button_#3806" class="btn btn-primary cvBusyOnAjax">
										{{repGrpOverridesCtrl.isDetailPage ? '<cv:msg key="Save" bundle="messages" />' : '<cv:msg key="Next" bundle="messages"></cv:msg>'}}  
									</button>
								</div>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>