<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
		<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
		<cv:cvMessages bundle="localization.blrJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-xs-12 col-md-12 col-lg-12">
		<div>
		<h1 class="page-header margin-top-10 margin-bottom-10">
			<span data-ng-if="replicationGroupPageTitle">{{replicationGroupPageTitle}}</span>
			<cv-help-component help-text="{{helpText}}"></cv-help-component>
		</h1>
		<ul class="steps group text-center create-profile-steps" data-setup-steps="{{replicationGroup.vsa.filteredSteps.length}}" data-ng-if="replicationGroup.attributes.solution === 'VSA' && !$state.is('configureReplicationGroup.replicationType')">
			<li data-ng-repeat="step in replicationGroup.vsa.filteredSteps" title="{{step.name}}" data-ng-class="{'current': replicationGroup.currentStep === $index, 'done': replicationGroup.currentStep > $index}">
				<span data-ng-if="replicationGroup.currentStep <= $index">{{step.name}}</span>
				<span data-ng-if="replicationGroup.currentStep > $index"><a data-ng-click="replicationGroup.loadTab($index)">{{step.name}}</a></span>
			</li>
		</ul>
		<!-- File System -->
		<ul class="steps group text-center create-profile-steps" data-setup-steps data-ng-if="replicationGroup.attributes.solution === 'FS' && !$state.is('configureReplicationGroup.replicationType')">
			<li data-ng-class="{'current': $state.is('configureReplicationGroup.replicationType')}"
				data-ng-if="replicationGroup.task && repGrpParentCtrl.replicationGroup.attributes.solution === repGrpParentCtrl.REPLICATION_SOLUTIONS.VIRTUALIZATION">
				<span><a ui-sref="configureReplicationGroup.replicationType"><cv:msg key="label.selectReplicationType" bundle="vmsJs"/></a></span></li>
				<li data-ng-class="{'current':  $state.is('configureReplicationGroup.selectFsContent') }" ><span>
	                <cv:msg key="label.selectContent" bundle="vmsJs"/></a></span></li>
	            <li data-ng-class="{'current':  $state.is('configureReplicationGroup.selectFsTarget') }" ><span>
	                <div data-ng-if="!replicationGroup.task"><cv:msg key="label.selectTarget" bundle="vmsJs"/></div>
	                <div data-ng-if="replicationGroup.task"><cv:msg key="label.replicationoptions" bundle="vmsJs"/></div></a></span></li>
	            <li data-ng-repeat="step in configureReplicationGroupController.visibleSteps track by step.label"
	            data-ng-class="{'current': step === configureReplicationGroupController.activeStep}" >
	                <span>{{step.label}}</span>
	            </li>
		</ul>
		<!-- Database  -->
		<ul class="steps group text-center create-profile-steps" data-setup-steps="{{replicationGroup.db.filteredSteps.length}}" data-ng-if="replicationGroup.attributes.solution === 'DB' && !$state.is('configureReplicationGroup.replicationType')">
			<li data-ng-repeat="step in replicationGroup.db.filteredSteps" title="{{step.name}}" data-ng-class="{'current': replicationGroup.db.currentStep() === $index, 'done': replicationGroup.db.currentStep() > $index}">
				<span data-ng-if="replicationGroup.currentStep <= $index">{{step.name}}</span>
				<span data-ng-if="replicationGroup.currentStep > $index"><a data-ng-click="replicationGroup.loadTab($index)">{{step.name}}</a></span>
			</li>
		</ul>
		</div>
		<ui-view></ui-view>
	</div>
</div>