import 'modules/disasterRecovery/repGrp/js/controllers/repGrpParent.ctrl.js';
import 'modules/navigation/js/constants.js';
import 'modules/setup/js/services/setup.svc.js';
import 'vsa/js/controllers/replication.ctrl.js';
import 'vsa/js/directives/cv-replication-groups-summary-directive.js';
import 'vsa/js/directives/cv-restore-options-azure-directive.js';
import 'vsa/js/services/restore.svc.js';

import { vsaAppServerModule } from 'common/js/modules';

var mod = vsaAppServerModule;

mod.controller('replicationGroupSummaryController', [
	'$scope',
	'restoreService',
	'setupService',
	'$log',
	'$state',
	'replicationFactory',
	'cvLoc',
	'cvToaster',
	'cvUtil',
	'$dialogs',
	'dataCachingFactory',
	'REPLICATION_SOLUTIONS',
	'REGEX',
	'cvBreadcrumbsTabsFactory',
	'VENDORS',
	'serverUIFactory',
	'replicationGroupFactory',
	'REP_TYPES',
	'SOLUTION_NAMES',
	function(
		$scope,
		restoreService,
		setupService,
		$log,
		$state,
		replicationFactory,
		cvLoc,
		cvToaster,
		cvUtil,
		$dialogs,
		dataCachingFactory,
		REPLICATION_SOLUTIONS,
		REGEX,
		cvBreadcrumbsTabsFactory,
		VENDORS,
		serverUIFactory,
		replicationGroupFactory,
		REP_TYPES,
		SOLUTION_NAMES
	) {
		if ($scope.replicationGroup.attributes.refreshBrowser()) {
			return;
		}

		var self = this;
		$scope.replicationGroup.currentStep = 4;
		self.hideDetails = cv.isTenantAdmin;
		if (
			(!$scope.replicationGroup.modifiedVmsList || !$scope.replicationGroup.selectedHypervisors) &&
			!$scope.replicationGroup.useAllocationPolicyForRestore
		) {
			$state.go('replicationGroup.selectContent');
			return;
		}

		self.azureVmNamePattern = REGEX.AZURE_VM_NAME;
		self.serverMessage = null;
		self.summaryOptionsLoaded = false;
		self.isOverrideOptionsNotEligible =
			$scope.replicationGroup.useAllocationPolicyForRestore &&
			!$scope.replicationGroup.recoveryOptions.isSnapbackupEnabled &&
			$scope.replicationGroup.replicationType !== REP_TYPES.CONTINUOUS;

		self.loadSummaryOptionsForUI = function() {
			var destinationName;
			self.destinationHyperV = _.get($scope.replicationGroup, 'destinationHyperV');
			self.showDestinationHypervisor = self.destinationHyperV && self.destinationHyperV.clientName;

			if ($scope.replicationGroup.selectedHypervisors.length > 0) {
				self.sourceHyperVisor = $scope.replicationGroup.selectedHypervisors[0].clientName;
				self.sourceVendor = $scope.replicationGroup.selectedHypervisors[0].localizedType;
			}

			if (
				$scope.replicationGroup.task &&
				$scope.replicationGroup.task.subTasks['0'].options.restoreOptions.destination &&
				$scope.replicationGroup.task.subTasks['0'].options.restoreOptions.destination.destClient
			) {
				destinationName =
					$scope.replicationGroup.task.subTasks['0'].options.restoreOptions.destination.destClient.clientName;
			}

			let destinationVendor = '';
			if ($scope.replicationGroup.target.target) {
				destinationVendor = _.get($scope, 'replicationGroup.target.target.entity.vmAllocPolicyType');
				self.selectedTarget = $scope.replicationGroup.target.target.entity.vmAllocPolicyName;
			} else {
				destinationVendor = _.get($scope, 'replicationGroup.targetModel.destinationVendor');
			}
			self.destinationVendor = serverUIFactory.setVendorName(destinationVendor);
			/* For all the VMWare policy types, show the vendor as 'VMWare' */
			if (VENDORS['VMW'].policyTypes.includes(destinationVendor)) {
				destinationVendor = 'VMW';
				self.destinationVendorUI = cvLoc('label.vendor.vmware');
			} else {
				self.destinationVendorUI = cvUtil.lookupEnumConstant(destinationVendor);
			}

			if (VENDORS['AZURE_V2'].policyTypes.includes(destinationVendor)) {
				self.destinationVendorUI = VENDORS['AZURE_V2'].text;
			}

			self.enableContinuousReplication =
				replicationGroupFactory.enableContinuousReplication &&
				isVMWareVendor($scope.replicationGroup.selectedHypervisors[0].type) &&
				isVMWareVendor(destinationVendor);

			self.proxy =
				$scope.replicationGroup.selectedProxy && $scope.replicationGroup.selectedProxy[0]
					? $scope.replicationGroup.selectedProxy[0].clientName
					: null;
			self.advancedRstOptions = $scope.replicationGroup.vmAdvRestOptions;

			if ($scope.replicationGroup.replicationType === REP_TYPES.PERIODIC) {
				self.replicationTypeText = cvLoc('label.periodic');
				let copy = _.get($scope, 'replicationGroup.recoveryOptions.copy', {});
				self.storageNames = _.get(copy, 'primary.storage[0].name', '');
			} else if ($scope.replicationGroup.replicationType === REP_TYPES.CONTINUOUS) {
				self.replicationTypeText = cvLoc('label.continuous');
				self.storageNames = _.get($scope, 'replicationGroup.blrRecoveryOpts.copy.primary.storage[0].name', '');
			}

			self.summaryOptionsLoaded = true;
			cvBreadcrumbsTabsFactory.addBreadCrumbs($scope.replicationGroup.breadCrumbs);
		};

		//convert task information.
		self.getDefaultTaskOptions = function(task, isDefaultCopyPrecedenceRequire) {
			var copyPrecedence;
			if (task) {
				if (task.subTasks && task.subTasks.length > 0 && task.subTasks[0].options) {
					if (task.subTasks[0].options.restoreOptions) {
						//convert the browseFilters value with encodeURIComponent, which allow xml tags, other special characters in encoded format, and allow anti-samy filter to avoid removing the xml value under browseFilter, which need to be preseved during edit replicaiton targets
						if (
							task.subTasks[0].options.restoreOptions.fileOption &&
							task.subTasks[0].options.restoreOptions.fileOption.browseFilters &&
							task.subTasks[0].options.restoreOptions.fileOption.browseFilters.length > 0 &&
							!!task.subTasks[0].options.restoreOptions.fileOption.browseFilters[0]
						) {
							task.subTasks[0].options.restoreOptions.fileOption.browseFilters[0] = encodeURIComponent(
								task.subTasks[0].options.restoreOptions.fileOption.browseFilters[0]
							);
						}
						//get the copy precedence value for Java GUI schedules.
						if (isDefaultCopyPrecedenceRequire) {
							if (
								task.subTasks[0].options.restoreOptions.browseOption &&
								task.subTasks[0].options.restoreOptions.browseOption.mediaOption &&
								task.subTasks[0].options.restoreOptions.browseOption.mediaOption.copyPrecedence
							) {
								copyPrecedence =
									task.subTasks[0].options.restoreOptions.browseOption.mediaOption.copyPrecedence.copyPrecedence;
							}
						}
					}
				}
			}
			return {
				taskDetails: task,
				taskCopyPrecedence: copyPrecedence
			};
		};

		self.goBackToPreviousStep = function() {
			if (self.isOverrideOptionsNotEligible) {
				$state.go('replicationGroup.recoveryOptions');
			} else {
				$state.go('replicationGroup.overrideOptions');
			}

			$scope.replicationGroup.currentStep--;
		};

		function populateRecoveryOptionsTab() {
			if (!_.get($scope, 'replicationGroup.recoveryOptions')) {
				return;
			}

			let recoveryOptions = {};
			if ($scope.replicationGroup.replicationType === REP_TYPES.PERIODIC) {
				recoveryOptions = {
					rpoInMinutes: $scope.replicationGroup.rpo.inMinutes
				};

				/* Fill up copy info */
				let copy = [];
				copy.push($scope.replicationGroup.recoveryOptions.copy.primary);
				if ($scope.replicationGroup.recoveryOptions.copy.enableSecondaryCopy) {
					copy.push($scope.replicationGroup.recoveryOptions.copy.secondary);
				}
				recoveryOptions.storage = {
					copy: copy
				};
			} else if ($scope.replicationGroup.replicationType === REP_TYPES.CONTINUOUS) {
				/* Fill up copy info */
				let copy = [];
				copy.push($scope.replicationGroup.blrRecoveryOpts.copy.primary);
				recoveryOptions.storage = {
					copy: copy
				};
			}

			return recoveryOptions;
		}

		self.submitReplicationGroupTask = function() {
			var diskRestoreOption, copyPrecedence;
			self.taskSubmitting = true;
			self.serverMessage = null;
			if ($scope.replicationGroup.target.diskRestoreOption) {
				diskRestoreOption = $scope.replicationGroup.target.diskRestoreOption;
				copyPrecedence = diskRestoreOption.copyPrecedence;
			}

			if (!diskRestoreOption.restoreToDefaultHost) {
				if (!diskRestoreOption.advancedRestoreOptions) {
					diskRestoreOption.advancedRestoreOptions = [];
					if (
						$scope.replicationGroup.target.target &&
						$scope.replicationGroup.target.target.dataStores &&
						$scope.replicationGroup.target.target.dataStores.length
					) {
						diskRestoreOption.advancedRestoreOptions.push({
							DestinationPath: $scope.replicationGroup.target.target.dataStores[0].dataStoreName
						});
					}
				}
			}

			if ($scope.replicationGroup.task) {
				var taskOptions = self.getDefaultTaskOptions($scope.replicationGroup.task, copyPrecedence == undefined);
				if (taskOptions) {
					if (taskOptions.taskDetails) {
						$scope.replicationGroup.task = taskOptions.taskDetails;
					}
					if (taskOptions.taskCopyPrecedence != undefined) {
						copyPrecedence = taskOptions.taskCopyPrecedence;
					}
				}
			}

			// Remove the grid options from the VMs.
			var selectVMsList = [];
			self.errorExisted = {};
			if ($scope.replicationGroup.modifiedVmsList && $scope.replicationGroup.modifiedVmsList.length) {
				$scope.replicationGroup.modifiedVmsList.forEach(function(vm) {
					var selectedVM = angular.copy(vm);
					selectedVM.vmOptions.networkSettingsGridOptions = null;
					selectedVM.vmOptions.ipAddressSettingsGridOptions = null;
					selectVMsList.push(selectedVM);
				});
			} else if ($scope.replicationGroup.useAllocationPolicyForRestore) {
				selectVMsList = angular.copy($scope.replicationGroup.selectedVMs);
			}

			/*
			 * If the VM list is a cross-restore from VMW->AWS and a non-AWS proxy is used then clear the
			 * guest credentials This case is required when a user first creates a Rep group with AWS proxy
			 * and then edits the group and uses non AWS proxy
			 */

			if ($scope.replicationGroup.isAWSCrossRestore && !$scope.replicationGroup.isAmazonProxy) {
				$scope.replicationGroup.vmAdvRestOptions.forEach(advRestOption => {
					advRestOption.destComputerName = '';
					advRestOption.destComputerUserName = '';
					advRestOption.instanceAdminPassword = null;
				});
			}

			let targetDataCenterName = _.get($scope.replicationGroup, 'target.target.entity.dataCenterName', null);
			if (targetDataCenterName && !$scope.replicationGroup.enableOverrideOptions) {
				$scope.replicationGroup.vmAdvRestOptions.forEach(advRestOption => {
					advRestOption.datacenter = targetDataCenterName;
				});
			}

			// If proxy is Distribute workload/ Automatic then set proxy Client id to destination Hypervisor client id
			if ($scope.replicationGroup.selectedProxy && $scope.replicationGroup.selectedProxy[0].autoProxy) {
				$scope.replicationGroup.target.target.proxyClientEntity.clientId =
					$scope.replicationGroup.target.target.destinationHyperV.clientId;
				$scope.replicationGroup.target.target.proxyClientEntity.clientName =
					$scope.replicationGroup.target.target.destinationHyperV.clientName;

				$scope.replicationGroup.selectedProxy[0].clientId =
					$scope.replicationGroup.target.target.destinationHyperV.clientId;
				$scope.replicationGroup.selectedProxy[0].clientName =
					$scope.replicationGroup.target.target.destinationHyperV.clientName;
			}

			var data = {
				name: $scope.replicationGroup.name,
				type: +cvUtil.lookupEnumConstant($scope.replicationGroup.attributes.replicationType, 'value'),
				sourceServer: $scope.replicationGroup.selectedHypervisors[0],
				vms: selectVMsList,
				planId:
					$scope.replicationGroup.selectedPlanList && $scope.replicationGroup.selectedPlanList.length
						? $scope.replicationGroup.selectedPlanList[0].planId
						: 0,
				diskLevelRestoreOpts: diskRestoreOption,
				schedule: $scope.replicationGroup.target.replicationSchedule,
				target: $scope.replicationGroup.target.target,
				vmAdvRestOptions: $scope.replicationGroup.vmAdvRestOptions,
				copyPrecedence: copyPrecedence,
				taskInfo: $scope.replicationGroup.task,
				subClientId: $scope.replicationGroup.selectedVMGroup
					? $scope.replicationGroup.selectedVMGroup.subclientId
					: null,
				proxyClientEntity: $scope.replicationGroup.selectedProxy ? $scope.replicationGroup.selectedProxy[0] : null,
				snapEngineEntity: _.get($scope, 'replicationGroup.recoveryOptions.isSnapbackupEnabled', false)
					? $scope.replicationGroup.recoveryOptions.snapEngine[0]
					: null,
				storageId: 0,
				useAllocationPolicyForRestore: $scope.replicationGroup.useAllocationPolicyForRestore || false,
				recoveryOptions: populateRecoveryOptionsTab(),
				replicationType: $scope.replicationGroup.replicationType,
				selectedContent: $scope.replicationGroup.selectedContent,
				vmGuestCredentials: getVMGuestCredentials(),
				isSimplifiedLiveSync: true
			};

			setMaxSnapshotsPerDRVM(diskRestoreOption);
			restoreService.createReplicationGroupSimplified(data).then(
				function(response) {
					// clear the data in replicationFactory
					if (_.get(response, 'data.replicationGroup')) {
						replicationFactory.setReplicationGroupTask(undefined);
						dataCachingFactory.clearCacheData();
						markReplicationSetupComplete();
						cvToaster.showSuccessMessage({
							ttl: '10000', //10 sec
							message: cvLoc('msg.created')
						});
						$state.go('replicationGroups');
					} else {
						cvToaster.showErrorMessage({
							ttl: '10000', //10 sec
							message: cvLoc('generic_error')
						});
					}
				},
				function(error) {
					cvToaster.showErrorMessage({
						ttl: '10000', //10 sec
						message: error.data ? error.data : cvLoc('generic_error')
					});
					self.taskSubmitting = false;
				}
			);
		};

		function markReplicationSetupComplete() {
			if (cvApp.oemId === 118) {
				let setup = SOLUTION_NAMES.REPLICATION;
				if (!cv.sessionContext.completedSetups[setup]) {
					setupService.markSetupAsComplete(setup).then(
						function(successData) {
							cv.sessionContext.completedSetups[setup] = true;
						},
						function(err) {
							$log.log('Cannot Mark setup' + setup);
						}
					);
				}
			}
		}

		/*
		 * Max snapshots should be 0 if snap engine is selected
		 */
		function setMaxSnapshotsPerDRVM(diskRestoreOption) {
			if (_.get($scope, 'replicationGroup.recoveryOptions.isSnapbackupEnabled', false)) {
				diskRestoreOption.nMaxSnapshotsPerDRVM = 0;
				$scope.replicationGroup.vmAdvRestOptions.forEach(advRestOption => (advRestOption.nMaxSnapshotsPerDRVM = 0));
			}
		}

		function getVMGuestCredentials() {
			let credentialsModel = $scope.replicationGroup.credentialsModel || {};
			if (credentialsModel.credType === 'user') {
				return {
					userPassword: {
						userName: credentialsModel.userName,
						password: cvUtil.getBytes(credentialsModel.password)
					}
				};
			} else if (credentialsModel.credType === 'credManager') {
				return {
					credentialEntity: _.get(credentialsModel, 'selectedCredential[0]')
				};
			}

			return null;
		}

		function isVMWareVendor(vendor) {
			return vendor && vendor === VENDORS.VMW.type;
		}

		function setVendor() {
			let vendor = $scope.replicationGroup.target.target
				? $scope.replicationGroup.target.target.entity.policyType
				: 'VMW';
			//For all the VMWare policy types, show the vendor as 'VMWare'
			if (VENDORS['VMW'].policyTypes.includes(vendor)) {
				vendor = 'VMW';
			}
			vendor = serverUIFactory.setVendorName(vendor);
			$scope.replicationGroup.vendor = vendor;
			$scope.replicationGroup.target.replicationSchedule.options.restoreOptions.volumeRstOption.destinationVendor = vendor;
		}

		function loadTargetDetails() {
			// retrieve the destinationServerId first using vmAllocationPolicyId
			if ($scope.replicationGroup.target && $scope.replicationGroup.target.target) {
				let vmAllocationPolicyId = $scope.replicationGroup.target.target.entity.vmAllocPolicyId;
				let loadedTarget = $scope.replicationGroup.loadedTargetsDetail[vmAllocationPolicyId];
				if (loadedTarget) {
					// If the target detail is previously loaded, merge it with current one;
					$scope.replicationGroup.target.target = angular.merge(
						{},
						loadedTarget,
						$scope.replicationGroup.target.target
					);
					$scope.replicationGroup.destinationHyperV = $scope.replicationGroup.target.target.destinationHyperV;
					$scope.replicationGroup.amazonProxyClientForVMList = $scope.replicationGroup.target.target.proxyClientEntity;
					//get data from target and put in vmOptions for each VM
					setVendor();
				} else {
					// If the target detail is not previously loaded, call API to load
					restoreService.getReplicationTarget(vmAllocationPolicyId).then(
						function(data) {
							let proxyClientEntity = $scope.replicationGroup.selectedProxy;
							let existingDataStore;
							if (
								$scope.replicationGroup.target.target.entity &&
								$scope.replicationGroup.target.target.entity.selectedAmazonBucket
							) {
								existingDataStore = $scope.replicationGroup.target.target.entity.selectedAmazonBucket;
							} else {
								if ($scope.replicationGroup.target.target.dataStores) {
									existingDataStore = $scope.replicationGroup.target.target.dataStores[0];
								}
							}
							$scope.replicationGroup.target.target = data.data;
							let destinationHyperV = $scope.replicationGroup.target.target.destinationHyperV;
							let policyType = $scope.replicationGroup.target.target.entity.policyType;
							$scope.replicationGroup.target.target.entity.vmAllocPolicyType = policyType;
							if (proxyClientEntity && proxyClientEntity[0]) {
								$scope.replicationGroup.target.target.proxyClientEntity = proxyClientEntity[0];
							}

							if (existingDataStore) {
								if (!$scope.replicationGroup.target.target.dataStores) {
									$scope.replicationGroup.target.target['dataStores'] = [
										{
											dataStoreName: existingDataStore.dataStoreName
										}
									];
								} else {
									$scope.replicationGroup.target.target.dataStores[0].dataStoreName = existingDataStore.dataStoreName;
								}
							}
							$scope.replicationGroup.amazonProxyClientForVMList =
								$scope.replicationGroup.target.target.proxyClientEntity;
							$scope.replicationGroup.loadedTargetsDetail[vmAllocationPolicyId] = $scope.replicationGroup.target.target;
							$scope.replicationGroup.destinationHyperV = destinationHyperV;
							setVendor();
						},
						function(err) {
							$log.debug(err);
						}
					);
				}
			}
		}

		function initialize() {
			self.loadSummaryOptionsForUI();
			$scope.replicationGroup.useAllocationPolicyForRestore && loadTargetDetails();
		}

		initialize();
	}
]);

export default mod;
