import 'modules/plan/js/factory/storageCopy.factory.js';
import 'storage/js/services/storage.svc.js';
import { vsaAppServerModule } from 'common/js/modules';

var mod = vsaAppServerModule;

const DEDUPLICATION_TYPES = ['DEDUPLICATION', 'SCALE_OUT'];
const SET_TRUE = 'SET_TRUE';
const SET_FALSE = 'SET_FALSE';

mod.controller('replicationGroupRecoveryOptionsController', [
	'$scope',
	'$state',
	'$log',
	'$uibModal',
	'cvLoc',
	'cvUtil',
	'cvBreadcrumbsTabsFactory',
	'storageService',
	'subclientService',
	'storageCopyFactory',
	'collectionFactory',
	'REPLICATION_SOLUTIONS',
	'REP_TYPES',
	'BLR_RECOVERY_TYPE',
	'VENDORS',
	function(
		$scope,
		$state,
		$log,
		$uibModal,
		cvLoc,
		cvUtil,
		cvBreadcrumbsTabsFactory,
		storageService,
		subclientService,
		storageCopyFactory,
		collectionFactory,
		REPLICATION_SOLUTIONS,
		REP_TYPES,
		BLR_RECOVERY_TYPE,
		VENDORS
	) {
		if ($scope.replicationGroup.attributes.refreshBrowser()) {
			return;
		}

		let self = this;

		self.goBackToTarget = function() {
			$scope.replicationGroup.currentStep--;
			$state.go('replicationGroup.selectTarget');
		};

		self.goToNextStep = function() {
			if (isPageValid()) {
				$scope.replicationGroup.currentStep++;
				if ($scope.replicationGroup.useAllocationPolicyForRestore) {
					if (
						$scope.replicationGroup.recoveryOptions.isSnapbackupEnabled ||
						$scope.replicationGroup.replicationType === REP_TYPES.CONTINUOUS
					) {
						$scope.replicationGroup.setSelectedVMs().then(function(success) {
							if (success === true) {
								$scope.replicationGroup.vsa.filteredSteps = $scope.replicationGroup.vsa.allSteps;
								$state.go('replicationGroup.overrideOptions');
							} else {
								$scope.errorMsg = cvUtil.errMsgLoc('msg.noVMsAvailable');
								return;
							}
						});
					} else if ($scope.replicationGroup.replicationType === REP_TYPES.PERIODIC) {
						setRuleRelatedChanges();
						$state.go('replicationGroup.summary');
					}
				} else {
					$state.go('replicationGroup.overrideOptions');
				}
			}
		};

		self.onPrimaryStorageSelect = function() {
			let selectedStorage = _.get(
				$scope,
				'replicationGroup.recoveryOptions.copy.primary.storage[0].storagePoolEntity',
				{}
			);
			let primary = $scope.replicationGroup.recoveryOptions.copy.primary;
			primary.useGlobalPolicy = {
				storagePolicyId: selectedStorage.storagePoolId,
				storagePolicyName: selectedStorage.storagePoolName
			};
			const isPrimary = true;
			setCopyParams(primary, isPrimary);
			areStorageSelectionsValid();
		};

		self.onSecondaryStorageSelect = function() {
			let selectedStorage = _.get(
				$scope,
				'replicationGroup.recoveryOptions.copy.secondary.storage[0].storagePoolEntity',
				{}
			);
			let secondary = $scope.replicationGroup.recoveryOptions.copy.secondary;
			secondary.useGlobalPolicy = {
				storagePolicyId: selectedStorage.storagePoolId,
				storagePolicyName: selectedStorage.storagePoolName
			};
			const isPrimary = false;
			setCopyParams(secondary, isPrimary);
			areStorageSelectionsValid();
		};

		self.onRPOChange = function() {
			$scope.replicationGroup.recoveryOptions.rpo.inMinutes =
				$scope.replicationGroup.recoveryOptions.rpo.count * $scope.replicationGroup.recoveryOptions.rpo.freq.value;
		};

		self.addStorage = function() {
			const modalInstance = $uibModal.open({
				templateUrl: appUtil.appRoot + 'webScale/partials/addStoragePoolSetup.jsp',
				backdrop: 'static',
				controller: [
					'$scope',
					'$uibModalInstance',
					function($scope, $modalInstance) {
						$scope.$on('storageAddCancelled', function() {
							$modalInstance.dismiss();
						});

						$scope.closeModal = function(flag, data) {
							$modalInstance.close(data);
						};

						$scope.$on('storageAdded', function(evt, data) {
							$modalInstance.close(data);
						});
					}
				]
			});

			modalInstance.result.then(function(createdStoragePolicyId) {
				createdStoragePolicyId &&
					getAllStoragePools().then(function() {
						selectStoragePool(createdStoragePolicyId);
					});
			});
		};

		function init() {
			cvBreadcrumbsTabsFactory.addBreadCrumbs($scope.replicationGroup.breadCrumbs);
			self.localLang = cvUtil.getIStevenLocLabels();
			self.REP_TYPES = REP_TYPES;
			self.showSnapEngineSelection = isVMWareType(getDestinationVendor());
			/* This will reset the snap selection, if the target is changed from VMW from non VMW */
			if (!self.showSnapEngineSelection) {
				resetSnapEngine();
			}
			if (!_.get($scope, 'replicationGroup.recoveryOptions.initialized', false)) {
				initModel();
				initBlrModel();
				getAllStoragePools();
				loadSnapEngines();
			}
		}

		function initModel() {
			$scope.replicationGroup.recoveryOptions = $scope.replicationGroup.recoveryOptions || {};

			/* initialize the unit types and the frequency */
			$scope.replicationGroup.recoveryOptions.unitTypes = angular.copy(storageCopyFactory.getUnitTypes());

			/* initialize the copies */
			let primaryCopy = {};
			primaryCopy.retentionInfo = {
				type: _.get($scope, 'replicationGroup.recoveryOptions.unitTypes[0].type', ''),
				value: 14
			};
			primaryCopy.retentionRules = {
				retainBackupDataForDays: storageCopyFactory.getRetentionPeriodInDays(
					primaryCopy.retentionInfo.type,
					primaryCopy.retentionInfo.value
				)
			};
			let secondaryCopy = angular.copy(primaryCopy);

			$scope.replicationGroup.recoveryOptions.copy = {
				primary: primaryCopy,
				secondary: secondaryCopy
			};

			/* Initliaze the storage pools */
			$scope.replicationGroup.recoveryOptions.primaryStoragePool = [loadingISteven('name')];
			$scope.replicationGroup.recoveryOptions.secondaryStoragePool = [loadingISteven('name')];

			/* Initliaze the snap engines */
			$scope.replicationGroup.recoveryOptions.snapEngineList = [loadingISteven('name')];

			/* Set the initalized to true, to avoid reinitializing when switching between tabs */
			$scope.replicationGroup.recoveryOptions.initialized = true;
		}

		function initBlrModel() {
			$scope.replicationGroup.blrRecoveryOpts = {
				hideHeader: true,
				solution: REPLICATION_SOLUTIONS.VIRTUALIZATION
			};
		}

		function getAllStoragePools() {
			return storageService.getAllStoragePools().then(
				function(data) {
					if (data && data.data.length) {
						self.showStorageErrorMessage = '';
					} else {
						self.showStorageErrorMessage = cvUtil.errMsgLoc('error.noStorageFound');
						$scope.replicationGroup.recoveryOptions.primaryStoragePool = [];
						$scope.replicationGroup.recoveryOptions.secondaryStoragePool = [];
						return;
					}

					let model = {};
					let storagePools = [];
					data.data.map(function(storagePool) {
						if (storagePool.storagePoolType != 'SECONDARY_COPY') {
							storagePools.push(storagePool);
						}
					});
					storagePools = cvUtil.sortAscending(storagePools, 'storagePoolEntity.storagePoolName');
					$scope.replicationGroup.recoveryOptions.primaryStoragePool = storageCopyFactory.getInputStoragePoolModel(
						angular.copy(storagePools),
						model
					);
					$scope.replicationGroup.recoveryOptions.secondaryStoragePool = angular.copy(
						$scope.replicationGroup.recoveryOptions.primaryStoragePool
					);
				},
				function(err) {
					self.showStorageErrorMessage = cvUtil.errMsgLoc('error.noStorageFound');
					$scope.replicationGroup.recoveryOptions.primaryStoragePool = [];
					$scope.replicationGroup.recoveryOptions.secondaryStoragePool = [];
					$log.debug(err);
				}
			);
		}

		function loadSnapEngines() {
			let subclientId = 0;
			$scope.replicationGroup.recoveryOptions.snapEngineList = [];
			subclientService
				.getSnapShotEngines(subclientId)
				.success(function(data) {
					if (data && data.length) {
						$scope.replicationGroup.recoveryOptions.snapEngineList = data;

						/* Set the VSA Snap as selected */
						const VirtualServerAgentSnapID = 58;
						let vsaIndex = data.findIndex(snap => snap.id === VirtualServerAgentSnapID);
						if (vsaIndex >= 0) {
							$scope.replicationGroup.recoveryOptions.snapEngineList[vsaIndex].selected = true;
						}

						/* List of engines that have to be removed */
						const AWSSnapID = 60;
						const VirtualServerApplicationSnapID = 48;
						removeEngines($scope.replicationGroup.recoveryOptions.snapEngineList, [
							AWSSnapID,
							VirtualServerApplicationSnapID
						]);

						$scope.replicationGroup.recoveryOptions.snapEngineList.forEach(snapEngine => {
							snapEngine.snapShotEngineId = snapEngine.id;
							snapEngine.snapShotEngineName = snapEngine.name;
						});
					} else {
						self.snapEngineErr = cvLoc('label.noDataAvailable');
						return;
					}

					self.snapEngineErr = '';
				})
				.error(function(err) {
					self.snapEngineErr = cvUtil.errMsg(err ? err : cvLoc('generic_error'));
				});
		}

		/* Removes the engines from the snapengines list */
		function removeEngines(enginesList, engineIds) {
			engineIds = engineIds || [];
			_.remove(enginesList, engine => engineIds.includes(engine.id));
		}

		function isPageValid() {
			if ($scope.replicationGroup.replicationType === REP_TYPES.PERIODIC) {
				return isSnapSelectionValid() && areStorageSelectionsValid();
			} else if ($scope.replicationGroup.replicationType === REP_TYPES.CONTINUOUS) {
				return areContinuousOptionsValid();
			}
		}

		function areContinuousOptionsValid() {
			if ($scope.replicationGroup.blrRecoveryOpts.recoveryType == BLR_RECOVERY_TYPE.GRANULARV2) {
				let isValid = true;
				//show error when rpstore is not set for granular recovery
				if (!_.get($scope, 'replicationGroup.blrRecoveryOpts.granularV2.rpStoreId')) {
					$scope.replicationGroup.blrRecoveryOpts.rpStoreErrorMessage = cvLoc('error.noRPStoreSelected');
					isValid = false;
				}
				if ($scope.replicationGroup.blrRecoveryOpts.copy.primary.storage.length === 0) {
					$scope.replicationGroup.blrRecoveryOpts.storageErrorMessage = true;
					isValid = false;
				}

				if (isValid) {
					return !$scope.replicationGroup.blrRecoveryOpts.recoveryOptionsError;
				} else {
					return false;
				}
			} else if ($scope.replicationGroup.blrRecoveryOpts.recoveryType == BLR_RECOVERY_TYPE.LIVE) {
				let isValid = true;
				if ($scope.replicationGroup.blrRecoveryOpts.copy.primary.storage.length === 0) {
					$scope.replicationGroup.blrRecoveryOpts.storageErrorMessage = true;
					isValid = false;
				}

				return isValid;
			}

			return true;
		}

		function isSnapSelectionValid() {
			let recoveryOptions = $scope.replicationGroup.recoveryOptions;
			if (recoveryOptions.isSnapbackupEnabled) {
				return _.get(recoveryOptions, 'snapEngine[0]') !== null;
			}

			return true;
		}

		function areStorageSelectionsValid() {
			return isPrimaryStorageSelectionValid() && isSecondaryStorageSelectionValid() && duplicateStorageCheck();
		}

		function isPrimaryStorageSelectionValid() {
			self.isPrimaryCopySelectionValid = $scope.replicationGroup.recoveryOptions.copy.primary.storage.length === 1;
			return self.isPrimaryCopySelectionValid;
		}

		function isSecondaryStorageSelectionValid() {
			let copy = $scope.replicationGroup.recoveryOptions.copy;
			self.isSecondaryCopySelectionValid = true;
			if (copy.enableSecondaryCopy) {
				self.isSecondaryCopySelectionValid = copy.secondary.storage.length === 1;
			}
			return self.isSecondaryCopySelectionValid;
		}

		/*
		 * The storage selection between the primary and the secondary cannot be the same.
		 * Returns true if the selection is valid, false otherwise.
		 */
		function duplicateStorageCheck() {
			let copy = $scope.replicationGroup.recoveryOptions.copy;
			self.storageSelectionsValid = true;
			if (copy.enableSecondaryCopy) {
				self.storageSelectionsValid = copy.primary.storage[0].name !== copy.secondary.storage[0].name;
			}

			return self.storageSelectionsValid;
		}

		function setCopyParams(copy, isPrimary) {
			copy.active = SET_TRUE;
			copy.copyType = 1; // Synchronous CopyType,
			copy.isMirrorCopy = SET_FALSE;
			copy.isSnapCopy = SET_FALSE;
			copy.retentionRules = copy.retentionRules || {};
			copy.retentionRules.retentionFlags = {
				enableDataAging: SET_TRUE
			};

			if (isPrimary) {
				copy.isDefault = SET_TRUE;
				copy.StoragePolicyCopy = {
					copyName: 'Primary'
				};
			} else {
				copy.isDefault = SET_FALSE;
				copy.StoragePolicyCopy = {
					copyName: 'Secondary'
				};
			}

			if (DEDUPLICATION_TYPES.includes(copy.storage[0].storagePoolType.toUpperCase())) {
				copy.extendedFlags = {};
				if (isPrimary) {
					setAdditionalParamsPrimaryDedupeCopy(copy);
				} else {
					setAdditionalParamsSecondaryDedupeCopy(copy);
				}
			} else {
				copy.dedupeFlags = {};
				copy.extendedFlags = {
					useGlobalStoragePolicy: SET_TRUE
				};
			}
		}

		function setAdditionalParamsPrimaryDedupeCopy(copy) {
			copy.dedupeFlags = {
				enableDeduplication: SET_TRUE,
				enableClientSideDedup: SET_TRUE,
				enableDASHFull: SET_TRUE,
				useGlobalDedupStore: SET_TRUE
			};
		}

		function setAdditionalParamsSecondaryDedupeCopy(copy) {
			copy.dedupeFlags = {
				enableDeduplication: SET_TRUE,
				enableDASHFull: SET_TRUE,
				useGlobalDedupStore: SET_TRUE
			};
		}

		function selectStoragePool(storagePoolId) {
			let recoveryOptions = $scope.replicationGroup.recoveryOptions;
			let selectedStorageIndex = recoveryOptions.primaryStoragePool.findIndex(
				storage => _.get(storage, 'storagePoolEntity.storagePoolId', -1) === storagePoolId
			);
			if (selectedStorageIndex > 0) {
				recoveryOptions.primaryStoragePool[selectedStorageIndex].selected = true;
				recoveryOptions.copy.primary.storage = recoveryOptions.primaryStoragePool[selectedStorageIndex];
			}
		}

		function loadingISteven(name) {
			let loading = {
				id: 0,
				selected: true,
				disableSelection: true // disable from using this as a value to save
			};
			loading[name] = cvLoc('Loading');

			return loading;
		}

		function resetSnapEngine() {
			if (_.get($scope, 'replicationGroup.recoveryOptions', false)) {
				$scope.replicationGroup.recoveryOptions.isSnapbackupEnabled = false;
				$scope.replicationGroup.recoveryOptions.snapEngine = [];
				$scope.replicationGroup.recoveryOptions.snapEngineList.forEach(engine => (engine.selected = false));
				self.snapEngineErr = '';
			}
		}

		function isVMWareType(vendor = '') {
			return VENDORS.VMW.policyTypes.includes(vendor);
		}

		function getDestinationVendor() {
			if ($scope.replicationGroup.target.target) {
				return _.get($scope, 'replicationGroup.target.target.entity.vmAllocPolicyType');
			} else {
				return _.get($scope, 'replicationGroup.targetModel.destinationVendor');
			}
		}

		function setRuleRelatedChanges() {
			$scope.replicationGroup.vsa.filteredSteps = filterStep('replicationGroup.overrideOptions');
			$scope.replicationGroup.vmAdvRestOptions = null;
			$scope.replicationGroup.modifiedVms = null;
			$scope.replicationGroup.selectedContent = _.cloneDeep(collectionFactory.getCollectionContent());
		}

		function filterStep(state) {
			return $scope.replicationGroup.vsa.allSteps.filter(function(step) {
				return step.state !== state;
			});
		}

		init();
	}
]);

export default mod;
