import 'modules/disasterRecovery/repGrp/js/controllers/repGrpParent.ctrl.js';
import 'modules/servers/js/services/servers.svc.js';
import 'vsa/js/directives/cv-select-hypervisors-directive.js';
import 'vsa/js/factories/collections.factory.js';
import 'vsa/js/factories/replicationGroups.factory.js';
import 'vsa/js/factories/serverUI.factory.js';
import 'vsa/js/services/vsobjtype.factory.js';
import 'adminConsole/js/factories/clientGroups.factory.js';
import 'vsa/js/directives/cv-add-vm-content-directive.js';

import { vsaAppServerModule } from 'common/js/modules';

var mod = vsaAppServerModule;

/**
 * A controller for handling the functionality on the Configure Replication Group setup page.
 */
mod.controller('replicationGroupContentController', [
	'$scope',
	'$state',
	'$dialogs',
	'cvLoc',
	'cvUtil',
	'serverService',
	'collectionFactory',
	'replicationGroupFactory',
	'replicationGroupsService',
	'clientGroupsFactory',
	'cvBreadcrumbsTabsFactory',
	'vsObjTypeFactory',
	'REPLICATION_TYPES',
	'REP_TYPES',
	'VENDORS',
	function(
		$scope,
		$state,
		$dialogs,
		cvLoc,
		cvUtil,
		serverService,
		collectionFactory,
		replicationGroupFactory,
		replicationGroupsService,
		clientGroupsFactory,
		cvBreadcrumbsTabsFactory,
		vsObjTypeFactory,
		REPLICATION_TYPES,
		REP_TYPES,
		VENDORS
	) {
		var self = this;
		function initialize() {
			replicationGroupFactory.setSimplifiedLiveSyncUI(true);
			$scope.enableAddRuleReplicationGroup = replicationGroupFactory.enableAddRuleReplicationGroup;
			$scope.replicationGroup.currentStep = 0;
			cvBreadcrumbsTabsFactory.addBreadCrumbs($scope.replicationGroup.breadCrumbs);
			self.selectedSrcVendor = VENDORS.VMW.type;
			$scope.sourceVendors = replicationGroupFactory.supportedSourceVendors();
			self.isLiveSync = $scope.replicationGroup.attributes.replicationType === REPLICATION_TYPES.STREAMING_REPLICATION;
			checkRepGroupAccessNodes();
			$scope.ctrl = {
				refreshHypervisor: refreshHypervisor
			};

			$scope.ctrl.openAddRuleDialog = replicationGroupFactory.openAddRuleDialog;
			self.collectionInfo = {
				selectedContent: []
			};

			if (!_.get($scope, 'replicationGroup.contentTab.initialized', false)) {
				$scope.replicationGroup.selectedHypervisor =
					$scope.replicationGroup.selectedHypervisor || cvUtil.getIStevenLocLabels();
				$scope.replicationGroup.loadedTargetsDetail = [];
				$scope.replicationGroup.contentTab = $scope.replicationGroup.contentTab || {};
				$scope.replicationGroup.selectedSrcVendorOld = VENDORS.VMW.type;
				replicationGroupFactory.getContinuousPairs().then(function(data) {
					$scope.replicationGroup.blr = {
						pairs: _.get(data, 'data.siteInfo', [])
					};
				});
				$scope.replicationGroup.replicationType = $scope.replicationGroup.replicationType || REP_TYPES.PERIODIC;
				$scope.replicationGroup.contentTab.initialized = true;
				collectionFactory.clearCollectionContent();
			} else {
				$scope.replicationGroup.selectedVMs &&
					$scope.replicationGroup.selectedVMs.forEach(selectedVM => {
						selectedVM.icon = vsObjTypeFactory.getIconClass(
							selectedVM.type,
							self.selectedSrcVendor,
							!selectedVM.poweredOff
						);
					});
				self.showSelectedVMs = true;
				self.showAddRulesButton = getShowAddRulesButton($scope.replicationGroup.selectedHypervisor.type);
			}
		}

		// check to see if group creation may proceed or not
		function checkRepGroupAccessNodes() {
			$scope.noAccessNodes = false;
			replicationGroupsService
				.checkRepGroupAccessNodes($scope.sourceVendors)
				.success(function(data) {
					// check if data contains a boolean value or string
					if (!data) {
						$scope.noAccessNodes = true;
					}
				})
				.error(function(e) {
					self.serverMessage = cvUtil.errMsg(e);
				});
		}

		$scope.createAccessNode = function() {
			// send action and model params
			clientGroupsFactory.setClientGroupListActionParams({
				action: 'add',
				value: 'addWindowsServer',
				model: { packages: ['VSA'] }
			});
			$state.go('clientGroupDetails');
		};

		function refreshHypervisor() {
			self.serverMessage = cvUtil.emptyMsg();
			if ($scope.ctrl.refresh) {
				$scope.ctrl.refresh(
					$scope.replicationGroup.selectedHypervisor.clientId,
					$scope.replicationGroup.selectedHypervisor.clientName
				);
			}
			if ($scope.replicationGroup.selectedHypervisor) {
				self.selectedSrcVendor = $scope.replicationGroup.selectedHypervisor.type;
			}

			$scope.scId = $scope.replicationGroup.selectedHypervisor.clientId;
			$scope.serverType = $scope.replicationGroup.selectedHypervisor.type;
			$state.serverType = $scope.serverType;
			collectionFactory.setBackupSetId(0);
			collectionFactory.setApplicationId(106);
			collectionFactory.setInstanceId($scope.replicationGroup.selectedHypervisor.instanceId);

			$scope.ctrl.displayErrorMsg('');
			self.showSelectedVMs = false;

			/*
			 * If the vendor has changed, the targets have to be refetched.
			 */
			if ($scope.replicationGroup.selectedSrcVendorOld != self.selectedSrcVendor) {
				$scope.replicationGroup.selectedSrcVendorOld = self.selectedSrcVendor;
				$scope.replicationGroup.allTargets = null;
			}

			self.showAddRulesButton = getShowAddRulesButton($scope.replicationGroup.selectedHypervisor.type);
			$scope.ctrl.updateShowRules && $scope.ctrl.updateShowRules(self.showAddRulesButton);
		}

		$scope.goBackToReplicationGroups = function() {
			$state.go('replicationGroups');
		};

		$scope.goToTarget = function() {
			self.serverMessage = cvUtil.emptyMsg();
			if (!isValid()) {
				return false;
			}
			$scope.enableAddRuleReplicationGroup ? goToTargetWithAddRule() : goToTargetWithoutAddRule();
		};

		self.cancel = function() {
			const title = cvLoc('label.confirmNavigationTitle');
			const confirmText = cvLoc('label.confirmCancel');
			const yesFunction = () => $state.go('replicationGroups');
			const noFunction = () => event.preventDefault();
			$dialogs.confirm(title, confirmText, {
				yesFunction: yesFunction,
				noFunction: noFunction
			});
		};

		function getCollectionContent(selectedContent) {
			self.serverMessage = cvUtil.emptyMsg();
			if (!$scope.enableAddRuleReplicationGroup) {
				collectionFactory.clearCollectionContent();
				var contentToAdd = convertSelectedContent(self.collectionInfo.selectedContent);
				collectionFactory.setContent(contentToAdd, self.selectedSrcVendor);
			}

			$scope.replicationGroup.selectedContent = _.cloneDeep(collectionFactory.getCollectionContent());
			// Load VMs
			return serverService
				.previewCollectionContent({
					collectionContentJson: JSON.stringify(selectedContent || collectionFactory.getCollectionContent()),
					collectionId: 0,
					serverId: $scope.replicationGroup.selectedHypervisor.clientId,
					backupsetId: 0,
					instanceId: $scope.replicationGroup.selectedHypervisor.instanceId,
					applicationId: 106
				})
				.then(
					function(data) {
						return _.get(data, 'data.scList', []);
					},
					function(err) {
						/* If rules are used, do not show any error. */
						if ($scope.replicationGroup.useAllocationPolicyForRestore) {
							return [];
						}
						let errorMsg = _.get(err, 'data', cvLoc('genericError'));
						self.serverMessage = cvUtil.errMsg(errorMsg);
						$log.debug(`Error fetching VMs: ${err}`);
						return [];
					}
				);
		}

		/*
		 * Converts a list of items selected using the cv-browse-collection-content directive into a list of
		 * VMSubClientEntity objects (for use in content and filter lists).
		 */
		function convertSelectedContent(selectedContent) {
			var convertedList = [];
			for (var i = 0; i < selectedContent.length; i++) {
				var item = selectedContent[i];
				var converted = {
					displayName: item.displayName,
					name: item.guid,
					path: '',
					type: item.type,
					allOrAnyChildren: true,
					equalsOrNotEquals: true
				};
				convertedList.push(converted);
			}
			return convertedList;
		}

		/* Determines if all the inputs in the page are valid */
		function isValid() {
			self.serverMessage = cvUtil.emptyMsg();
			let isValid = true;
			if (!$scope.replicationGroup.name) {
				isValid = false;
			}
			if (isValid && self.showSelectedVMs && !$scope.enableAddRuleReplicationGroup) {
				return true;
			}
			if (_.get($scope, 'replicationGroup.selectedHypervisor.clientId', 0) === 0) {
				$scope.ctrl.displayErrorMsg(cvLoc('placeholder.selectHypervisor'));
				isValid = false;
			}
			if (
				!$scope.enableAddRuleReplicationGroup &&
				(!self.collectionInfo.selectedContent || !self.collectionInfo.selectedContent.length)
			) {
				isValid = false;
			}

			if ($scope.enableAddRuleReplicationGroup && !_.get(collectionFactory.getCollectionContent(), 'content.length')) {
				self.serverMessage = cvUtil.errMsgLoc('label.noVirtualMachines');
				isValid = false;
			}

			return isValid;
		}

		const getShowAddRulesButton = function(vendor) {
			const addRuleSupportedVendors = [VENDORS.AMAZON.type, VENDORS.AZURE_V2.type, VENDORS.VMW.type];
			return addRuleSupportedVendors.includes(vendor);
		};

		const filterStep = function(state) {
			return $scope.replicationGroup.vsa.allSteps.filter(function(step) {
				return step.state !== state;
			});
		};

		const goToTargetTab = function() {
			$state.go('replicationGroup.selectTarget');
			$scope.replicationGroup.currentStep++;
		};

		const goToTargetWithAddRule = function() {
			let content =
				(collectionFactory.getCollectionContent() && collectionFactory.getCollectionContent().content) || [];
			let rulesContent = content.filter(content => !!content.isRule);

			/*
			 * Scenarios:
			 * - Only non rules content, then call the getCollectionContent().
			 * - Only rules content, then do not call the getCollectionContent().
			 */
			if (_.isEmpty(rulesContent)) {
				/* Rules have not been added. Call getCollectionContent */
				$scope.replicationGroup.useAllocationPolicyForRestore = false;
				$scope.replicationGroup.vsa.filteredSteps = $scope.replicationGroup.vsa.allSteps;
				goToTargetWithoutAddRule();
			} else {
				/* Only rules has been added. Do not call getCollectionContent */
				setRuleRelatedChanges();
				goToTargetTab();
			}

			function setRuleRelatedChanges() {
				if (
					$scope.replicationGroup.replicationType === REP_TYPES.PERIODIC &&
					!_.get($scope, 'replicationGroup.recoveryOptions.isSnapbackupEnabled', false)
				) {
					$scope.replicationGroup.useAllocationPolicyForRestore = true;
					$scope.replicationGroup.vsa.filteredSteps = filterStep('replicationGroup.overrideOptions');
					$scope.replicationGroup.vmAdvRestOptions = null;
					$scope.replicationGroup.modifiedVms = null;
					$scope.replicationGroup.allTargets = null;
					$scope.replicationGroup.selectedContent = _.cloneDeep(collectionFactory.getCollectionContent());
				}
			}
		};

		const goToTargetWithoutAddRule = function(selectedContent) {
			/*
			 * If showSelectedVMs is set, then the values were not changed and we can go to the next step
			 * without any validation
			 */
			if (self.showSelectedVMs && !$scope.enableAddRuleReplicationGroup) {
				$state.go('replicationGroup.selectTarget');
				$scope.replicationGroup.currentStep++;
				return;
			}

			if (!$scope.enableAddRuleReplicationGroup) {
				collectionFactory.clearCollectionContent();
				var contentToAdd = convertSelectedContent(self.collectionInfo.selectedContent);
				collectionFactory.setContent(contentToAdd, self.selectedSrcVendor);
				$scope.replicationGroup.selectedContent = _.cloneDeep(collectionFactory.getCollectionContent());
			}

			let nonVMContent = selectedContent || self.collectionInfo.selectedContent.find(content => content.type !== 'VM');
			if (_.isEmpty(nonVMContent) && !$scope.enableAddRuleReplicationGroup) {
				$scope.replicationGroup.selectedVMs = self.collectionInfo.selectedContent;
				$scope.replicationGroup.selectedVMs.forEach(vm => {
					vm.strGUID = vm.guid;
					vm.name = vm.displayName;
					vm.type = 'VM';
				});
				$scope.replicationGroup.selectedVMs = replicationGroupFactory.sortByName($scope.replicationGroup.selectedVMs);
				$scope.replicationGroup.duplicateContinuousSourceMachines = replicationGroupFactory.getDuplicateContinuousSourceMachines(
					$scope.replicationGroup.selectedVMs,
					$scope.replicationGroup.blr.pairs
				);
				goToTargetTab();
			} else {
				getCollectionContent(selectedContent).then(function(selectedVMs) {
					if (_.isEmpty(selectedVMs)) {
						self.serverMessage = cvUtil.errMsgLoc('msg.noVMsAvailable');
						return;
					}

					selectedVMs.forEach(vm => {
						vm.strGUID = vm.guid;
						vm.poweredOff = vm.poweredStatus === 0;
						vm.type = 'VM';
					});

					$scope.replicationGroup.selectedVMs = replicationGroupFactory.sortByName(_.uniqBy(selectedVMs, 'strGUID'));
					$scope.replicationGroup.duplicateContinuousSourceMachines = replicationGroupFactory.getDuplicateContinuousSourceMachines(
						$scope.replicationGroup.selectedVMs,
						$scope.replicationGroup.blr.pairs
					);
					goToTargetTab();
				});
			}
		};

		initialize();
	}
]);

export default mod;
