import 'fsa/js/factories/blrFSToFS.factory.js';
import 'modules/setup/js/directives/setup-steps.js';
import 'vsa/js/controllers/replication.ctrl.js';
import 'vsa/js/directives/cv-restore-options-azure-directive.js';

import { vsaAppServerModule } from 'common/js/modules';

var mod = vsaAppServerModule;

/**
 * The different replication solutions the user can select from.
 *
 * @var {Object}
 */
mod.constant('REPLICATION_SOLUTIONS', {
	VIRTUALIZATION: 'VSA',
	FILE_SYSTEM: 'FS',
	DATABASE: 'DB'
});

/**
 * The different replication types the user can select from.
 *
 * @var {Object}
 */
mod.constant('REPLICATION_TYPES', {
	STREAMING_REPLICATION: 'LiveSync',
	DIRECT_REPLICATION: 'LiveSyncDirect',
	CONTINUOUS_REPLICATION: 'LiveSyncIO',
	LIVESYNCIO_FSTOFS: 'LiveSyncIOFSFS'
});

/* TMMsg.x ReplicationType*/
mod.constant('REP_TYPES', {
	PERIODIC: 1,
	CONTINUOUS: 2
});

/* BlockReplication.x BLRRecoveryType*/
mod.constant('BLR_RECOVERY_TYPE', {
	LIVE: 1,
	SNAPSHOT: 2,
	GRANULAR: 3,
	GRANULARV2: 4
});

/**
 * The different source vendors the user can select from.
 *
 * @var {Object}
 * @replicationGroup:
 * @VMW - VMW, AZURE, AMAZON
 * @HyperV - HyperV, Azure
 * @AZURE - AZURE
 */

mod.constant('VENDORS', {
	VMW: {
		id: 1,
		type: 'VMW',
		text: 'VMware',
		policyType: 'VMWARE',
		policyTypes: ['VMWARE', 'VMW_LIVEMOUNT', 'VMW_BACKUP_LABTEMPLATE', 'VMW_LABTEMPLATE'],
		policyId: 0,
		policyText: 'VMware vCenter',
		repGroupSupport: ['AZURE_V2', 'VMW', 'AMAZON', 'MICROSOFT'],
		autoUpdateSupport: ['VMW', 'AZURE_V2']
	},
	AZURE_V2: {
		id: 7,
		type: 'AZURE_V2',
		text: 'Microsoft Azure Resource Manager',
		policyType: 'AZURE_RESOURCE_MANAGER',
		policyId: 7,
		policyText: 'Microsoft Azure Resource Manager',
		repGroupSupport: ['AZURE_V2'],
		autoUpdateSupport: ['AZURE_V2']
	},
	MICROSOFT: {
		id: 2,
		type: 'MICROSOFT',
		text: 'Microsoft Hyper-V',
		policyType: 'MICROSOFT',
		policyText: 'Microsoft Hyper-V',
		policyId: 2,
		repGroupSupport: ['MICROSOFT', 'AZURE_V2'],
		autoUpdateSupport: []
	},
	AMAZON: {
		id: 4,
		type: 'AMAZON',
		text: 'Amazon',
		policyType: 'AMAZON',
		policyId: 1,
		policyText: 'Amazon',
		repGroupSupport: ['AMAZON', 'VMW'],
		autoUpdateSupport: []
	},
	ORACLE_CLOUD_INFRASTRUCTURE: {
		id: 19,
		type: 'ORACLE_CLOUD_INFRASTRUCTURE',
		text: 'ORACLE_CLOUD_INFRASTRUCTURE',
		policyType: 'ORACLE_CLOUD_INFRASTRUCTURE',
		policyId: 15,
		policyText: 'ORACLE_CLOUD_INFRASTRUCTURE',
		repGroupSupport: ['ORACLE_CLOUD_INFRASTRUCTURE'],
		autoUpdateSupport: []
	},
	OPENSTACK: {
		id: 12,
		type: 'OPENSTACK',
		text: 'OpenStack',
		policyType: 'OPENSTACK',
		policyId: 10,
		policyText: 'OpenStack',
		repGroupSupport: ['OPENSTACK'],
		autoUpdateSupport: ['OPENSTACK']
	},
	NUTANIX: {
		id: 9,
		type: 'NUTANIX',
		text: 'Nutanix',
		policyType: 'NUTANIX_AHV',
		policyId: 17,
		policyText: 'Nutanix AHV',
		repGroupSupport: ['NUTANIX_AHV'],
		autoUpdateSupport: ['NUTANIX_AHV']
	}
});

mod.constant('AWS_REPLICATION_METHOD', {
	HOTADD: 1,
	IMPORT: 2
});

/**
 * A factory for creating a new ReplicationGroup.
 */
mod.factory('ReplicationGroup', [
	function() {
		var ReplicationGroup = function() {
			this.attributes = {};
		};

		/**
		 * Place any methods belonging to the replication group instance in here.
		 */
		angular.extend(ReplicationGroup.prototype, {});

		return ReplicationGroup;
	}
]);

/**
 * A factory for creating a new FsReplicationGroup.
 */
mod.factory('FsReplicationGroup', [
	function() {
		var FsReplicationGroup = function() {
			this.attributes = {};
		};

		/**
		 * Place any methods belonging to the replication group instance in here.
		 */
		angular.extend(FsReplicationGroup.prototype, {});

		return FsReplicationGroup;
	}
]);

/*
 * A parent controller for the Configure Replication Group setup pages. All common methods shared by the
 * setup templates can be placed in here.
 */
mod.controller('replicationGroupParentController', [
	'$scope',
	'$state',
	'ReplicationGroup',
	'REPLICATION_SOLUTIONS',
	'REPLICATION_TYPES',
	'cvLoc',
	'$stateParams',
	'replicationFactory',
	'dataCachingFactory',
	'blrFSToFSFactory',
	'AppTypes',
	'$transitions',
	function(
		$scope,
		$state,
		ReplicationGroup,
		REPLICATION_SOLUTIONS,
		REPLICATION_TYPES,
		cvLoc,
		$stateParams,
		replicationFactory,
		dataCachingFactory,
		blrFSToFSFactory,
		AppTypes,
		$transitions
	) {
		var self = this;

		self.replicationGroup = new ReplicationGroup();
		$scope.replicationGroup = self.replicationGroup;
		// Check if browser refresh
		$scope.replicationGroup.attributes.refreshBrowser = function() {
			var isRefreshed = false;
			if (!_.has($scope, 'replicationGroup.name')) {
				$state.go('replicationGroup.selectContent');
				isRefreshed = true;
			}

			return isRefreshed;
		};

		$scope.replicationGroup.clearVMSelected = function() {
			$scope.replicationGroup.showPlan = false;
			$scope.replicationGroup.vms = [];
			$scope.replicationGroup.vmGroups = null;
			$scope.replicationGroup.selectedVMs = null;
			$scope.replicationGroup.vmPreview = null;
			$scope.replicationGroup.selectedVMGroup = null;
			$scope.replicationGroup.allTargets = null;
			$scope.replicationGroup.modifiedVmsList = null;
			$scope.replicationGroup.browseVMsPoppedUp = false;
			$scope.replicationGroup.isBrowseVMsAvailable = false;
			$scope.replicationGroup.useAllocationPolicyForRestore = false;
		};

		dataCachingFactory.clearCacheData();

		// set avaiable replication types
		self.replicationGroup.replicationTypeClass = cvConfig.enableBLR
			? 'col-xs-12 col-lg-4 text-center'
			: 'col-xs-12 col-lg-6 text-center';
		self.replicationGroup.showBLR = cvConfig.enableBLR;
		// populate the value of solution and replication type from stateparams
		$scope.replicationGroup.attributes.solution = $stateParams['solution'];
		$scope.replicationGroup.attributes.replicationType = $stateParams['replicationType'];

		$scope.replicationGroup.isBLRFSToFS = false;
		if (
			$scope.replicationGroup.attributes.solution &&
			$scope.replicationGroup.attributes.solution === REPLICATION_SOLUTIONS.FILE_SYSTEM
		) {
			$scope.replicationGroup.isBLRFSToFS = true;
		}

		$scope.replicationGroup.allTargets = null;

		var isEdit = $stateParams['edit'];
		$scope.replicationGroup.currentStep = 0;
		$scope.replicationGroup.loadTab = function(idx) {
			$scope.replicationGroup.currentStep = idx;
			$state.go($scope.replicationGroup.vsa.filteredSteps[idx].state);
		};

		self.replicationGroup.attributes.appType = $stateParams['appType'];

		$scope.replicationGroup.vsa = {
			// The all steps will store all steps that vsa will need
			allSteps: [
				{
					state: 'replicationGroup.selectContent',
					name: cvLoc('label.selectContent')
				},
				{
					state: 'replicationGroup.selectTarget',
					name: cvLoc('label.selectTarget')
				},
				{
					state: 'replicationGroup.recoveryOptions',
					name: cvLoc('label.storageCache')
				},
				{
					state: 'replicationGroup.overrideOptions',
					name: cvLoc('label.overrideOptions')
				},
				{
					state: 'replicationGroup.summary',
					name: cvLoc('label.replicationGroupsDetail')
				}
			]
		};

		// Filters step will store steps dynamically based on some condition
		$scope.replicationGroup.vsa.filteredSteps = angular.copy($scope.replicationGroup.vsa.allSteps);

		$scope.replicationGroup.db = {
			// The all steps will store all steps that db will need
			sqlSteps: [
				{
					state: 'configureReplicationGroup.selectDBContent',
					name: cvLoc('label.selectSource'),
					stepCount: 0
				},
				{
					state: 'configureReplicationGroup.selectDBTarget',
					name: cvLoc('label.selectTarget'),
					stepCount: 1
				},
				{
					state: 'configureReplicationGroup.overrideDBOptions',
					name: cvLoc('label.overrideOptions'),
					stepCount: 2
				}
			],
			oracleSteps: [
				{
					state: 'configureReplicationGroup.selectOracleContent',
					name: cvLoc('label.selectSource'),
					stepCount: 0
				},
				{
					state: 'configureReplicationGroup.selectOracleTarget',
					name: cvLoc('label.selectTarget'),
					stepCount: 1
				},
				{
					state: 'configureReplicationGroup.overrideOracleOptions',
					name: cvLoc('label.overrideOptions'),
					stepCount: 2
				}
			],
			dbSteps: [
				{
					state: 'configureReplicationGroup.selectReplicationSource',
					name: cvLoc('label.selectSource'),
					stepCount: 0
				},
				{
					state: 'configureReplicationGroup.selectReplicationTarget',
					name: cvLoc('label.selectTarget'),
					stepCount: 1
				}
			]
		};

		if ($stateParams && $stateParams.appType && parseInt($stateParams.appType) === AppTypes.SQL_SERVER) {
			$scope.replicationGroup.db.filteredSteps = angular.copy($scope.replicationGroup.db.sqlSteps);
		} else if (
			$stateParams &&
			$stateParams.appType &&
			(parseInt($stateParams.appType) === AppTypes.ORACLE || parseInt($stateParams.appType) === AppTypes.ORACLE_RAC)
		) {
			$scope.replicationGroup.db.filteredSteps = angular.copy($scope.replicationGroup.db.oracleSteps);
		} else if ($stateParams && $stateParams.appType && parseInt($stateParams.appType) === AppTypes.SAP_HANA) {
			$scope.replicationGroup.db.filteredSteps = angular.copy($scope.replicationGroup.db.dbSteps);
		} else {
			let overrideStep = {
				state: 'configureReplicationGroup.overrideOracleOptions',
				name: cvLoc('label.overrideOptions'),
				stepCount: 2
			};
			$scope.replicationGroup.db.dbSteps.push(overrideStep);
			$scope.replicationGroup.db.filteredSteps = angular.copy($scope.replicationGroup.db.dbSteps);
		}

		$scope.replicationGroup.db.currentStep = function() {
			for (let i = 0; i < $scope.replicationGroup.db.filteredSteps.length; i++) {
				if ($state.current.name === $scope.replicationGroup.db.filteredSteps[i]['state']) {
					return $scope.replicationGroup.db.filteredSteps[i]['stepCount'];
				}
			}
		};

		var breadCrumbs = [
			{
				title: cvLoc('label.nav.replication.groups'),
				link: '#replicationGroups'
			}
		];

		if (isEdit) {
			// retrieve the task data
			$scope.replicationGroup.task = replicationFactory.getReplicationGroupTask();
			$scope.editMode = $scope.replicationGroup.task !== undefined;
			$scope.replicationGroup.editMode = $scope.editMode;
		}

		$scope.replicationGroup.breadCrumbs = breadCrumbs;

		// check if the step is not what is requested for
		var goToStep = function(step) {
			if (!$state.is(step)) {
				$state.go(step);
			}
		};

		if ($scope.replicationGroup.attributes.solution == REPLICATION_SOLUTIONS.VIRTUALIZATION) {
			$scope.helpText = cvLoc('label.configureReplicationGroup.help');
			$scope.replicationGroupPageTitle = $scope.replicationGroup.task
				? cvLoc('label.configureReplicationGroup.edit')
				: cvLoc('label.configureReplicationGroup');
		} else if ($scope.replicationGroup.attributes.solution == REPLICATION_SOLUTIONS.FILE_SYSTEM) {
			$scope.helpText = cvLoc('label.configureReplicationGroupFS.help');
			$scope.replicationGroupPageTitle = cvLoc('label.configureReplicationGroupFileSystem');
		} else if ($scope.replicationGroup.attributes.solution == REPLICATION_SOLUTIONS.DATABASE) {
			$scope.helpText = cvLoc('label.configureReplicationDBGroup.help');

			if ($stateParams && $stateParams.appType && parseInt($stateParams.appType) === AppTypes.SQL_SERVER) {
				$scope.replicationGroupPageTitle = $scope.replicationGroup.task
					? cvLoc('label.configureReplicationDBGroup.edit')
					: cvLoc('label.configureReplicationDBGroup');
			} else if (
				$stateParams &&
				$stateParams.appType &&
				(parseInt($stateParams.appType) === AppTypes.ORACLE || parseInt($stateParams.appType) === AppTypes.ORACLE_RAC)
			) {
				$scope.replicationGroupPageTitle = $scope.replicationGroup.task
					? cvLoc('label.configureReplicationOracleGroup.edit')
					: cvLoc('label.configureReplicationOracleGroup');
			} else if ($stateParams && $stateParams.appType && parseInt($stateParams.appType) === AppTypes.SAP_HANA) {
				{
					if ($scope.replicationGroup.task) {
						$scope.replicationGroupPageTitle =
							cvLoc('title.configureReplicationGroup.edit') + ' - ' + cvLoc('title.sapHana');
					} else {
						$scope.replicationGroupPageTitle =
							cvLoc('title.configureReplicationGroup') + ' - ' + cvLoc('title.sapHana');
					}
				}
			}
		}

		self.liveSyncRedirectToVSAOrFs = function() {
			if (
				$scope.replicationGroup.attributes.solution == REPLICATION_SOLUTIONS.FILE_SYSTEM &&
				$scope.replicationGroup.attributes.replicationType === REPLICATION_TYPES.STREAMING_REPLICATION
			) {
				$state.go('configureReplicationGroup.selectFsContent');
			} else if (
				$scope.replicationGroup.attributes.solution == REPLICATION_SOLUTIONS.FILE_SYSTEM &&
				$scope.replicationGroup.attributes.replicationType === REPLICATION_TYPES.LIVESYNCIO_FSTOFS
			) {
				// clear out shared data
				blrFSToFSFactory.resetAttributes();
				blrFSToFSFactory.openBLRFSPairsModal();
			} else if ($scope.replicationGroup.attributes.solution == REPLICATION_SOLUTIONS.DATABASE) {
				if ($stateParams['appType'] == AppTypes.SQL_SERVER) {
					$state.go('configureReplicationGroup.selectDBContent');
				} else if ($stateParams['appType'] == AppTypes.ORACLE) {
					$state.go('configureReplicationGroup.selectOracleContent');
				} else if ($stateParams['appType'] == AppTypes.SAP_HANA) {
					$state.go('configureReplicationGroup.selectReplicationSource');
				}
			} else {
				$scope.replicationGroup.loadTab($scope.replicationGroup.currentStep);
				$state.go('configureReplicationGroup.selectContent');
			}
		};

		//Created this function separately for BLR-FS options only, to move HTML logic to JS as of suggestion during code review.
		self.redirectToFS = function(replicationType) {
			$scope.replicationGroup.attributes.replicationType = replicationType;
			self.liveSyncRedirectToVSAOrFs();
		};

		if ($scope.replicationGroup.attributes.solution == REPLICATION_SOLUTIONS.DATABASE && !isEdit) {
			if ($stateParams['appType'] == AppTypes.SQL_SERVER) {
				goToStep('configureReplicationGroup.selectDBContent');
			} else if ($stateParams['appType'] == AppTypes.ORACLE) {
				goToStep('configureReplicationGroup.selectOracleContent');
			} else if ($stateParams['appType'] == AppTypes.SAP_HANA) {
				$state.go('configureReplicationGroup.selectReplicationSource');
			}
		} else if (
			$scope.replicationGroup.attributes.solution &&
			!$scope.replicationGroup.attributes.replicationType &&
			$scope.replicationGroup.attributes.solution !== 'DB'
		) {
			// if solution and replication type is not present, go to solution
			goToStep('configureReplicationGroup.replicationType');
		}

		$transitions.onStart({}, function(transition) {
			switch (transition.to().name) {
				case 'configureReplicationGroup.solution':
					self.replicationGroup.attributes.solution = undefined;
				case 'configureReplicationGroup.replicationType':
					self.replicationGroup.attributes.replicationType = undefined;
					break;
			}
		});

		self.REPLICATION_SOLUTIONS = REPLICATION_SOLUTIONS;
		self.REPLICATION_TYPES = REPLICATION_TYPES;
	}
]);

export default mod;
