<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div data-ng-app="drApp.postScript" data-ng-controller="postScriptController as postScriptController">
	<div class="setup-title">
		<h1><cv:msg key="label.postScriptOptions" bundle="dr"/></h1>
	</div>
	<div class="bootstrap-wrapper">
		<div class="modal-body">
			<div class="form-horizontal">
				<form data-ng-submit="postScriptController.save()">
					<div class="form-group">
						<div class="col-md-4">
							<label for="uncNetworkPath"><cv:msg key="label.uncNetworkPath" bundle="dr"/></label>
						</div>
						<div class="col-md-8">
							<input type="text" id="uncNetworkPath" data-ng-model="postScriptController.uncNetworkPath" ng-required autofocus>
						</div>
						<div class="col-md-offset-4 col-md-8">
							<div class="{{postScriptController.networkPathValidation.type}} error">{{postScriptController.networkPathValidation.message}}</div>
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-md-4">
							<label for="username"><cv:msg key="label.userName" bundle="dr"/></label>
						</div>
						<div class="col-md-8">
							<input type="text" id="username" data-ng-model="postScriptController.username" ng-required>
						</div>
						<div class="col-md-offset-4 col-md-8">
							<div class="{{postScriptController.userNameValidation.type}} error">{{postScriptController.userNameValidation.message}}</div>
						</div>
					</div>
					<div class="form-group" data-ng-if="postScriptController.isEdit && !postScriptController.changePassword">
						<div class="col-md-12">
							<a href="" data-ng-click="postScriptController.changePassword=true">
								<cv:msg key="label.changePassword" bundle="dr" />
							</a>
						</div>
					</div>
					<div class="form-group" data-ng-show="!postScriptController.isEdit || postScriptController.changePassword">
						<div class="col-md-4">
							<label for="password"><cv:msg key="label.password" bundle="dr"/></label>
						</div>
						<div class="col-md-8">
							<input type="password" id="password" data-ng-model="postScriptController.password" ng-required>
						</div>
						<div class="col-md-offset-4 col-md-8">
							<div class="{{postScriptController.passwordValidation.type}} error">{{postScriptController.passwordValidation.message}}</div>
						</div>
					</div>
					<div class="form-group" data-ng-show="!postScriptController.isEdit || postScriptController.changePassword">
						<div class="col-md-4">
							<label for="confirmPassword"><cv:msg key="label.confirmPassword" bundle="dr"/></label>
						</div>
						<div class="col-md-8">
							<input type="password" id="confirmPassword" data-ng-model="postScriptController.confirmPassword" 
							ng-required>
						</div>
						<div class="col-md-offset-4 col-md-8">
							<div class="{{postScriptController.confirmPasswordValidation.type}} error">{{postScriptController.confirmPasswordValidation.message}}</div>
						</div>
					</div>
					<div class="form-header push-down"><cv:msg key="label.vmGuestOptions" bundle="dr"/></div>
					<div class="form-group">
						<div class="col-md-4">
							<label for="usernameuserImpersonation"><cv:msg key="label.userName" bundle="dr"/></label>
						</div>
						<div class="col-md-8">
							<input type="text" id="usernameuserImpersonation" data-ng-model="postScriptController.userImpersonation.username" ng-required>
						</div>
						<div class="col-md-offset-4 col-md-8">
							<div class="{{postScriptController.userImpersonation.userNameValidation.type}} error">{{postScriptController.userImpersonation.userNameValidation.message}}</div>
						</div>
					</div>
					<div class="form-group" data-ng-if="postScriptController.isEdit && !postScriptController.changeImpersonationPassword">
						<div class="col-md-12">
							<a href="" data-ng-click="postScriptController.changeImpersonationPassword=true">
								<cv:msg key="label.changePassword" bundle="dr" />
							</a>
						</div>
					</div>
					<div class="form-group" data-ng-if="!postScriptController.isEdit || postScriptController.changeImpersonationPassword">
						<div class="col-md-4">
							<label for="passworduserImpersonation"><cv:msg key="label.password" bundle="dr"/></label>
						</div>
						<div class="col-md-8">
							<input type="password" id="passworduserImpersonation" data-ng-model="postScriptController.userImpersonation.password" ng-required>
						</div>
						<div class="col-md-offset-4 col-md-8">
							<div class="{{postScriptController.userImpersonation.passwordValidation.type}} error">{{postScriptController.userImpersonation.passwordValidation.message}}</div>
						</div>
					</div>
					<div class="form-group" data-ng-if="!postScriptController.isEdit || postScriptController.changeImpersonationPassword">
						<div class="col-md-4">
							<label for="confirmPassworduserImpersonation"><cv:msg key="label.confirmPassword" bundle="dr"/></label>
						</div>
						<div class="col-md-8">
							<input type="password" id="confirmPassworduserImpersonation" data-ng-model="postScriptController.userImpersonation.confirmPassword" 
							ng-required>
						</div>
						<div class="col-md-offset-4 col-md-8">
							<div class="{{postScriptController.userImpersonation.confirmPasswordValidation.type}} error">{{postScriptController.userImpersonation.confirmPasswordValidation.message}}</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
	<div class="setup-content">
		<div class="button-container">
			<button id="postScriptDialog_button_#7650" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="postScriptController.closeModal()"><cv:msg key="Cancel" bundle="messages"/></button> 
			<button id="postScriptDialog_button_#4599" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="postScriptController.save()"><cv:msg key="Save" bundle="messages"/></button> 
		</div>
	</div>
</div>