<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<span data-ng-if="::!fgCreateController.isEditMode"><cv:msg key="label.addfailoverGroup" bundle="dr"/> - {{::fgCreateController.vAppSourceText}}</span>
		<span data-ng-if="::fgCreateController.isEditMode"><cv:msg key="label.editfailoverGroup" bundle="dr"/></span>
		<cv-help-component data-help-text="<cv:msg key='label.failoverGroupDescription' bundle='dr' />"></cv-help-component>
		<span data-ng-show="fgCreateController.isDataLoading" class="grid-data-spinner ng-hide">
			<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
		</span>
	</h1>
</div>
<div>
	<form class="bootstrap-wrapper" name="createGroup" id="createGroup" data-cv-submit="fgCreateController.createFailoverGroup()">
		<div class="form-group">
			<label class="col-xs-12 col-sm-5" for="groupName"><cv:msg key="label.name" bundle="dr"/></label>
			<div class="col-xs-12 col-sm-7">
				<input type="text" data-ng-model="fgCreateController.vApp.vAppEntity.vAppName" id="groupName" name="groupName" data-ng-required autofocus novalidate />
			</div>
			<div class="col-lg-offset-3 col-lg-6 col-md-offset-4 col-md-6" data-ng-if="fgCreateController.groupNameValidation.message">
				<div class="{{fgCreateController.groupNameValidation.type}} error">{{fgCreateController.groupNameValidation.message}}</div>
			</div>
		</div>

		<div data-ng-if="fgCreateController.isSourceBackup() || fgCreateController.isSourceReplication()">
			<div class="form-group">
				<label class="col-xs-12 col-sm-5" for="serversDiv"><cv:msg key="label.serverGroupsAndHypervisors" bundle="dr"/></label>
				<span class="col-xs-12 col-sm-7">
					<isteven-multi-select
						input-model="fgCreateController.servers"
					  	output-model="fgCreateController.serversList"
					  	button-label="name"
					  	item-label="name"
					  	tick-property="selected"
					  	selection-mode="single"
					  	class="isteven-multi-select user-group-select"
					  	id="serversDiv"
					  	name="servers"
					  	search-property="servers.name"
					  	max-height="400px"
					  	on-item-click="fgCreateController.showMachines()"
					  	group-property="header"
					  	helper-elements="filter"
					  	translation="fgCreateController.localLangMachines">
					</isteven-multi-select>
				</span>
			</div>

			<div class="col-xs-12">
				<span data-ng-show="fgCreateController.isMachineDataLoading" class="grid-data-spinner ng-hide">
					<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
				</span>
			</div>

			<div class="form-group" data-ng-if="fgCreateController.destinationServerRequired">
				<label class="col-xs-12 col-sm-5" for="serversDestinationDiv"><cv:msg key="label.destinationHypervisor" bundle="dr"/></label>
				<span class="col-xs-12 col-sm-7">
					<isteven-multi-select
						input-model="fgCreateController.serversDestination"
						output-model="fgCreateController.serversDestinationSelected"
						button-label="name"
						item-label="name"
						tick-property="selected"
						selection-mode="single"
						class="isteven-multi-select user-group-select"
						id="serversDestinationDiv"
						name="serversDestinationDiv"
						search-property="serversDestination.name"
						on-item-click="fgCreateController.showMachinesFromDestinationHypervisor()"
						max-height="400px"
						group-property="header"
						helper-elements="filter"
						translation="fgCreateController.localLangDestinationHypervisor">
					</isteven-multi-select>
				</span>
			</div>

			<div class="panel panel-default">
				<div class="panel-body">
					<div class="form-group">
						<h4 class="col-xs-12 panel-title padding-left-0">
							<cv:msg key="label.virtualMachines" bundle="dr"/>
						</h4>
					</div>

					<div>
						<cv-grid cv-grid-options="fgCreateController.gridOptions"></cv-grid>
						<div class="form-group">
							<div class="col-xs-12">
								<span class="{{fgCreateController.machineValidation.type}}">{{fgCreateController.machineValidation.message}}</span>
							</div>
						</div>
					</div>	
				</div>
			</div>
		</div>

		<div data-ng-if="fgCreateController.isSourceArrayReplication()">
			<dr-array-replication ctrl="fgCreateController.ctrl" v-app="fgCreateController.vApp" v-app-operation="fgCreateController.vAppOperation"></dr-array-replication>
		</div>

		<cv-plain-accordion accordion-label="title.advancedOptions" collapsed="fgCreateController.collapseAdvancedOptions">
			<div class="form-group">
				<label for="delay" class="col-xs-12 col-sm-5">
					<cv:msg key="label.priorityInterval" bundle="dr"/>
				</label>
				<span class="col-xs-12 col-sm-7">
					<input type="number" name="delay" id="delay" data-ng-model="fgCreateController.vApp.delay" min="0" class="float-left">
				</span>
			</div>
			<div class="form-group">
				<div class="col-xs-12">
					<div class="margin-top-10">
						<cv-toggle toggle-name="continueOnFailure" toggle-label="label.continueOnFailure" value="fgCreateController.vApp.continueOnFailure"></cv-toggle>
					</div>
				</div>
			</div>
			<div class="form-group" data-ng-if="fgCreateController.isSourceReplication()" >
				<div class="col-xs-12">
					<div class="margin-top-10">
						<cv-toggle toggle-name="approvalRequired" toggle-label="msg.approvalRequired" value="fgCreateController.approvalRequired"></cv-toggle>
					</div>
				</div>
			</div>
			<div class="form-group" data-ng-if="fgCreateController.isSourceReplication()">
				<label for="userToApproveOrNotify" class="col-xs-12 col-sm-5"><cv:msg key="label.userToApproveOrNotify" bundle="dr"/></label>
				<span class="col-xs-12 col-sm-7">
					<isteven-multi-select
		   				  input-model="fgCreateController.users"
		   				  output-model="fgCreateController.usersSelected"
		  				  button-label="fullName"
						  item-label="fullName"
		   				  tick-property="selected"
		   				  selection-mode="single"
		   				  class="isteven-multi-select user-group-select"
		   				  id="users"
		   				  search-property="fullName"
		   				  max-height="150px"
		   				  group-property="header"
		   				  helper-elements="filter"
		   				  translation="fgCreateController.localLangUsers">
					</isteven-multi-select>
				</span>
				<div class="col-sm-12 col-sm-offset-5 col-sm-7">
					<span class="{{fgCreateController.approvalValidation.type}} ">{{fgCreateController.approvalValidation.message}}</span>
				</div>
			</div>
			<div data-ng-if="fgCreateController.destVendor === 'VMW'">
				<cv-vsa-replication-target
					selected-target="fgCreateController.selectedTarget"
					dest-vendor="fgCreateController.destVendor"
					app-type="fgCreateController.policyAppType">
				</cv-vsa-replication-target>
			</div>
			<div class="form-group" data-ng-if="fgCreateController.isSourceBackup()">
				<label for="lifeCyclePolicy" class="col-xs-12 col-sm-5"><cv:msg key="label.lifeCyclePolicy" bundle="dr"/></label>
				<span class="col-xs-12 col-sm-7">
					<isteven-multi-select
		   				  input-model="fgCreateController.lifeCyclePolicies"
		   				  output-model="fgCreateController.lifeCyclePolicySelected"
		  				  button-label="lifeCyclePolicyName"
						  item-label="lifeCyclePolicyName"
		   				  tick-property="selected"
		   				  selection-mode="single"
		   				  class="isteven-multi-select user-group-select"
		   				  id="lifeCyclePolicies"
		   				  search-property="lifeCyclePolicyName"
		   				  max-height="150px"
		   				  group-property="header"
		   				  helper-elements="filter"
		   				  translation="fgCreateController.localLangPolicy">
					</isteven-multi-select>
				</span>
				<div class="col-xs-12 col-sm-offset-5 col-sm-7">
					<span class="{{fgCreateController.lifeCycleValidation.type}} ">{{fgCreateController.lifeCycleValidation.message}}</span>
				</div>
			</div>
		</cv-plain-accordion>
		<cv-plain-accordion accordion-label="label.autofailoverOptions" collapsed="fgCreateController.collapseAutoFailoverOptions" data-ng-if="fgCreateController.showAutoFailoverOptions">
			<div class="form-group">
				<label for="autoFailoverSource" class="col-xs-12 col-sm-5">
					<cv:msg key="label.monitoringMachines" bundle="dr"/>
				</label>
				<span class="col-xs-12 col-sm-7">
					<isteven-multi-select
		   				  input-model="fgCreateController.autoFailoverMachines"
		   				  output-model="fgCreateController.autoFailoverSelectedMachines"
		  				  button-label="name"
						  item-label="name"
		   				  tick-property="selected"
		   				  selection-mode="multiple"
		   				  class="isteven-multi-select user-group-select"
		   				  id="autoFailoverSource"
		   				  name="autoFailoverSource"
		   				  search-property="fgCreateController.autoFailoverSource.name"
		   				  group-property="header"
		   				  helper-elements="filter"
		   				  on-close="fgCreateController.validateAutoFailoverMachineSelection()"
		   				  translation="fgCreateController.localLangMonitoringMachines">
					</isteven-multi-select>
				</span>
				<div class="col-xs-12 col-sm-offset-5 col-md-7">
					<div class="{{fgCreateController.autofailoverMachineValidation.type}} error">{{fgCreateController.autofailoverMachineValidation.message}}</div>
				</div>
			</div>
			<div class="form-group">
				<label for="autoFailoverDelay" class="col-xs-12 col-sm-5">
					<cv:msg key="label.autofailoverDelay" bundle="dr"/>
				</label>
				<span class="col-xs-12 col-sm-7">
					<input type="number" name="autoFailoverDelay" id="autoFailoverDelay" data-ng-model="fgCreateController.autoFailoverDelay" min="0" ng-init="fgCreateController.autoFailoverDelay=2">
				</span>
			</div>
		</cv-plain-accordion>
		<div class="button-container">
			<button id="failoverGroupCreate_button_#9339" type="button" class="btn btn-default" data-ng-click="fgCreateController.cancel()"> 
				<fmt:message key="Cancel"/>
			</button>
			<button id="failoverGroupCreate_button_#4312" type="submit" class="btn btn-primary cvBusyOnAjax"> 
				<cv:msg key="Save" bundle="messages"/>
			</button>
		</div>
	</form>
</div>