<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<span><cv:msg key="label.configure" bundle="dr"/> - <span data-ng-bind="configureMachinesCtrl.machine.clientName"/></span>
	</h1>
</div>
<div>
	<form class="bootstrap-wrapper" name="configureMachines" id="configureMachines" data-cv-submit="configureMachinesCtrl.submit()" autocomplete="off">
		<dr-ip ip="configureMachinesCtrl.machine.ip" ctrl="configureMachinesCtrl.ctrl"></dr-ip>

		<div class="form-group margin-top-20">
			<label class="col-xs-12 col-sm-5" for="destComputerName"><cv:msg key="label.destHostname" bundle="dr"/></label>
			<div class="col-xs-12 col-sm-7">
				<input type="text" data-ng-model="configureMachinesCtrl.machine.destComputerName" id="destComputerName" name="destComputerName" data-ng-pattern="/^((.){1,15})$/" autofocus novalidate />
				<span class="help-block" data-ng-show="configureMachines.destComputerName.$error.pattern">
					<cv:msg key="error.Hostname" bundle="restore"/>
				</span>
			</div>
		</div>
		
		<div class="button-container">
			<button id="configureMachinesCancel" type="button" class="btn btn-default" data-ng-click="configureMachinesCtrl.close()">
				<fmt:message key="Cancel"/>
			</button>
			<button id="configureMachinesSubmit" type="submit" class="btn btn-primary cvBusyOnAjax"> 
				<cv:msg key="Save" bundle="messages"/>
			</button>
		</div>
	</form>
</div>