<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
</script>
<dr-hypervisors filter-vendors="drArrayCtrl.supportedHypervisorVendors" ctrl="drArrayCtrl.ctrl" v-app="drArrayCtrl.vApp" type="hypervisors"></dr-hypervisors>
<div class="form-group" data-ng-if="::drArrayCtrl.showOperationTypeSource">
	<label class="col-xs-12 col-sm-5"><cv:msg key="label.operationType" bundle="dr"/></label>
	<div class="col-xs-12 col-sm-7">
		<div class="multiple-radio-group" data-ng-disabled="drArrayCtrl.editMode">
			<label><input name="radio" id="failoverOperation" data-ng-value="{{drArrayCtrl.FailoverEnum.VAppOperation.FAILOVER}}" type="radio" data-ng-model="drArrayCtrl.vApp.operationType" data-ng-change="drArrayCtrl.onFailoverChange('')"/>
			<span class="block-indent"><cv:msg key="label.failover" bundle="dr"/></span></label>
		</div>
		<div class="multiple-radio-group" data-ng-disabled="drArrayCtrl.editMode">
			<label><input name="radio" id="testFailoverOperation" data-ng-value="{{drArrayCtrl.FailoverEnum.VAppOperation.TESTFAILOVER}}" type="radio" data-ng-model="drArrayCtrl.vApp.operationType" data-ng-change="drArrayCtrl.onTestFailoverChange()"/>
			<span class="block-indent"><cv:msg key="label.testFailover" bundle="dr"/></span></label>
		</div>
	</div>
	<div class="col-xs-12 col-sm-offset-5 col-sm-7">
		<div class="help-block" data-ng-if="submitController.getAttempted() && drArrayCtrl.isTestFailoverGroup && drArrayCtrl.vApp.arrayReplication.server.length === 0">
			<i class="ion-alert-circled"></i>
			<cv:msg key="error.esxMandatory" bundle="dr"/>
		</div>
	</div>
</div>
<div class="form-group" data-ng-if="drArrayCtrl.showVMGroups">
	<label class="col-xs-12 col-sm-5" for="vmGroups"><cv:msg key="label.vmGroups" bundle="collectionsJs"/></label>
	<span class="col-xs-12 col-sm-7" data-ng-disabled="!drArrayCtrl.vApp.selectedEntities || drArrayCtrl.vApp.selectedEntities.length === 0">
		<isteven-multi-select
			input-model="drArrayCtrl.vmGroups"
			output-model="drArrayCtrl.vmGroupsSelected"
			button-label="subclientName"
			item-label="subclientName"
			tick-property="selected"
			selection-mode="single"
			class="isteven-multi-select"
			id="vmGroups"
			name="vmGroups"
			directive-id="vmGroups"
			search-property="subclientName"
			max-height="400px"
			on-item-click="drArrayCtrl.onVMGroupsSelect()"
			group-property="header"
			helper-elements="filter">
		</isteven-multi-select>
	</span>
	<div class="col-xs-12 col-sm-offset-5 col-sm-7">
		<div class="help-block" data-ng-if="submitController.getAttempted() && (drArrayCtrl.vmGroupsSelected.length === 0 || drArrayCtrl.vApp.selectedEntities.length === 0 )">
			<i class="ion-alert-circled"></i>
			<cv:msg key="error.noVMGroupsSelected" bundle="dr"/>
		</div>
		<div class="help-block" data-ng-if="drArrayCtrl.errors.fetchingVMGroups">
			<i class="ion-alert-circled"></i>
			<cv:msg key="error.fetchingVMGroups" bundle="dr"/>
		</div>
		<div class="help-block" data-ng-if="drArrayCtrl.errors.plan">
			<i class="ion-alert-circled"></i>
			<cv:msg key="error.planNotAssociated" bundle="dr"/>
		</div>
	</div>
</div>
<div class="form-group">
	<label class="col-xs-12 col-sm-5" for="copy"><cv:msg key="label.copy" bundle="dr"/></label>
	<span class="col-xs-12 col-sm-7" data-ng-disabled="drArrayCtrl.disableCopy()">
		<isteven-multi-select
			input-model="drArrayCtrl.copy"
			output-model="drArrayCtrl.copySelected"
			button-label="copyLabel"
			item-label="copyLabel"
			tick-property="selected"
			selection-mode="single"
			class="isteven-multi-select"
			id="copy"
			name="copy"
			directive-id="copy"
			search-property="copyLabel"
			max-height="400px"
			on-item-click="drArrayCtrl.onCopySelect()"
			group-property="header"
			helper-elements="filter">
		</isteven-multi-select>
	</span>
	<div class="col-xs-12 col-sm-offset-5 col-sm-7">
		<div class="help-block" data-ng-if="drArrayCtrl.errors.copyMsg">
			<i class="ion-alert-circled"></i>
			{{drArrayCtrl.errors.copyMsg}}
		</div>
		<div class="help-block" data-ng-if="submitController.getAttempted() && drArrayCtrl.copySelected.length === 0">
			<i class="ion-alert-circled"></i>
			<cv:msg key="error.noCopySelected" bundle="dr"/>
		</div>
	</div>
</div>
<div class="form-group" data-ng-if="::drArrayCtrl.showDestinationHyperV">
	<label class="col-xs-12 col-sm-5" for="destinationHyperV"><cv:msg key="label.destinationHypervisor" bundle="dr"/></label>
	<span class="col-xs-12 col-sm-7" data-ng-disabled="drArrayCtrl.editMode">
		<isteven-multi-select
			input-model="drArrayCtrl.destinationHyperV"
			output-model="drArrayCtrl.destinationHyperVSelected"
			button-label="name"
			item-label="name"
			tick-property="selected"
			selection-mode="single"
			class="isteven-multi-select"
			id="destinationHyperV"
			name="destinationHyperV"
			directive-id="destinationHyperV"
			search-property="name"
			max-height="400px"
			on-item-click="drArrayCtrl.onDestinationHyperVSelect()"
			group-property="header"
			helper-elements="filter">
		</isteven-multi-select>
	</span>
	<div class="col-xs-12 col-sm-offset-5 col-sm-7">
		<div class="help-block" data-ng-if="drArrayCtrl.errors.destHyperVMsgMsg">
			<i class="ion-alert-circled"></i>
			{{drArrayCtrl.errors.destHyperVMsg}}
		</div>
	</div>
</div>
<div data-ng-if="::drArrayCtrl.showRecoveryTargets">
	<dr-recovery-target ctrl="drArrayCtrl.ctrl" v-app="drArrayCtrl.vApp" filter-policy-types="drArrayCtrl.supportedPolicyTypes"></dr-recovery-target>
</div>
<div class="row margin-left-0 margin-right-0">
	<div class="col-xs-12 margin-bottom-30">
		<dr-machines ctrl="drArrayCtrl.ctrl" machines="drArrayCtrl.vApp.machines" data-ng-if="drArrayCtrl.isFailoverGroup"></dr-machines>
		<dr-machines ctrl="drArrayCtrl.ctrl" machines="drArrayCtrl.vApp.machines" data-ng-if="drArrayCtrl.isTestFailoverGroup"></dr-machines>
	</div>
</div>
<div data-ng-if="::drArrayCtrl.showESXServers">
	<cv-plain-accordion accordion-label="title.esxServerMapping" collapsed="drArrayCtrl.collapseESX">
		<dr-array-esx 
			v-app="drArrayCtrl.vApp" 
			servers="drArrayCtrl.vApp.arrayReplication.server" 
			source-client-id="drArrayCtrl.vApp.selectedEntities[0].clientId" 
			dest-client-id="drArrayCtrl.vApp.arrayReplication.destination.clientId" 
			ctrl="drArrayCtrl.ctrl"
			errors="drArrayCtrl.errors">
		</dr-array-esx>
	</cv-plain-accordion>
</div>