<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
</script>

<div class="setup-title">
	<h1><cv:msg key="title.esxBrowse" bundle="dr"/></h1>
</div>
<form class="bootstrap-wrapper" name="drESXModalForm" id="drESXModalForm" data-cv-submit="drArrayESXBrowseCtrl.save()">

	<div class="form-group">
		<div class="col-xs-12">
			<div class="help-block" data-ng-if="drArrayESXBrowseCtrl.errors.message">
				<i class="ion-alert-circled"></i>
				<span data-ng-bind="drArrayESXBrowseCtrl.errors.message"/>
			</div>
		</div>
	</div>

	<div class="form-group">
		<label class="col-xs-12 col-sm-5"><cv:msg key="label.source" bundle="dr"/></label>
		<div class="col-xs-12 col-sm-7">
			<isteven-multi-select
				input-model="drArrayESXBrowseCtrl.sourceServers"
		        output-model="drArrayESXBrowseCtrl.sourceServer"
		        id="drSourceServers"
		        name="drSourceServers"
		        tick-property="selected"
		        button-label="name"
		        class="isteven-multi-select"
		        item-label="name"
		        on-item-click="drArrayESXBrowseCtrl.onSourceServerSelect()"
		        selection-mode="single">
		    </isteven-multi-select>
		    <div class="help-block" data-ng-if="cv.drESXModalForm.getAttempted() && drArrayESXBrowseCtrl.sourceServer.length < 1">
				<i class="ion-alert-circled"></i>
				<cv:msg key="error.esxSelection.source" bundle="dr" />
			</div>
			<div class="help-block" data-ng-if="drArrayESXBrowseCtrl.errors.source">
				<i class="ion-alert-circled"></i>
				<span data-ng-bind="drArrayESXBrowseCtrl.errors.source" />
			</div>
		</div>
	</div>

	<cv-vmware-esxhost hypervisor-id="drArrayESXBrowseCtrl.destClientId" vm-options="drArrayESXBrowseCtrl.vmOptions" ctrl="drArrayESXBrowseCtrl.ctrl" mode="dr"></cv-vmware-esxhost>
	<div class="form-group">
		<div class="col-xs-12 col-sm-7 col-sm-offset-5">
			<div class="help-block" data-ng-if="cv.drESXModalForm.getAttempted() && !drArrayESXBrowseCtrl.vmOptions.esxHostName">
				<i class="ion-alert-circled"></i>
				<cv:msg key="error.esxSelection.destination" bundle="dr" />
			</div>
		</div>
	</div>

	<dr-network server="drArrayESXBrowseCtrl.rowValue"
		source-client-id="drArrayESXBrowseCtrl.sourceClientId"
		destination-client-id="drArrayESXBrowseCtrl.destClientId"
		ctrl="drArrayESXBrowseCtrl.ctrl">
	</dr-network>

	<div class="button-container">
		<button type="button" data-ng-click="drArrayESXBrowseCtrl.cancel()" class="btn btn-default cvBusyOnAjax">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button type="submit" class="btn btn-primary cvBusyOnAjax"
		 data-ng-disabled="drArrayESXBrowseCtrl.vmOptions.destinationHost.length === 0">
			<cv:msg key="Save" bundle="messages" />
		</button>
	</div>
</form>