<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
</script>
<div class="form-group">
	<label class="col-xs-6 margin-top-0">
		<span class="float-left">
			<cv:msg key="label.sourceDestination" bundle="dr"/>
		</span>
	</label>
	<label for="addESX" class="col-xs-6 margin-top-0">
		<span class="float-right" data-ng-disabled="!drArrayESXCtrl.enableAddButton()">
			<a href="" id="addESX" name="addESX" data-ng-click="drArrayESXCtrl.showESXModal()">
				<cv:msg key="label.add" bundle="dr" />
			</a>
		</span>
	</label>
	<label class="col-xs-12">
		<span class="help-block" data-ng-show="submitController.getAttempted() && drArrayESXCtrl.servers.length === 0">
			<cv:msg key="error.esxAdd" bundle="dr"/>
		</span>
		<span class="help-block" data-ng-show="drArrayESXCtrl.errors.message">
			<span data-ng-bind="drArrayESXCtrl.errors.message" />
		</span>
	</label>
</div>
<div id="esxServers">
	<div class="filters-list-wrapper">
		<ul data-ng-repeat="esx in drArrayESXCtrl.servers | orderBy track by $index">
			<li title="{{esx.sourceServer}} - {{esx.destinationServer}}">
				<a href class="padding-left-0" id="editESXMapping" name="editESXMapping" data-ng-click="drArrayESXCtrl.showESXModal(esx)">
					{{esx.sourceServer}} - {{esx.destinationServer}}
				</a>
				<span class="delete-row">
					<a data-ng-click="drArrayESXCtrl.deleteESXRow(esx)"
					title="<cv:msg key='label.remove' bundle='dr'/> {{esx.sourceServer}} - {{esx.destinationServer}}">&times;</a>
				</span>
			</li>
		</ul>
	</div>
</div>