<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div data-ng-app="drApp.failover">
	<div class="setup-title">
		<h1><cv:msg key="label.editDetails" bundle="dr"/></h1>
	</div>
	<div class="bootstrap-wrapper">
		<div class="modal-body">
			<div class="form-horizontal">
				<form ng-submit="basicDetailsController.save()">
					<div class="form-group">
						<div class="col-md-5">
							<label for="vAppName" class="cv-label"><cv:msg key="label.groupName" bundle="dr"/></label>
						</div>
						<div class="col-md-7">
							<input type="text" id="vAppName" data-ng-model="basicDetailsController.vAppName" ng-required autofocus>
						</div>
						<div class="col-md-offset-5 col-md-7">
							<div class="{{basicDetailsController.nameValidation.type}} error">{{basicDetailsController.nameValidation.message}}</div>
						</div>
					</div>
					<div class="form-group" data-ng-if="basicDetailsController.vApp.isFailoverGroup">
						<div class="col-md-12">
							<input type="checkbox" id="approvalRequired" data-ng-model="basicDetailsController.approvalRequired">
							<label for="approvalRequired"><cv:msg key="label.approvalToRunTasks" bundle="dr"/></label>
							<cv-help-component data-ng-show="basicDetailsController.approvalRequired" data-help-text="<cv:msg key="msg.approvalOperations" bundle="dr" />"></cv-help-component>
						</div>
					</div>

					<div class="form-group" data-ng-if="basicDetailsController.vApp.isFailoverGroup">
						<div class="col-md-5">
							<label for="userToApproveOrNotify" class="cv-label"><cv:msg key="label.userToApproveOrNotifyShort" bundle="dr"/></label>
						</div>
						<div class="col-md-7">
							<isteven-multi-select id="basicDetailsDialog_isteven-multi-select_#9018"
				   				  input-model="basicDetailsController.users"
				   				  output-model="basicDetailsController.usersSelected"
				  				  button-label="fullName"
								  item-label="fullName"
				   				  tick-property="selected"
				   				  selection-mode="single"
				   				  class="isteven-multi-select user-group-select"
				   				  search-property="basicDetailsController.fullName"
				   				  max-height="150px"
				   				  group-property="header"
				   				  helper-elements="filter">
							</isteven-multi-select>
						</div>
						<div class="col-md-offset-5 col-md-7">
							<span class="{{basicDetailsController.approvalValidation.type}} ">{{basicDetailsController.approvalValidation.message}}</span>
						</div>
					</div>
					<div class="form-group">
						<div class="col-md-5 col-sm-5">
							<label for="delay" class="cv-label"><cv:msg key="label.priorityIntervalInMins" bundle="dr"/></label>
						</div>
						<div class="col-md-7 col-sm-7">
							<input type="number" id="delay" data-ng-model="basicDetailsController.delay" ng-required min="0">
						</div>
					</div>
					<div class="form-group">
						<div class="col-md-12">
							<input type="checkbox" id="continueOnFailure" data-ng-model="basicDetailsController.continueOnFailure">
							<label for="continueOnFailure"><cv:msg key="label.continueOnFailure" bundle="dr"/></label>
						</div>
					</div>
					<div data-ng-if="basicDetailsController.destVendor === 'VMW'">
						<cv-vsa-replication-target
							selected-target="basicDetailsController.selectedTarget"
							dest-vendor="basicDetailsController.destVendor"
							target-id-to-tick="basicDetailsController.targetIdToTick"
							is-edit="true"
							app-type="basicDetailsController.policyAppType">
						</cv-vsa-replication-target>
					</div>
					<div class="form-group" data-ng-if="basicDetailsController.vApp.isDevtestGroup">
						<label for="lifeCyclePolicy" class="col-md-5"><cv:msg key="label.lifeCyclePolicy" bundle="dr"/></label>
						<span class="col-md-7">
							<isteven-multi-select
				   				  input-model="basicDetailsController.lifeCyclePolicies"
				   				  output-model="basicDetailsController.lifeCyclePolicySelected"
				  				  button-label="lifeCyclePolicyName"
								  item-label="lifeCyclePolicyName"
				   				  tick-property="selected"
				   				  selection-mode="single"
				   				  class="isteven-multi-select user-group-select"
				   				  id="lifeCyclePolicies"
				   				  search-property="lifeCyclePolicyName"
				   				  max-height="150px"
				   				  group-property="header"
				   				  helper-elements="filter"
				   				  translation="basicDetailsController.localLangPolicy">
							</isteven-multi-select>
						</span>
						<div class="col-md-offset-3 col-md-7">
							<span class="{{basicDetailsController.lifeCycleValidation.type}} ">{{basicDetailsController.lifeCycleValidation.message}}</span>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
	<div class="setup-content">
		<div class="button-container">
			<button id="basicDetailsDialog_button_#7912" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="basicDetailsController.closeModal()"><cv:msg key="Cancel" bundle="messages"/></button>
			<button id="basicDetailsDialog_button_#4772" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="basicDetailsController.save()"><cv:msg key="Save" bundle="messages"/></button>
		</div>
	</div>
</div>