<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
</script>
<div data-ng-app="drApp.failover">
	<div class="setup-title">
		<h1><cv:msg key="label.addMonitoringMachines" bundle="dr"/></h1>
	</div>
	<div class="bootstrap-wrapper">
		<div class="modal-body">
			<div class="form-horizontal">
				<form ng-submit="autofailoverController.save()">
					<div class="form-group">
						<div class="col-md-5">
							<label for="monitoringMachines" class="cv-label"><cv:msg key="label.monitoringMachines" bundle="dr"/></label>
						</div>
						<div class="col-md-7">
							<isteven-multi-select
				   				  input-model="autofailoverController.autoFailoverMachines"
				   				  output-model="autofailoverController.autoFailoverSelectedMachines"
				  				  button-label="name"
								  item-label="name"
				   				  tick-property="selected"
				   				  selection-mode="multiple"
				   				  class="isteven-multi-select user-group-select"
				   				  id="autoFailoverSource"
				   				  name="autoFailoverSource"
				   				  search-property="autofailoverController.autoFailoverSource.name"
				   				  group-property="header"
				   				  helper-elements="filter"
				   				  on-close="autofailoverController.validateAutoFailoverMachineSelection()"
				   				  translation="autofailoverController.localLangMonitoringMachines">
							</isteven-multi-select>
						</div>
						<div class="col-md-offset-5 col-md-7">
							<div class="{{autofailoverController.autofailoverMachineValidation.type}} error">{{autofailoverController.autofailoverMachineValidation.message}}</div>
						</div>
					</div>
					<div class="form-group">
						<label for="autoFailoverDelay" class="col-md-5"><cv:msg key="label.autofailoverDelay" bundle="dr"/></label>
						<span class="col-md-4">
							<input type="number" name="autoFailoverDelay" id="autoFailoverDelay" data-ng-model="autofailoverController.autoFailoverDelay" min="0" ng-init="autofailoverController.autoFailoverDelay=2">
						</span>
					</div>
				</form>
			</div>
		</div>
	</div>
	<div class="setup-content">
		<div class="button-container">
			<button id="autoFailover_button_#3569" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="autofailoverController.closeModal()"><cv:msg key="Cancel" bundle="messages"/></button> 
			<button id="autoFailover_button_#0130" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="autofailoverController.save()"><cv:msg key="Save" bundle="messages"/></button> 
		</div>
	</div>
</div>