<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div data-ng-app="drApp.failover">
	<div class="setup-title">
		<h1><cv:msg key="label.addVirtualMachines" bundle="dr"/></h1>
	</div>
	<div class="setup-content">
		<form data-ng-submit="addMachinesController.save()" class="edit-users-grid-form">
			<label data-ng-if="addMachinesController.machinesList.length == 0"><cv:msg key="msg.allFailoverEligibleMachinesSelected" bundle="dr"/></label>
			<div class="margin-left-right" data-ng-if="addMachinesController.machinesList.length > 0">
				<cv-grid cv-grid-options="addMachinesController.gridOptions"></cv-grid>
			</div>
			<div>
				<span class="{{addMachinesController.machineValidation.type}}">	{{addMachinesController.machineValidation.message}}</span>
			</div>
		</form>
		<div class="button-container">
			<button id="addMachinesDialog_button_#7760" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="addMachinesController.closeModal()"><cv:msg key="Cancel" bundle="messages"/></button> 
			<button id="addMachinesDialog_button_#3230" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="addMachinesController.save()" data-ng-if="addMachinesController.machinesList.length > 0"><cv:msg key="Save" bundle="messages"/></button> 
		</div>
	</div>
</div>