import 'modules/disasterRecovery/js/dr.constants.js';
import 'modules/disasterRecovery/js/services/failoverGroup/failoverGroup.svc.js';

import { drAppFailoverModule } from 'common/js/modules';

/**
 * Factory that handles virtual lab related services for DR Groups
 */

var failoverMod = drAppFailoverModule;
failoverMod.factory('drVirtualLabFactory', [
	'$uibModal',
	'cvToaster',
	'failoverService',
	'FailoverConstants',
	function drVirtualLabFactory($uibModal, cvToaster, failoverService, FailoverConstants) {
		var factory = {
			// public functions
			createVirtualLab: createVirtualLab,
			getVirtualLabs: getVirtualLabs,
			isCreateVirtualLabAllowedOnMachine: isCreateVirtualLabAllowedOnMachine,

			// public variables
			labs: []
		};

		// private variables
		var toasterTTL = 10000;
		var virtualLabSupportedVendors = [
			FailoverConstants.Vendors['VMW'],
			FailoverConstants.Vendors['AZURE'],
			FailoverConstants.Vendors['AZURE_STACK'],
			FailoverConstants.Vendors['MICROSOFT']
		];

		return factory;

		function createVirtualLab(vApp) {
			$uibModal.open({
				windowClass: 'small-size',
				templateUrl: appUtil.appRoot + 'vsa/partials/modal.jsp',
				backdrop: 'static',
				controller: [
					'$scope',
					'$uibModalInstance',
					'cvLoc',
					'failoverService',
					function($scope, $modalInstance, cvLoc, failoverService) {
						$scope.modalOptions = {
							headerText: cvLoc('label.testFailover'),
							bodyText: cvLoc('label.confirmTestFailover'),
							closeButtonText: cvLoc('button.no'),
							actionButtonText: cvLoc('button.yes'),
							ok: function() {
								var vAppId = vApp.vAppEntity.vAppId;
								var vAppName = vApp.vAppEntity.vAppName;
								var vendor =
									(vApp.machinesList && vApp.machinesList.length > 0 && vApp.machinesList[0].vendor) || vApp.vendor;
								failoverService
									.createVirtualLab(vAppId, vAppName, vendor)
									.success(function(data) {
										if (data && data.jobIds && data.jobIds.length > 0) {
											var jobID = data.jobIds[0];
											var jobURL = '#/jobs/' + jobID;
											var responseContent =
												' <a href="' + jobURL + '">' + cvLoc('msg.jobDetails') + ' ' + jobID + '</a>';
											showSuccessMessage(responseContent);
										} else {
											showErrorMessage();
										}
									})
									.error(function(e) {
										showErrorMessage(e);
									});
								$modalInstance.dismiss();
							},
							close: function() {
								$modalInstance.dismiss();
							}
						};
					}
				]
			});
		}

		function getVirtualLabs(vmAllocPolicyId) {
			return failoverService
				.getVirtualLabs(vmAllocPolicyId)
				.success(function(data) {
					if (data && data.labMachine) {
						factory.labs = data.labMachine;
					}
				})
				.error(function(e) {
					showErrorMessage(e);
				});
		}

		function isCreateVirtualLabAllowedOnMachine(machine) {
			return (
				machine &&
				machine.vendor &&
				virtualLabSupportedVendors.indexOf(machine.vendor) >= 0 &&
				machine.destVendor &&
				virtualLabSupportedVendors.indexOf(machine.destVendor) >= 0
			);
		}

		/**
		 * Shows the cvToaster success message
		 */
		function showSuccessMessage(content) {
			cvToaster.showSuccessMessage({
				ttl: toasterTTL,
				message: content
			});
		}

		/**
		 * Shows the cvToaster error message
		 */
		function showErrorMessage(content) {
			cvToaster.showErrorMessage({
				ttl: toasterTTL,
				message: content ? content : cvLoc('generic_error')
			});
		}
	}
]);

export default failoverMod;
