import 'modules/disasterRecovery/js/dr.constants.js';

import { drAppFailoverModule } from 'common/js/modules';

/**
 * Opens up the pre and post script pages
 */

var failoverMod = drAppFailoverModule;

failoverMod.factory('drScriptFactory', [
	'$uibModal',
	'FailoverConstants',
	'FailoverEnum',
	function($uibModal, FailoverConstants, FailoverEnum) {
		var factory = {
			isPostScript: isPostScript,
			isPostScriptSupported: isPostScriptSupported,
			isAppValidationScript: isAppValidationScript,
			isPreScript: isPreScript,
			isPreScriptSupported: isPreScriptSupported,
			openPostScriptDialog: openPostScriptDialog,
			openPreScriptDialog: openPreScriptDialog,
			openAppValidationScriptDialog: openAppValidationScriptDialog
		};

		var preScriptSupportedVendors = [FailoverConstants.Vendors.VMW, FailoverConstants.Vendors.AZURE_V2];
		var postScriptSupportedVendors = [FailoverConstants.Vendors.VMW, FailoverConstants.Vendors.AZURE_V2];

		return factory;

		function openPreScriptDialog(machine, vApp, openedFromDetailsPage) {
			openDRScriptDialog(machine, vApp, FailoverEnum.ScriptType['PRE'], openedFromDetailsPage);
		}

		function openPostScriptDialog(machine, vApp, openedFromDetailsPage) {
			openDRScriptDialog(machine, vApp, FailoverEnum.ScriptType['POST'], openedFromDetailsPage);
		}

		function openAppValidationScriptDialog(machine, vApp, openedFromDetailsPage) {
			openDRScriptDialog(machine, vApp, FailoverEnum.ScriptType['APPLICATION_VALIDATION'], openedFromDetailsPage);
		}

		function openDRScriptDialog(machine, vApp, scriptType, openedFromDetailsPage) {
			$uibModal.open({
				templateUrl: appUtil.appRoot + 'modules/disasterRecovery/partials/drScriptDialog.jsp',
				backdrop: 'static',
				controller: [
					'$uibModalInstance',
					'machine',
					function($uibModalInstance, machine) {
						factory.machine = machine;
						factory.vApp = vApp;
						factory.scriptType = scriptType;
						factory.openedFromDetailsPage = openedFromDetailsPage;

						factory.closeModal = function() {
							$uibModalInstance.close();
						};
					}
				],
				resolve: {
					machine: function() {
						return machine;
					}
				}
			});
		}

		function isPreScript(scriptType) {
			return scriptType === FailoverEnum.ScriptType['PRE'];
		}

		function isPostScript(scriptType) {
			return scriptType === FailoverEnum.ScriptType['POST'];
		}

		function isAppValidationScript(scriptType) {
			return scriptType === FailoverEnum.ScriptType['APPLICATION_VALIDATION'];
		}

		function isPreScriptSupported(srcVendor, destVendor) {
			return (
				(srcVendor && preScriptSupportedVendors.indexOf(srcVendor) >= 0) ||
				(destVendor && preScriptSupportedVendors.indexOf(destVendor) >= 0)
			);
		}

		function isPostScriptSupported(srcVendor, destVendor) {
			return (
				(srcVendor && postScriptSupportedVendors.indexOf(srcVendor) >= 0) ||
				(destVendor && postScriptSupportedVendors.indexOf(destVendor) >= 0)
			);
		}
	}
]);

export default failoverMod;
