import 'modules/schedule/js/factory/schedule.factory.js';
import 'modules/disasterRecovery/js/services/failoverGroup/failoverGroup.svc.js';
import 'modules/disasterRecovery/js/dr.constants.js';

import { drAppFailoverModule } from 'common/js/modules';

/**
 * Factory functions for handling Schedules in DR Group
 */

var failoverMod = drAppFailoverModule;

failoverMod.factory('drScheduleFactory', [
	'cvToaster',
	'cvLoc',
	'scheduleUIFactory',
	'failoverService',
	'FailoverConstants',
	function drScheduleFactory(cvToaster, cvLoc, scheduleUIFactory, failoverService, FailoverConstants) {
		// public functions
		drScheduleFactory.addSchedule = addSchedule;
		drScheduleFactory.editSchedule = editSchedule;
		drScheduleFactory.createSchedule = createSchedule;
		drScheduleFactory.getPlannedFailoverSchedules = getPlannedFailoverSchedules;
		drScheduleFactory.getTestbootSchedules = getTestbootSchedules;
		drScheduleFactory.getSchedules = getSchedules;
		drScheduleFactory.modifySchedule = modifySchedule;
		drScheduleFactory.deleteSchedule = deleteSchedule;

		// private variables
		var toasterTTL = 10000;

		return drScheduleFactory;

		/*
		 * Opens up the modal for adding a schedule
		 */
		function addSchedule(vAppId, operation) {
			var attrs = {
				hideBackupLevelOptions: true,
				operationType: 'VIRTUAL_MACHINE_MANAGEMENT',
				subTaskType: 'ADMIN',
				vmOperationType: operation,
				hideTimeInCommServeTimezone: true
			};
			scheduleUIFactory.addSchedule(
				{
					source: 'dr'
				},
				false,
				undefined,
				false,
				undefined,
				undefined,
				attrs
			);
		}

		/*
		 * Opens up the modal for editing a schedule
		 */
		function editSchedule(schedule, operation) {
			var attrs = {
				hideBackupLevelOptions: true,
				operationType: 'VIRTUAL_MACHINE_MANAGEMENT',
				subTaskType: 'ADMIN',
				vmOperationType: operation,
				hideTimeInCommServeTimezone: true
			};
			scheduleUIFactory.addSchedule(
				{
					source: 'failovergroup',
					model: schedule
				},
				true,
				undefined,
				false,
				undefined,
				undefined,
				attrs
			);
		}

		/*
		 * Sends the request to create a schedule
		 */
		function createSchedule(schedule) {
			return failoverService.createSchedule(schedule);
		}

		function getPlannedFailoverSchedules(vAppId) {
			return drScheduleFactory.getSchedules(FailoverConstants.DROrchestrationType['PLANNED_FAILOVER'], vAppId);
		}

		function getTestbootSchedules(vAppId) {
			return drScheduleFactory.getSchedules(FailoverConstants.DROrchestrationType['TESTBOOT'], vAppId);
		}

		/*
		 * Fetches the list of all the Schedules for the given dr orchestration type
		 */
		function getSchedules(drOrchestrationType, vAppId) {
			return failoverService
				.getSchedules(drOrchestrationType, vAppId)
				.success(function(data) {
					drScheduleFactory.schedules = [];
					if (data && data.length > 0) {
						var index = 0;
						data.forEach(function(task) {
							task.subTasks.forEach(function(subTask) {
								var schedule = scheduleUIFactory.convertSubTaskInfoToSchedule(subTask, null, index++);
								if (angular.isDefined(task.task) && angular.isDefined(task.task.task)) {
									schedule.taskId = task.task.task.taskId;
								}
								drScheduleFactory.schedules.push(schedule);
							});
						});
					}
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: toasterTTL,
						message: e ? e : cvLoc('generic_error')
					});
				});
		}

		/*
		 * Sends the request to modify an existing schedule
		 */
		function modifySchedule(taskId, schedule) {
			return failoverService.modifySchedule(taskId, schedule);
		}

		/*
		 * Sends the request to delete a schedule
		 */
		function deleteSchedule(taskId) {
			return failoverService.deleteSchedule(taskId);
		}
	}
]);

export default failoverMod;
