import { drAppFailoverModule } from 'common/js/modules';

/**
 * A factory used for common DR machine operations
 */

export const drMachinesFactory = drAppFailoverModule.factory('drMachinesFactory', [
	'cvLoc',
	'cvUtil',
	'$log',
	function(cvLoc, cvUtil, $log) {
		var factory = {};

		/*
		 * Selects all the machines spanning across the pages
		 */
		factory.selectAllMachines = function(grid) {
			let originalPageSize = expandGrid(grid);
			grid.select('tr');
			setPageSize(grid, originalPageSize);
		};

		/*
		 * Clears the machine selection spanning across the pages
		 */
		factory.clearGridSelection = function(grid) {
			let originalPageSize = expandGrid(grid);
			grid.clearSelection();
			setPageSize(grid, originalPageSize);
		};

		/*
		 * Changes the page size to the length of the data and returns the original page size
		 */
		function expandGrid(grid) {
			let originalPageSize = grid.dataSource.pageSize();
			let newPageSize = grid.dataSource.data().length;
			setPageSize(grid, newPageSize);
			return originalPageSize;
		}

		function setPageSize(grid, pageSize) {
			grid.dataSource.pageSize(pageSize);
		}

		return factory;
	}
]);

export default drMachinesFactory;
