/**
 *
 */
(function() {
	'use strict';

	var devtestMod = angular.module('drApp.devtest', []);

	devtestMod.factory('devtestFactory', [
		'cvToaster',
		'$state',
		'$stateParams',
		'$uibModal',
		'$dialogs',
		'cvLoc',
		'clientGroupFactory',
		'clientGroupsFactory',
		'serverService',
		'scheduleUIFactory',
		'restoreService',
		'devtestService',
		function devtestFactory(
			cvToaster,
			$state,
			$stateParams,
			$uibModal,
			$dialogs,
			cvLoc,
			clientGroupFactory,
			clientGroupsFactory,
			serverService,
			scheduleUIFactory,
			restoreService,
			devtestService
		) {
			devtestFactory.devtestGroups;
			devtestFactory.devtestGroupDetails;
			devtestFactory.devtestEligibleMachines;

			devtestFactory.getDevtestGroups = function() {
				return devtestService
					.getDevtestGroups()
					.success(function(data) {
						for (var i = 0; i < data.length; i++) {
							var count = 0;
							if (data[i].clientList) {
								count = data[i].clientList.length;
							}
							data[i].machinesCount = count;
						}
						devtestFactory.devtestGroups = data;
					})
					.error(function(e) {
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: e ? e : cvLoc('generic_error')
						});
					});
			};

			devtestFactory.getDevtestGroupDetails = function(vAppId) {
				return devtestService
					.getDevtestGroupDetails(vAppId)
					.success(function(data) {
						if (data && data.length >= 0) {
							devtestFactory.devtestGroupDetails = data[0];
						}
					})
					.error(function(e) {
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: e ? e : cvLoc('generic_error')
						});
					});
			};

			devtestFactory.getMachinesList = function(entityID, entityType, vAppSource) {
				return devtestService
					.getMachinesList(entityID, entityType, vAppSource)
					.success(function(data) {
						devtestFactory.devtestEligibleMachines = data;
					})
					.error(function(e) {
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: e ? e : cvLoc('generic_error')
						});
					});
			};

			/**
			 * Fetches the list of all the clients
			 */
			devtestFactory.getClients = function() {
				return clientGroupFactory.getClients(0, false).then(function() {
					if (clientGroupFactory.clients) {
						devtestFactory.clients = [];
						clientGroupFactory.clients.forEach(function(item, index) {
							var client = item;
							client.id = item.client.clientEntity.clientId;
							client.name = item.client.clientEntity.clientName;
							client.type = 'client';

							devtestFactory.clients.push(client);
						});
						devtestFactory.clients.sort(devtestFactory.comparename);
					}
				});
			};

			/**
			 * Fetches the list of all the clients groups
			 */
			devtestFactory.getClientGroups = function() {
				return clientGroupsFactory.getClientGroups().then(function() {
					if (clientGroupsFactory.clientGroups) {
						devtestFactory.clientGroups = [];
						clientGroupsFactory.clientGroups.forEach(function(item, index) {
							var clientGroup = item;
							clientGroup.id = item.Id;
							clientGroup.name = item.name;
							clientGroup.type = 'clientGroup';

							devtestFactory.clientGroups.push(clientGroup);
						});
						devtestFactory.clientGroups.sort(devtestFactory.comparename);
					}
				});
			};

			/**
			 * Fetches the list of all the hypervisors
			 */
			devtestFactory.getHyperVisors = function() {
				return serverService
					.getServers()
					.success(function(data) {
						if (data) {
							devtestFactory.hypervisors = [];
							data.forEach(function(item, index) {
								var hypervisor = item;
								hypervisor.id = item.clientId;
								hypervisor.name = item.name;
								hypervisor.type = 'client';

								devtestFactory.hypervisors.push(hypervisor);
							});
							devtestFactory.hypervisors.sort(devtestFactory.comparename);
						}
					})
					.error(function(e) {
						devtestFactory.hypervisors = {};
					});
			};

			devtestFactory.comparename = function(a, b) {
				return a.name.toLowerCase().localeCompare(b.name.toLowerCase());
			};

			devtestFactory.getReplicationTargets = function() {
				return restoreService.getReplicationTargets(false).then(function(data) {
					devtestFactory.replicationTargets = [];
					if (data && data.data) {
						devtestFactory.replicationTargets = data.data;
					}

					devtestFactory.replicationTargets.forEach(function(target) {
						target.name = target.entity.vmAllocPolicyName;
						target.id = target.entity.vmAllocPolicyId;
					});
				});
			};

			devtestFactory.deleteGroup = function(vAppId) {
				var callBackFunctions = {
					noFunction: function() {},
					yesFunction: function() {
						devtestService
							.deleteDevtestGroup(JSON.stringify(vAppId))
							.success(function(data) {
								$state.transitionTo('devtest', $stateParams, {
									reload: true,
									inherit: false,
									notify: true
								});
								cvToaster.showSuccessMessage({
									ttl: '10000',
									message: cvLoc('msg.devtestGroupDeleted')
								});
							})
							.error(function(e) {
								cvToaster.showErrorMessage({
									ttl: '10000',
									message: e ? e : cvLoc('generic_error')
								});
							});
					}
				};

				$dialogs.confirm(cvLoc('label.deleteGroup'), cvLoc('label.deleteGroupConfirmation'), callBackFunctions);
			};

			devtestFactory.updateDevtestGroup = function(updatedvApp) {
				return devtestService
					.updateDevtestGroup({
						virtualApp: JSON.stringify(updatedvApp)
					})
					.success(function(data) {
						devtestFactory.devtestGroupDetails = updatedvApp;
						cvToaster.showSuccessMessage({
							ttl: '10000',
							message: cvLoc('msg.updateSuccessful')
						});
						$state.reload();
					})
					.error(function(e) {
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: e ? e : cvLoc('generic_error')
						});
					});
			};

			devtestFactory.modifyBasicDetails = function(vApp) {
				$uibModal.open({
					templateUrl: appUtil.appRoot + 'modules/disasterRecovery/partials/basicDetailsDialog.jsp',
					backdrop: 'static',
					controller: [
						'$uibModalInstance',
						'vApp',
						function($uibModalInstance, vApp) {
							devtestFactory.vApp = vApp;
							devtestFactory.closeModal = function() {
								$uibModalInstance.close();
							};
						}
					],
					resolve: {
						vApp: function() {
							return vApp;
						}
					}
				});
			};

			devtestFactory.modifyMachineDetails = function(machine, vApp) {
				$uibModal.open({
					templateUrl: appUtil.appRoot + 'modules/disasterRecovery/partials/machineDetailsDialog.jsp',
					backdrop: 'static',
					controller: [
						'$uibModalInstance',
						'machine',
						function($uibModalInstance, machine) {
							devtestFactory.vApp = vApp;
							devtestFactory.machine = machine;

							devtestFactory.closeModal = function() {
								$uibModalInstance.close();
							};
						}
					],
					resolve: {
						machine: function() {
							return machine;
						}
					}
				});
			};

			/*
			 * Opens up the modal for adding a schedule
			 */
			devtestFactory.addSchedule = function(vAppId) {
				var attrs = {
					hideBackupLevelOptions: true,
					operationType: 'VIRTUAL_MACHINE_MANAGEMENT',
					subTaskType: 'ADMIN'
				};
				scheduleUIFactory.addSchedule(
					{
						source: 'dr'
					},
					false,
					undefined,
					false,
					undefined,
					undefined,
					attrs
				);
			};

			/*
			 * Opens up the modal for editing a schedule
			 */
			devtestFactory.editSchedule = function(schedule) {
				var attrs = {
					hideBackupLevelOptions: true,
					operationType: 'VIRTUAL_MACHINE_MANAGEMENT',
					subTaskType: 'ADMIN'
				};
				scheduleUIFactory.addSchedule(
					{
						source: 'failovergroup',
						model: schedule
					},
					true,
					undefined,
					false,
					undefined,
					undefined,
					attrs
				);
			};

			/*
			 *	Sends the request to create a schedule
			 */
			devtestFactory.createSchedule = function(schedule) {
				return devtestService.createSchedule(schedule);
			};

			/*
			 *	Sends the request to modify an existing schedule
			 */
			devtestFactory.modifySchedule = function(taskId, schedule) {
				return devtestService.modifySchedule(taskId, schedule);
			};

			/*
			 *	Sends the request to delete a schedule
			 */
			devtestFactory.deleteSchedule = function(taskId) {
				return devtestService.deleteSchedule(taskId);
			};

			return devtestFactory;
		}
	]);
})();
