import 'modules/disasterRecovery/js/factory/dr.factory.js';

import { drAppFailoverModule } from 'common/js/modules';

const TEMPLATE = `
<div class="form-group">
	<label for="recoveryTarget" class="col-xs-12 col-sm-5">{{'label.lifeCyclePolicy' | cvLoc}}</label>
	<span class="col-xs-12 col-sm-7">
		<isteven-multi-select
			input-model="drTargetCtrl.recoveryTargets"
			output-model="drTargetCtrl.recoveryTargetSelected"
			button-label="lifeCyclePolicyName"
			item-label="lifeCyclePolicyName"
			tick-property="selected"
			selection-mode="single"
			class="isteven-multi-select user-group-select"
			id="lifeCyclePolicies"
		  	directive-id="lifeCyclePolicies"
		  	search-property="lifeCyclePolicyName"
		  	max-height="150px"
		  	on-item-click="drTargetCtrl.onTargetSelect()"
		  	group-property="header"
		  	helper-elements="filter">
		</isteven-multi-select>
		<div class="help-block" data-ng-if="submitController.getAttempted() && !drTargetCtrl.isValid(drTargetCtrl.recoveryTargetSelected[0])">
			<i class="ion-alert-circled"></i>
			{{'error.selectLifeCyclePolicy' | cvLoc}}
		</div>
	</span>
</div>
`;

class DRRecoveryTarget {
	constructor() {
		this.restrict = 'E';
		this.template = TEMPLATE;
		this.scope = {
			ctrl: '=',
			vApp: '=',
			filterPolicyTypes: '=?'
		};
		this.require = ['^^cvSubmit', '^^form', '^?drArrayReplication'];
		this.controllerAs = 'drTargetCtrl';
		this.controller = DRRecoveryTargetController;
		this.bindToController = true;
	}

	link($scope, elem, attrs, ctrl) {
		$scope.submitController = ctrl[0];
		$scope.formController = ctrl[1];

		$scope.drTargetCtrl.onTargetSelect = function() {
			$scope.drTargetCtrl.onSelect();
			ctrl[2] && ctrl[2].onTargetSelect($scope.drTargetCtrl.recoveryTargetSelected[0]);
		};
	}
}

class DRRecoveryTargetController {
	constructor(cvLoc, drOrchestrationFactory) {
		this.cvLoc = cvLoc;
		this.drOrchestrationFactory = drOrchestrationFactory;
	}

	onSelect() {
		this.vApp.policy = {
			entity: this.recoveryTargetSelected[0].entity,
			destinationHyperV: this.recoveryTargetSelected[0].destinationHyperV
		};
		if (this.drOrchestrationFactory.isVirtualLabTarget(this.recoveryTargetSelected[0])) {
			this.vApp.isVirtualLab = true;
			this.vApp.config.vmPolicy = this.recoveryTargetSelected[0].entity;
		}
	}

	isValid(policy) {
		return !!policy;
	}

	$onInit() {
		const self = this;
		this.ctrl = this.ctrl || {};
		this.ctrl.isRecoveryTargetValid = this.isValid;
		this._getRecoveryTargets()
			.then(function() {
				if (self.recoveryTargets.length) {
					self._setDefaultTarget();
					self.onTargetSelect();
				} else {
					self.recoveryTargets = [];
				}
			})
			.catch(function() {
				self.recoveryTargets = [];
			});
	}

	_getRecoveryTargets() {
		const self = this;
		self.recoveryTargets = [this._loadingISteven('lifeCyclePolicyName')];
		return this.drOrchestrationFactory.getLifeCyclePolicies().then(function() {
			self.recoveryTargets = self.drOrchestrationFactory.lifeCyclePolicies || [];
			if (_.get(self, 'filterPolicyTypes', false)) {
				self.recoveryTargets = self.recoveryTargets.filter(policy => {
					return self.filterPolicyTypes.indexOf(policy.entity.policyType) >= 0;
				});
			}
		});
	}

	_setDefaultTarget() {
		let indexToSelect = 0;
		let vmAllocPolicyId = _.get(this, 'vApp.policy.entity.vmAllocPolicyId');
		if (vmAllocPolicyId) {
			indexToSelect = this.recoveryTargets.findIndex(
				recoveryTarget => recoveryTarget.entity.vmAllocPolicyId === vmAllocPolicyId
			);
			indexToSelect = Math.max(indexToSelect, 0);
		}
		this.recoveryTargets[indexToSelect].selected = true;
		this.recoveryTargetSelected[0] = this.recoveryTargets[indexToSelect];
	}

	_loadingISteven(name) {
		let loading = {
			id: 0,
			selected: true,
			disableSelection: true // disable from using this as a value to save
		};
		loading[name] = this.cvLoc('Loading');

		return loading;
	}
}

DRRecoveryTargetController.$inject = ['cvLoc', 'drOrchestrationFactory'];
drAppFailoverModule.directive('drRecoveryTarget', () => new DRRecoveryTarget());

export default drAppFailoverModule;
