import 'vsa/js/directives/cv-vmware-ipaddress-settings-directive.js';
import 'vsa/js/factories/replication.factory.js';

import { drAppFailoverModule } from 'common/js/modules';

class DRIP {
	constructor() {
		this.restrict = 'E';
		this.templateUrl = appUtil.appRoot + 'modules/disasterRecovery/partials/drIP.jsp';
		this.scope = {
			ip: '=',
			ctrl: '='
		};
		this.require = ['^^cvSubmit', '^^form'];
		this.controllerAs = 'drIPCtrl';
		this.controller = DRIPController;
		this.bindToController = true;
	}

	link($scope, elem, attrs, ctrl) {
		$scope.submitController = ctrl[0];
		$scope.formController = ctrl[1];
	}
}

class DRIPController {
	constructor(cvLoc, replicationFactory) {
		this.cvLoc = cvLoc;
		this.replicationFactory = replicationFactory;
	}

	$onInit() {
		this.ctrl = this.ctrl || {};
		this.ctrl.onSubmitIP = this._onSubmit.bind(this);
		this.vmOptions = this._getVMOptions();
	}

	_onSubmit() {
		return this._convertIPsToVMIPAddressOptions(
			_.get(this, 'vmOptions.networkAndIpAddressSettings.ipAddressSettings', [])
		);
	}

	_getVMOptions() {
		let vmOptions = {
			esxHostName: 'dummy',
			networkAndIpAddressSettings: {
				ipAddressSettings: [],
				networkSettings: []
			},
			networkSettingsDestinationNetworkData: {},
			settings: {
				ipAddressSettings: {},
				networkAndIpAddressSettings: {},
				networkSettings: {},
				ipAddressOpen: false
			},
			vsMetaData: {}
		};
		vmOptions.ipAddressSettingsGridOptions = this.replicationFactory.createIpAddressSettingsGrid(
			vmOptions.networkAndIpAddressSettings.ipAddressSettings
		);
		vmOptions.settings.hideDestComputerName = true;

		/* if the list of IP's are already available, fill it in the grid */
		if (_.get(this, 'ip', []).length > 0) {
			vmOptions.settings.ipAddressSettingsLoaded = true;
			vmOptions.networkAndIpAddressSettings.ipAddressSettings = this._convertIPsFromVMIPAddressOptions(this.ip);
			vmOptions.ipAddressSettingsGridOptions.gridOptions.data = vmOptions.networkAndIpAddressSettings.ipAddressSettings;
		}

		return vmOptions;
	}

	/* Converts a list of IP's into the TMMsg.VMIPAddressOptions from the format expected by cv-vmware-ipaddress-settings-directive.js */
	_convertIPsToVMIPAddressOptions(ips) {
		let self = this;
		let result = [];
		ips.forEach(ip => result.push(self._convertIPToVMIPAddressOptions(ip)));

		return result;
	}

	/* Converts a list of IP's from the TMMsg.VMIPAddressOptions into the format expected by cv-vmware-ipaddress-settings-directive.js */
	_convertIPsFromVMIPAddressOptions(ips) {
		let self = this;
		let result = [];
		ips.forEach(ip => result.push(self._convertIPFromVMIPAddressOptions(ip)));

		return result;
	}

	/* Converts IP into the TMMsg.VMIPAddressOptions from the format expected by cv-vmware-ipaddress-settings-directive.js */
	_convertIPToVMIPAddressOptions(ip) {
		return {
			sourceIP: ip.sourceIpAddress,
			sourceSubnet: ip.sourceSubnetMask,
			sourceGateway: ip.sourceDefaultGateway,
			destinationIP: ip.destinationIpAddress,
			destinationSubnet: ip.destinationSubnetMask,
			destinationGateway: ip.destinationDefaultGateway,
			primaryDNS: ip.destinationPrefDnsServer,
			alternateDNS: ip.destinationAltDnsServer,
			primaryWins: ip.destinationPrefWinsServer,
			alternateWins: ip.destinationAltWinsServer,
			useDhcp: ip.destinationUseDHCP
		};
	}

	/* Converts IP from the TMMsg.VMIPAddressOptions into the format expected by cv-vmware-ipaddress-settings-directive.js */
	_convertIPFromVMIPAddressOptions(ip) {
		return {
			sourceIpAddress: ip.sourceIP,
			sourceSubnetMask: ip.sourceSubnet,
			sourceDefaultGateway: ip.sourceGateway,
			destinationIpAddress: ip.destinationIP,
			destinationSubnetMask: ip.destinationSubnet,
			destinationDefaultGateway: ip.destinationGateway,
			destinationPrefDnsServer: ip.primaryDNS,
			destinationAltDnsServer: ip.alternateDNS,
			destinationPrefWinsServer: ip.primaryWins,
			destinationAltWinsServer: ip.alternateWins,
			destinationUseDHCP: ip.useDhcp
		};
	}
}

DRIPController.$inject = ['cvLoc', 'replicationFactory'];
drAppFailoverModule.directive('drIp', () => new DRIP());

export default drAppFailoverModule;
