import 'modules/disasterRecovery/js/directives/dr-network.directive.js';
import 'modules/disasterRecovery/js/dr.constants.js';

import { drAppFailoverModule } from 'common/js/modules';

class DRArrayESX {
	constructor() {
		this.restrict = 'E';
		this.templateUrl = appUtil.appRoot + 'modules/disasterRecovery/partials/drArrayESX.jsp';
		this.scope = {
			vApp: '=',
			servers: '=',
			sourceClientId: '=',
			destClientId: '=',
			ctrl: '=',
			errors: '='
		};
		this.require = ['^^cvSubmit', '^^form'];
		this.controllerAs = 'drArrayESXCtrl';
		this.controller = DRArrayESXController;
		this.bindToController = true;
	}

	link($scope, elem, attrs, ctrl) {
		$scope.submitController = ctrl[0];
		$scope.formController = ctrl[1];
	}
}

class DRArrayESXController {
	constructor($modal, cvLoc, FailoverEnum) {
		this.$modal = $modal;
		this.cvLoc = cvLoc;
		this.FailoverEnum = FailoverEnum;
		this.errors = this.errors || {};
		this.rowValue = {};
	}

	enableAddButton() {
		return !!(this.sourceClientId && this.destClientId);
	}

	showESXModal(rowValue) {
		if (this._isSourceDestHypervisorSame()) {
			return;
		}
		var modalInstance = this.$modal.open({
			templateUrl: appUtil.appRoot + 'modules/disasterRecovery/partials/drArrayESXBrowse.jsp',
			backdrop: 'static',
			controllerAs: 'drArrayESXBrowseCtrl',
			controller: DRArrayESXBrowseController,
			resolve: {
				sourceClientId: () => this.sourceClientId,
				destClientId: () => this.destClientId,
				servers: () => this.servers,
				rowValue: () => _.cloneDeep(rowValue),
				sourceServers: () => this._getSourceServers()
			}
		});

		modalInstance.result.then(yesFunc.bind(this));

		function yesFunc(rowValue) {
			let server = {
				sourceServer: rowValue.sourceServer,
				destinationServer: rowValue.destinationServer,
				restoreOption: {
					nics: rowValue.nics || []
				}
			};
			/* In case of edit operation, id is already present in the rowValue */
			if (rowValue.id >= 0) {
				var index = this.servers.findIndex(tuple => tuple.id === rowValue.id);
				server.id = rowValue.id;
				this.servers[index] = server;
			} else {
				server.id = _.size(this.servers) + 1;
				this.servers.push(server);
			}
		}
	}

	deleteESXRow(_rowValue) {
		var index = this.servers.findIndex(tuple => tuple.id === _rowValue.id);
		this.servers.splice(index, 1);
	}

	$onInit() {
		this.ctrl = this.ctrl || {};
		this.ctrl.isESXValid = this._isValid.bind(this);
		this.servers = this.servers || [];
		this.servers.forEach((server, index) => {
			server.id = index;
		});
	}

	/*
	 * All the source ESX servers should be mapped to a destination ESX
	 * sourceServers: contains the list of all the servers that all the machines belong to
	 * servers: contains the list of the servers mapping selected by the user
	 */
	_isValid(servers) {
		let sourceServers = this._getSourceServers();
		let results = _.differenceWith(sourceServers, servers, (s1, s2) => {
			return s1.name === s2.sourceServer;
		});
		let allServersMapped = results.length == 0; // If the length is 0, then all the source servers have been mapped to a destination
		if (!allServersMapped) {
			this.errors.message = this.cvLoc('error.esx.mapAll');
		}

		return allServersMapped;
	}

	_isSourceDestHypervisorSame() {
		if (this.sourceClientId != null && this.destClientId != null && this.sourceClientId === this.destClientId) {
			this.errors.message = this.cvLoc('error.sameSourceDestHypervisor');
			return true;
		} else {
			this.errors.message = '';
			return false;
		}
	}

	_getSourceServers() {
		let sourceServers = [];
		let selectedMachines = [];
		selectedMachines = this.vApp.machines.machinesList;
		selectedMachines = selectedMachines.filter(machine => !!machine && machine.hostName);
		sourceServers = selectedMachines.map(machine => {
			return {
				name: machine.hostName
			};
		});
		sourceServers = _.uniqWith(sourceServers, (s1, s2) => s1.name === s2.name);

		return sourceServers;
	}
}

class DRArrayESXBrowseController {
	constructor($modalInstance, cvLoc, servers, sourceClientId, destClientId, rowValue, sourceServers) {
		this.$modalInstance = $modalInstance;
		this.cvLoc = cvLoc;
		this.servers = servers;
		this.sourceClientId = sourceClientId;
		this.destClientId = destClientId;
		this.rowValue = rowValue;
		this.sourceServers = sourceServers;
		this._init();
	}

	onSourceServerSelect(init) {
		this.rowValue.sourceServer = _.get(this, 'sourceServer[0].name', '');
		this.ctrl.fetchSourceNetworks && this.ctrl.fetchSourceNetworks();
		this.errors = {};
		if (!init) {
			this.rowValue.nics = [];
		}
	}

	cancel() {
		this.$modalInstance.dismiss('Cancel');
	}

	save() {
		if (!this._isValid()) {
			return;
		}
		this.$modalInstance.close(this.rowValue);
	}

	_init() {
		this.errors = {};
		this.vmOptions = {};
		this.ctrl = {
			esxHostSelected: this._esxHostSelected.bind(this)
		};
		this.rowValue = this.rowValue || {};
		this.rowValue.nics = _.get(this, 'rowValue.restoreOption.nics', []);
		this.vmOptions.esxHostName = _.get(this, 'rowValue.destinationServer');
		this.sourceServer = [];
		let init = true;
		this._selectDefaultSourceESX();
		this.onSourceServerSelect(init);
		this._selectDefaultDestinationESX();
		this._onDestinationServerSelect(init);
	}

	_selectDefaultSourceESX() {
		if (this.sourceServers && this.sourceServers.length > 0) {
			let indexToSelect = 0;
			let sourceServer = _.get(this, 'rowValue.sourceServer');
			if (sourceServer) {
				indexToSelect = this.sourceServers.findIndex(server => server.name === sourceServer);
				indexToSelect = Math.max(indexToSelect, 0);
			}
			this.sourceServers[indexToSelect].selected = true;
			this.sourceServer[0] = this.sourceServers[indexToSelect];
		}
	}

	_selectDefaultDestinationESX() {
		this.vmOptions.destinationHost = [
			{
				displayName: _.get(this, 'rowValue.destinationServer')
			}
		];
	}

	_esxHostSelected() {
		this._onDestinationServerSelect();
	}

	_onDestinationServerSelect(init) {
		this.rowValue.destinationServer = _.get(this, 'vmOptions.esxHostName', '');
		this.ctrl.fetchDestinationNetworks && this.ctrl.fetchDestinationNetworks();
		this.errors = {};
		if (!init) {
			this.rowValue.nics = [];
		}
	}

	_isValid() {
		let isValid = true;
		isValid = isValid && !this._isSourceEmpty();
		isValid = isValid && !this._isDestinationEmpty();
		if (this._isSourceDuplicate()) {
			this.errors.source = this.cvLoc('error.esx.source.duplicate');
			isValid = false;
		} else if (this._isNetworkEmpty()) {
			this.errors.message = this.cvLoc('error.networkMandatory');
			isValid = false;
		}

		return isValid;
	}

	_isSourceEmpty() {
		return _.isEmpty(_.get(this, 'sourceServer[0].name', ''));
	}

	_isDestinationEmpty() {
		return _.isEmpty(this.vmOptions.esxHostName);
	}

	/*
	 * One to many mapping of the source to destination is not allowed,
	 * except when id is available in the rowValue.id field since it denotes a n edit operation
	 */
	_isSourceDuplicate() {
		let self = this;
		let duplicateEntryIndex = this.servers.findIndex(server => {
			return server.id != self.rowValue.id && server.sourceServer === self.rowValue.sourceServer;
		});

		return duplicateEntryIndex >= 0;
	}

	_isNetworkEmpty() {
		return _.get(this, 'rowValue.nics', []).length === 0;
	}
}

DRArrayESXController.$inject = ['$uibModal', 'cvLoc', 'FailoverEnum'];
DRArrayESXBrowseController.$inject = [
	'$uibModalInstance',
	'cvLoc',
	'servers',
	'sourceClientId',
	'destClientId',
	'rowValue',
	'sourceServers'
];
drAppFailoverModule.directive('drArrayEsx', () => new DRArrayESX());

export default drAppFailoverModule;
