import 'modules/disasterRecovery/js/factory/dr.factory.js';
import 'vsa/js/controllers/replication.ctrl.js';

import { drAppFailoverModule } from 'common/js/modules';

/**
 * Creates a Replication Target dropdown and adds a Create Target as the first value
 */

var failoverMod = drAppFailoverModule;

var vsaReplicationTargetDirective = function() {
	return {
		restrict: 'E',
		templateUrl: appUtil.appRoot + 'modules/disasterRecovery/partials/cvVSAReplicationTarget.jsp',
		scope: {},
		require: [],
		bindToController: {
			selectedTarget: '=',
			destVendor: '=',
			targetIdToTick: '=',
			isEdit: '=',
			appType: '=?'
		},
		controller: 'vsaReplicationTargetController',
		controllerAs: 'repTargetCtrl'
	};
};

var controllers = {};
failoverMod.controller('vsaReplicationTargetController', [
	'$scope',
	'cvLoc',
	'replicationFactory',
	'drOrchestrationFactory',
	'VSA_VENDOR',
	'VM_POLICY_APP_TYPE',
	function($scope, cvLoc, replicationFactory, drOrchestrationFactory, VSA_VENDOR, VM_POLICY_APP_TYPE) {
		var self = this;
		this.$onInit = function() {
			// functions
			self.onTargetClick = onTargetClick;
			self.getColumnSize = getColumnSize;

			// validation messages
			self.localLangReplicationTarget = drOrchestrationFactory.getLocalLang(cvLoc('msg.selectTarget'));

			// initial function
			showReplicationTargets();

			$scope.$on('showReplicationTargets', function(event, destVendor) {
				self.destVendor = destVendor;
				showReplicationTargets();
			});

			function onTargetClick() {
				if (
					self.selectedTarget &&
					self.selectedTarget.length > 0 &&
					self.selectedTarget[0].name === cvLoc('label.createTarget')
				) {
					var repTargetModal = replicationFactory.showAddReplicationTarget(
						null,
						null,
						null,
						_.get(self.appType, 'type'),
						self.destVendor,
						null,
						true //using this option to show the requested destination vendor in this case VMWare
					);
					repTargetModal.result.then(
						function(vmAllocPolicyId) {
							self.targetIdToTick = vmAllocPolicyId;
							showReplicationTargets();
						},
						function() {
							self.replicationTargets[0].selected = false;
							self.selectedTarget = [];
						}
					);
				}
			}

			function getColumnSize() {
				if (self.isEdit) {
					return 'col-xs-12 col-sm-5';
				} else {
					return 'col-xs-12 col-sm-3';
				}
			}

			// TODO: This function calls the API to get replication targets each time the hypervisor changes. Fix it.
			function showReplicationTargets() {
				if (self.destVendor) {
					if (drOrchestrationFactory.isAzureRMVendor(self.destVendor)) {
						getAzureRMTargets();
					} else if (drOrchestrationFactory.isVMWareVendor(self.destVendor)) {
						getVirtualLabAndLiveMountTargets(_.get(self.appType, 'id'));
					}
				}
			}

			function getVirtualLabAndLiveMountTargets(appType) {
				drOrchestrationFactory.getVirtualLabAndLiveMountTargets(appType).then(function() {
					buildTargetDropdown(drOrchestrationFactory.virtualLabAndLiveMountTargets);
				});
			}

			function getAzureRMTargets() {
				drOrchestrationFactory.getAzureRMTargets().then(function() {
					buildTargetDropdown(drOrchestrationFactory.azureRMTargets);
				});
			}

			/*
			 * Adds a Create Target link as the first element Adds a header and the list of targets into the
			 * dropdown. Selects a default value if available.
			 */
			function buildTargetDropdown(targets) {
				var targetHeader = {
					name: '<strong>' + cvLoc('label.targets') + '</strong>',
					header: true
				};
				var end = {
					header: false
				};
				self.replicationTargets = [
					{
						name: cvLoc('label.createTarget'),
						selected: false
					}
				];
				self.replicationTargets = self.replicationTargets.concat(targetHeader);
				self.replicationTargets = self.replicationTargets.concat(targets);
				self.replicationTargets = self.replicationTargets.concat(end);

				if (self.targetIdToTick) {
					var targetToSelect = targets.find(function(target) {
						return target.entity && target.entity.vmAllocPolicyId === self.targetIdToTick;
					});

					if (targetToSelect) {
						targetToSelect.selected = true;
					}
				}
			}
		};
	}
]);

failoverMod.directive('cvVsaReplicationTarget', vsaReplicationTargetDirective);

export default failoverMod;
