import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';

import { drAppFailoverModule } from 'common/js/modules';

/**
 * Edits the basic details of each machine in the DR Group
 */

var failoverMod = drAppFailoverModule;

failoverMod.controller('machineDetailsController', [
	'$state',
	'$stateParams',
	'$uibModalInstance',
	'cvLoc',
	'cvUtil',
	'drCRUDFactory',
	'vApp',
	'machine',
	function($state, $stateParams, $uibModalInstance, cvLoc, cvUtil, drCRUDFactory, vApp, machine) {
		var self = this;

		// functions
		self.save = save;
		self.closeModal = closeModal;

		// variables
		self.vApp = vApp;
		self.machine = machine;
		self.priority = self.machine.groupId;
		self.machineName = self.machine.client.clientName;

		function closeModal() {
			$uibModalInstance.dismiss();
		}

		// if the priority has changed, the machine has to be moved to a different vmgroup.
		function save() {
			if (!self.priority || self.priority < 1) {
				self.priorityValidation = {
					message: cvLoc('msg.validPriority'),
					type: 'error'
				};
				return;
			} else {
				self.priorityValidation = cvUtil.emptyMsg();
			}
			// get the index of the machine to be removed
			var machineIndextoSplice = -1;
			var groupIndextoSplice = -1;
			self.vApp.config.vmGroups.forEach(function(vmGroup, groupIndex) {
				if (vmGroup.vmSequence) {
					vmGroup.vmSequence.forEach(function(sequence, index) {
						if (
							sequence.vmInfo.vmName === self.machine.client.clientName &&
							sequence.vmInfo.vmGUID === self.machine.client.GUID &&
							sequence.replicationId === self.machine.replicationId
						) {
							if (vmGroup.groupId != self.priority) {
								machineIndextoSplice = index;
								groupIndextoSplice = groupIndex;
							}
						}
					});
				}
			});

			if (machineIndextoSplice > -1 && groupIndextoSplice > -1) {
				// remove the machine from the vmGroup
				var updatedMachine = self.vApp.config.vmGroups[groupIndextoSplice].vmSequence.splice(machineIndextoSplice, 1);
				if (updatedMachine && updatedMachine.length > 0) {
					updatedMachine = updatedMachine[0];
				}

				// add the machine to the appropriate group
				var added = false;
				self.vApp.config.vmGroups.forEach(function(vmGroup) {
					if (vmGroup.groupId == self.priority) {
						if (!vmGroup.vmSequence) {
							vmGroup.vmSequence = [];
						}
						vmGroup.vmSequence.push(updatedMachine);
						added = true;
					}
				});

				if (!added) {
					var vmGroup = {};
					vmGroup.delay = self.vApp.config.vmGroups[groupIndextoSplice].delay;
					vmGroup.continueOnFailure = self.vApp.config.vmGroups[groupIndextoSplice].continueOnFailure;
					vmGroup.groupId = self.priority;
					vmGroup.vmSequence = [];
					vmGroup.vmSequence.push(updatedMachine);
					self.vApp.config.vmGroups.push(vmGroup);
				}

				// remove the vmGroup if it does not contain any VM's.
				if (_.isEmpty(self.vApp.config.vmGroups[groupIndextoSplice].vmSequence)) {
					self.vApp.config.vmGroups.splice(groupIndextoSplice, 1);
				}
			}

			closeModal();
			drCRUDFactory.updateFailoverGroup(self.vApp);
		}
	}
]);

export default failoverMod;
