import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';
import 'modules/disasterRecovery/js/factory/drScript.factory.js';
import 'modules/disasterRecovery/js/dr.constants.js';
import 'vsa/js/factories/backupValidation.factory.js';

import { drAppFailoverModule } from 'common/js/modules';

/**
 * Handles adding / editing / validating Post and pre script to each machine in the DR Group
 */

var failoverMod = drAppFailoverModule;

failoverMod.controller('drScriptController', [
	'cvUtil',
	'cvLoc',
	'drScriptFactory',
	'drCRUDFactory',
	'FailoverEnum',
	function(cvUtil, cvLoc, drScriptFactory, drCRUDFactory, FailoverEnum) {
		var self = this;

		// variables
		self.userImpersonationOptions = true;
		self.userImpersonation = {};
		self.machine = drScriptFactory.machine;
		self.vApp = drScriptFactory.vApp;
		self.isPreScript = drScriptFactory.isPreScript(drScriptFactory.scriptType);
		self.isPostScript = drScriptFactory.isPostScript(drScriptFactory.scriptType);
		self.isAppValidationScript = drScriptFactory.isAppValidationScript(drScriptFactory.scriptType);
		self.openedFromDetailsPage = drScriptFactory.openedFromDetailsPage;
		if (self.isPreScript && self.machine.preScript && self.machine.preScript.script) {
			self.isEditMode = true;
			self.editPassword = false;
			self.uncNetworkPath = self.machine.preScript.script;
			self.username = self.machine.preScript.UNCCredentials.userName;
			self.userImpersonation.username = self.machine.preScript.userImpersonation.userName;
		} else if (self.isPostScript && self.machine.postScript && self.machine.postScript.script) {
			self.isEditMode = true;
			self.editPassword = false;
			self.uncNetworkPath = self.machine.postScript.script;
			self.username = self.machine.postScript.UNCCredentials.userName;
			self.userImpersonation.username = self.machine.postScript.userImpersonation.userName;
		}

		if (self.isAppValidationScript) {
			//vApp is validation app in the case of backup validation
			self.appName = self.vApp.appName;

			//Currently supporting one validation script per app type
			if (self.vApp.script && self.vApp.script.length) {
				self.scriptDetails = self.vApp.script[0];
				self.uncNetworkPath = self.scriptDetails.scriptPath;
			}
			self.inAppCreationMode = self.appName === undefined ? true : false;
		}

		// functions
		self.save = save;
		self.closeModal = drScriptFactory.closeModal;
		self.validateAppName = validateAppName;
		self.validateNetworkPath = validateNetworkPath;
		self.validateUserName = validateUserName;
		self.validatePassword = validatePassword;
		self.validateConfirmPassword = validateConfirmPassword;
		self.validateUIUserName = validateUIUserName;
		self.validateUIPassword = validateUIPassword;
		self.validateUIConfirmPassword = validateUIConfirmPassword;

		// validation messages
		self.networkPathValidationMsg = emptyMsg();
		self.userNameValidationMsg = emptyMsg();
		self.passwordValidationMsg = emptyMsg();
		self.confirmPasswordValidationMsg = emptyMsg();
		self.userImpersonation.userNameValidationMsg = emptyMsg();
		self.userImpersonation.passwordValidationMsg = emptyMsg();
		self.userImpersonation.confirmPasswordValidationMsg = emptyMsg();

		function saveAppValidationScriptDetails() {
			var script = {};
			script.UNCCredentials = {};
			script.UNCCredentials.userName = self.username;
			script.UNCCredentials.password =
				!self.isEditMode || self.changePassword ? cvUtil.getBytes(self.password) : undefined;
			script.script = self.uncNetworkPath;
			script.isUNC = true;
			script.appValidationId = self.vApp.appTypeId;
			self.machine.validationScript = script;
		}

		function save() {
			if (!areInputsValid()) {
				return;
			}

			if (self.isAppValidationScript) return saveAppValidationScriptDetails();

			var script = {};
			script.UNCCredentials = {};
			script.UNCCredentials.userName = self.username;
			script.UNCCredentials.password =
				!self.isEditMode || self.changePassword ? cvUtil.getBytes(self.password) : undefined;
			script.script = self.uncNetworkPath;
			script.isUNC = true;
			script.userImpersonation = {};
			script.userImpersonation.userName = self.userImpersonation.username;
			script.userImpersonation.password =
				!self.isEditMode || self.changeImpersonationPassword
					? cvUtil.getBytes(self.userImpersonation.password)
					: undefined;
			if (self.isPreScript) {
				self.machine.preScript = script;
			} else if (self.isPostScript) {
				self.machine.postScript = script;
			}

			// Indicates an edit operation or an add from details page operation, in which case, update the vapp
			if (self.isEditMode || self.openedFromDetailsPage) {
				self.vApp.config.vmGroups.forEach(function(vmGroup, groupIndex) {
					if (vmGroup.vmSequence) {
						vmGroup.vmSequence.forEach(function(sequence, index) {
							if (
								sequence.vmInfo.vmName === self.machine.client.clientName &&
								sequence.vmInfo.vmGUID === self.machine.client.GUID &&
								sequence.replicationId === self.machine.replicationId
							) {
								if (self.isPreScript) {
									if (!sequence.preScript) {
										sequence.preScript = {};
									}
									sequence.preScript = script;
								} else if (self.isPostScript) {
									if (!sequence.postScript) {
										sequence.postScript = {};
									}
									sequence.postScript = script;
								}
							}
						});
					}
				});

				drCRUDFactory.updateFailoverGroup(self.vApp);
			}

			self.closeModal();
		}

		function validateAppName() {
			self.appNameValidationMsg = validateInput(self.appName, 'msg.userNameInvalid');
			return self.appNameValidationMsg;
		}

		function validateNetworkPath() {
			self.networkPathValidationMsg = validateInput(self.uncNetworkPath, 'msg.uncNetworkPathInvalid');
			return self.networkPathValidationMsg;
		}

		function validateUserName() {
			self.userNameValidationMsg = validateInput(self.username, 'msg.userNameInvalid');
			return self.userNameValidationMsg;
		}

		function validatePassword() {
			self.passwordValidationMsg = validateInput(self.password, 'msg.passwordInvalid');
			return self.passwordValidationMsg;
		}

		function validateConfirmPassword() {
			self.confirmPasswordValidationMsg = validateInputConfirmPassword(
				self.password,
				self.confirmPassword,
				'msg.passwordsDoNotMatch'
			);
			return self.confirmPasswordValidationMsg;
		}

		function validateUIUserName() {
			self.userImpersonation.userNameValidationMsg = validateInput(
				self.userImpersonation.username,
				'msg.userNameInvalid'
			);
			return self.userImpersonation.userNameValidationMsg;
		}

		function validateUIPassword() {
			self.userImpersonation.passwordValidationMsg = validateInput(
				self.userImpersonation.password,
				'msg.passwordInvalid'
			);
			return self.userImpersonation.passwordValidationMsg;
		}

		function validateUIConfirmPassword() {
			self.userImpersonation.confirmPasswordValidationMsg = validateInputConfirmPassword(
				self.userImpersonation.password,
				self.userImpersonation.confirmPassword,
				'msg.passwordsDoNotMatch'
			);
			return self.userImpersonation.confirmPasswordValidationMsg;
		}

		function areInputsValid() {
			self.isValidInput = true;

			validateNetworkPath();
			validateUserName();
			if (!self.isEditMode || self.changePassword) {
				validatePassword();
				validateConfirmPassword();
			}
			validateUIUserName();
			if (!self.isEditMode || self.changeImpersonationPassword) {
				validateUIPassword();
				validateUIConfirmPassword();
			}

			if (!self.isAppValidationScript) {
				validateUIUserName();
				if (!self.isEditMode || self.changeImpersonationPassword) {
					validateUIPassword();
					validateUIConfirmPassword();
				}
			}
			return self.isValidInput;
		}

		function validateInput(input, errorText) {
			if (!input) {
				self.isValidInput = false;
				return errorMsg(errorText);
			} else {
				return emptyMsg();
			}
		}

		function validateInputConfirmPassword(password, confirmPassword, errorText) {
			if (!confirmPassword || password != confirmPassword) {
				self.isValidInput = false;
				return errorMsg(errorText);
			} else {
				return emptyMsg();
			}
		}

		function emptyMsg() {
			return cvUtil.emptyMsg();
		}

		function errorMsg(errorMsg) {
			return {
				text: cvLoc(errorMsg),
				type: 'error'
			};
		}
	}
]);

export default failoverMod;
