import 'modules/disasterRecovery/js/directives/dr-machines.directive.js';
import 'modules/disasterRecovery/js/factory/drArrayReplication.factory.js';
import 'modules/disasterRecovery/js/factory/drMachines.factory.js';

import { drAppFailoverModule } from 'common/js/modules';

/*
 * expected input for machines:
 * machines = {
	allMachines: []	// list of all the machines to be shown	
 }
 */

const DRArrayMachinesPageSize = 15;

export class DRArrayMachinesSelectController {
	constructor($uibModalInstance, cvLoc, arrayReplicationFactory, drMachinesFactory, machines) {
		this.$uibModalInstance = $uibModalInstance;
		this.cvLoc = cvLoc;
		this.arrayReplicationFactory = arrayReplicationFactory;
		this.drMachinesFactory = drMachinesFactory;
		this.machines = machines || [];
		this.machines.machinesList = this.machines.allMachines || [];
		this._initGridOptions();
	}

	close() {
		this.$uibModalInstance.dismiss();
	}

	submit() {
		let selectedMachines = this.machines.grid.getSelectedRows().values;
		this.$uibModalInstance.close(selectedMachines);
	}

	_initGridOptions() {
		let gridOptions = {
			tableName: 'drArrayMachinesSelect',
			columnsTemplate: this.arrayReplicationFactory.getSelectMachinesColumns(),
			enableCheckBoxColumn: true,
			gridToolbarMenu: [this._getSelectAllMenu(), this._getSelectNoneMenu()],
			pageSize: DRArrayMachinesPageSize,
			searchable: true,
			gridEmptyMessage: this.cvLoc('msg.noVMsAvailable')
		};

		this.machines.gridOptions = gridOptions;
	}

	_getSelectAllMenu() {
		return {
			id: 'selectAll-drArrayMachinesSelect',
			label: this._getLabel(this.cvLoc('label.selectAll')),
			onSelect: this._selectAll.bind(this),
			hidden: _.get(this, 'machines.machinesList', []).length === 0
		};
	}

	_getSelectNoneMenu() {
		return {
			id: 'selectNone-drArrayMachinesSelect',
			label: this.cvLoc('label.selectNone'),
			onSelect: this._selectNone.bind(this),
			hidden: _.get(this, 'machines.machinesList', []).length === 0
		};
	}

	_selectAll() {
		this.drMachinesFactory.selectAllMachines(this.machines.grid.grid);
	}

	_selectNone() {
		this.drMachinesFactory.clearGridSelection(this.machines.grid.grid);
	}

	_getLabel(label) {
		if (this.machines.allMachines.length > DRArrayMachinesPageSize) {
			label = `${label} (${this.machines.allMachines.length})`;
		}

		return label;
	}
}

DRArrayMachinesSelectController.$inject = [
	'$uibModalInstance',
	'cvLoc',
	'arrayReplicationFactory',
	'drMachinesFactory',
	'machines'
];
drAppFailoverModule.controller('drArrayMachinesSelectController', DRArrayMachinesSelectController);

export default drAppFailoverModule;
