import 'modules/disasterRecovery/js/factory/dr.factory.js';
import 'modules/disasterRecovery/js/factory/drArrayReplication.factory.js';
import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';
import 'modules/disasterRecovery/js/factory/drVirtualLab.factory.js';
import 'modules/disasterRecovery/js/services/failoverGroup/failoverGroup.svc.js';

import { drAppFailoverModule } from 'common/js/modules';

export class DevtestGroupDetailsController {
	constructor(
		$stateParams,
		$state,
		cvBreadcrumbsTabsFactory,
		cvToaster,
		cvLoc,
		failoverService,
		drOrchestrationFactory,
		drCRUDFactory,
		drVirtualLabFactory,
		arrayReplicationFactory,
		FailoverConstants
	) {
		this.$state = $state;
		this.cvToaster = cvToaster;
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
		this.cvLoc = cvLoc;
		this.failoverService = failoverService;
		this.drOrchestrationFactory = drOrchestrationFactory;
		this.drCRUDFactory = drCRUDFactory;
		this.drVirtualLabFactory = drVirtualLabFactory;
		this.arrayReplicationFactory = arrayReplicationFactory;
		this.FailoverConstants = FailoverConstants;
		this.vAppId = $stateParams.vAppId;
		this._init();
	}

	editGroup() {
		let self = this;
		this.drOrchestrationFactory.openDevtestCreateModal(this.vApp).result.then(function() {
			self.$state.reload();
		});
	}

	deleteGroup() {
		this.drCRUDFactory.deleteGroup(this.vApp.vAppEntity.vAppId, this.vApp.vAppEntity.vAppName, 'devtest');
	}

	createVirtualLab() {
		this.drVirtualLabFactory.createVirtualLab(this.vApp);
	}

	_init() {
		let self = this;
		this._addBreadCrumbs();
		this._getGroupDetails().then(function() {
			self.isSnapArrayReplication =
				self.vApp.replicationType === self.FailoverConstants.DRReplicationType['SnapArrayReplication'];
			if (self.isSnapArrayReplication) {
				self.vApp.vendor = self.FailoverConstants.Vendors.VMW;
			}
			self._initMachines();
			self._getMachines();
		});
	}

	_initMachines() {
		this.vApp.machines = this.vApp.machines || {};
		this.vApp.machines.columnsTemplate = this.arrayReplicationFactory.getDevtestColumnsTemplate();
	}

	_addBreadCrumbs() {
		this.cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: this.cvLoc('label.devtestGroups'),
				link: '#devtest'
			}
		]);
	}

	_getGroupDetails() {
		let self = this;
		return this.failoverService
			.getFailoverGroupDetails(this.vAppId)
			.success(function(data) {
				if (data && data.length > 0) {
					self.vApp = data[0];
				}
			})
			.error(function(e) {
				self.showErrorMessage(e);
			});
	}

	_getMachines() {
		let self = this;
		let subclientId = this.vApp.arrayReplication.subclient.subclientId;
		let copyId = this.vApp.arrayReplication.copyId;

		this.vApp.machines.machinesList = [];
		this.vApp.machines.isLoading = true;
		this.arrayReplicationFactory.getArrayMachines(subclientId, copyId).then(function(data) {
			self.vApp.machines.isLoading = false;
			if (data) {
				data.forEach(machine => {
					if (self.vApp.clientList.findIndex(client => client.clientGUID === machine.clientGUID) >= 0) {
						self.vApp.machines.machinesList.push(machine);
					}
				});
				self.vApp.machines.grid.refreshData();
			} else {
				self.vApp.machine.machinesList = [];
			}
		});
	}
}

DevtestGroupDetailsController.$inject = [
	'$stateParams',
	'$state',
	'cvBreadcrumbsTabsFactory',
	'cvToaster',
	'cvLoc',
	'failoverService',
	'drOrchestrationFactory',
	'drCRUDFactory',
	'drVirtualLabFactory',
	'arrayReplicationFactory',
	'FailoverConstants'
];
drAppFailoverModule.controller('devtestGroupDetailsController', DevtestGroupDetailsController);

export default drAppFailoverModule;
