import * as GridConstants from 'common/js/newGrid/grid.constants.js';

export const getColumns = function(cvLoc, filterLists) {
	const columnList = [
		getMachineName(cvLoc, filterLists.clientNames),
		getCurrentPhaseName(cvLoc, filterLists.phases),
		getPhaseStatus(cvLoc, filterLists.phaseStatus),
		getPhaseStartTime(cvLoc),
		getPhaseElapsedTime(cvLoc),
		getFailureReason(cvLoc)
	];
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};

export const getDetailsColumns = function(cvLoc) {
	const columnList = [
		getPhaseName(cvLoc),
		getPhaseStatusDetails(cvLoc),
		getPhaseStartTime(cvLoc),
		getPhaseElapsedTime(cvLoc),
		getFailureReason(cvLoc)
	];
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};

export const getMachineName = function(cvLoc, filter) {
	return {
		clientName: {
			title: cvLoc('label.machineName'),
			type: 'string',
			template: `<span cv-toggle="tooltip" cv-toggle-content="#:clientName#">#:clientName#</span>`,
			width: '15%',
			filterType: 'checkboxmultiselect',
			searchField: 'clientName',
			filterConditions: [GridConstants.FILTER_CONDITIONS.EQUALS],
			data: filter
		}
	};
};

export const getCurrentPhaseName = function(cvLoc, filter) {
	return {
		phaseText: {
			title: cvLoc('label.latestPhase'),
			type: 'string',
			template: `<span class="crop" cv-toggle="tooltip" cv-toggle-content="#:phaseText#">#:phaseText#</span>`,
			width: '15%',
			filterType: 'checkboxmultiselect',
			searchField: 'phaseText',
			filterConditions: [GridConstants.FILTER_CONDITIONS.EQUALS],
			data: filter
		}
	};
};

export const getPhaseName = function(cvLoc) {
	return {
		phaseText: {
			title: cvLoc('label.phaseName'),
			type: 'string',
			template: `<span class="crop" cv-toggle="tooltip" cv-toggle-content="#:phaseText#">#:phaseText#</span>`,
			width: '15%',
			searchField: 'phaseText'
		}
	};
};

export const getPhaseStatus = function(cvLoc, filter) {
	return {
		statusText: {
			title: cvLoc('label.phaseStatus'),
			type: 'string',
			template: `#if(phaseJobId != 0){
							#<a class="crop" cv-toggle="tooltip" cv-toggle-content="#:statusText#" href="\\#/jobs/#:phaseJobId#">#:statusText#</a>#
						} else {
							#<span class="crop" cv-toggle="tooltip" cv-toggle-content="#:statusText#">#:statusText#</span>#
 						}#`,
			width: '15%',
			filterType: 'checkboxmultiselect',
			searchField: 'statusText',
			filterConditions: [GridConstants.FILTER_CONDITIONS.EQUALS],
			data: filter
		}
	};
};

export const getPhaseStatusDetails = function(cvLoc) {
	return {
		statusText: {
			title: cvLoc('label.phaseStatus'),
			type: 'string',
			template: `#if(phaseJobId){
				#<a class="crop" cv-toggle="tooltip" cv-toggle-content="#:statusText#" href="\\#/jobs/#:phaseJobId#">#:statusText#</a>#
			} else {
				#<span class="crop" cv-toggle="tooltip" cv-toggle-content="#:statusText#">#:statusText#</span>#
				}#`,
			width: '15%',
			searchField: 'statusText'
		}
	};
};

export const getPhaseStartTime = function(cvLoc) {
	return {
		startTimeString: {
			title: cvLoc('label.phaseStartTime'),
			type: 'string',
			template: `<span class="crop" cv-toggle="tooltip" cv-toggle-content="#:startTimeString#">#:startTimeString#</span>`,
			width: '15%'
		}
	};
};

export const getPhaseEndTime = function(cvLoc) {
	return {
		endTimeString: {
			title: cvLoc('label.phaseEndTime'),
			type: 'string',
			template: `<span class="crop" cv-toggle="tooltip" cv-toggle-content="#:endTimeString#">#:endTimeString#</span>`,
			width: '15%'
		}
	};
};

export const getPhaseElapsedTime = function(cvLoc) {
	return {
		endTimeString: {
			title: cvLoc('label.phaseElapsedTime'),
			type: 'string',
			template: `<span class="crop" cv-toggle="tooltip" cv-toggle-content="#:elapsedTimeString#">#:elapsedTimeString#</span>`,
			width: '15%'
		}
	};
};

export const getFailureReason = function(cvLoc) {
	return {
		failureReason: {
			title: cvLoc('label.failureReason'),
			type: 'string',
			template: `<span class="crop" cv-toggle="tooltip" cv-toggle-content="#:failureReason#">#:failureReason#</span>`,
			width: '25%'
		}
	};
};
