export const getColumns = function(onActionsClick, angularLibs) {
	const columnList = [
		getNameColumn(angularLibs.cvLoc),
		getSourceColumn(angularLibs.cvLoc),
		getMachinesCountColumn(angularLibs.cvLoc)
	];
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};

export const getNameColumn = function(cvLoc) {
	return {
		'vAppEntity.vAppName': {
			title: cvLoc('label.name'),
			type: 'string',
			template:
				'<a class="crop" cv-toggle="tooltip" cv-toggle-content="#:vAppEntity.vAppName#" href="\\#/devtestDetails/#:vAppEntity.vAppId#">#:vAppEntity.vAppName#</a>',
			disableViewFiltering: false,
			width: '50%'
		}
	};
};

export const getSourceColumn = function(cvLoc) {
	return {
		source: {
			title: cvLoc('label.source'),
			width: '20%',
			template: `<span cv-toggle="tooltip" cv-toggle-content="#:source#">#:source#</span>`
		}
	};
};

export const getMachinesCountColumn = function(cvLoc) {
	return {
		machinesCount: {
			title: cvLoc('label.column.numberofMachines'),
			template: '<a class="crop" cv-toggle="tooltip" cv-toggle-content="#:machinesCount#">#:machinesCount#</a>',
			width: '15%'
		}
	};
};
