<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.snapArray"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-if="!editMode">
		<cv:msg key="label.addCredential" bundle="users"/>
	</h1>
	<h1 data-ng-if="editMode">
		<cv:msg key="label.editCredential" bundle="users"/>
	</h1>
</div>
<div class="bootstrap-wrapper form-horizontal modal-margin">
	<form name="addEditUserForm" data-cv-submit="addNewCredentials()" novalidate>
		<div class="form-group" data-ng-if="(editMode || showInputs) && !hideCloudInputs" >
			<label for="recordTypeList" class="col-sm-5 col-xs-5">
				<cv:msg key="label.accountType" bundle="users" />
			</label>
			<div class="col-sm-7 col-xs-7" data-ng-disabled="editMode || disableList">
				<isteven-multi-select
					directive-id="recordTypeList"
					input-model="recordTypeList"
					output-model="credentialReq.recordType"
					button-label="label"
					item-label="label"
					id="recordTypeList"
					tick-property="selected"
					class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
					helper-elements="none"
					selection-mode="single"
					on-item-click="setCloudAccountInputs(data)"
					translation="credAcctTypeTranslation">
				</isteven-multi-select>
				<span class="help-block" data-ng-show="helpText.recordType"><cv:msg key="error.accountType" bundle="users"/></span>
			</div>
		</div>
		<div class="form-group" data-ng-if="((editMode || showInputs) && cloudAccount)  && !hideCloudInputs">
			<label for="vendorTypeList" class="col-sm-5 col-xs-5">
				<cv:msg key="label.vendorType" bundle="nas" />
			</label>
			<div class="col-sm-7 col-xs-7" data-ng-disabled="editMode || disableList">
				<isteven-multi-select
					directive-id="vendorTypeList"
					input-model="vendorTypeList"
					output-model="vendorSelection.vendorType"
					button-label="label"
					item-label="label"
					id="vendorTypeList"
					tick-property="selected"
					class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
					helper-elements="filter"
					selection-mode="single"
					on-item-click="setVendorTypeInputs(data)"
					search-property="label"
					translation="cloudVendorTypeTranslation">
				</isteven-multi-select>
				<span class="help-block" data-ng-show="helpText.vendorType"><cv:msg key="error.cloudVendorType" bundle="users"/></span>
			</div>
		</div>
			<div class="form-group" data-ng-if="((editMode || showInputs) && showAuthType) && !hideCloudInputs">
			<label for="authenticationTypeList" class="col-sm-5 col-xs-5">
				<cv:msg key="label.authType" bundle="storage" />
			</label>
			<div class="col-sm-7 col-xs-7" data-ng-disabled="editMode || (disableList && disableAuthType)">
				<isteven-multi-select
					directive-id="authenticationTypeList"
					input-model="authenticationTypeList"
					output-model="vendorSelection.authType"
					button-label="label"
					item-label="label"
					id="authenticationTypeList"
					tick-property="selected"
					class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
					helper-elements="filter"
					selection-mode="single"
					on-item-click="changeUserPasswordLabels(data)"
					search-property="label"
					translation="cloudVendorTypeTranslation">
				</isteven-multi-select>
				<span class="help-block" data-ng-show="placeholder.authenticationType"><cv:msg key="error.authenticationType" bundle="storage"/></span>
			</div>
		</div>
		<div class="form-group">
			<label for="credentialName" class="col-sm-5 col-xs-5">
				<cv-help-text help-label="<cv:msg key="label.accountName" bundle="servers" />" help-text="'<cv:msg key='label.credentialNameHelpText' bundle='storage' />'"/>
			</label>
			<div class="col-sm-7 col-xs-7">
				<input type="text" id="credentialName" name="credentialName" data-ng-model="credentialReq.credentialRecord.credentialName" data-ng-change="helpText.credentialName=false;" autofocus required />
				<span class="help-block" data-ng-show="helpText.credentialName"><cv:msg key="error.accountName" bundle="servers" /></span>
			</div>
		</div>
		<div class="form-group" data-ng-if="!azure.azureADAccount && !vmRole">
			<label class="col-sm-5 col-xs-5"  for="userName" >
				{{userNameLabel | cvLoc}}
			</label>
			<div class="col-sm-7 col-xs-7">
				<input type="text" id="userName" name="userName" data-ng-model="credentialReq.record.userName" data-ng-change="helpText.userName=false;" autofocus required />
				<span class="help-block" data-ng-show="helpText.userName">{{userNameError | cvLoc}}</span>
			</div>
		</div>
		<div class="form-group" data-ng-if="!azure.azureADAccount  &&  !vmRole">
			<label for="password" class="col-sm-5 col-xs-5" >
				{{passwordLabel | cvLoc}}
			</label>
			<div class="col-sm-7 col-xs-7">
				<input type="password" id="password" name="password" data-ng-model="cred.password" placeholder='{{ editMode ? "<cv:msg key="placeholder.editUserPassword" bundle="users" />" : "" }}' data-ng-change="helpText.password=false;" autofocus />
				<span class="help-block" data-ng-show="helpText.password">{{passwordError | cvLoc}}</span>
			</div>
		</div>
		<!-- Role ARN is applicable only for Amazon specific vendor -->
		<div class="form-group" data-ng-if="showAuthType && showRoleARN">
			<label for="RoleARN" class="col-sm-5 col-xs-5" >
				<cv:msg key="label.roleArn" bundle="servers" />
			</label>
			<div class="col-sm-7 col-xs-7">
				<input type="text" id="RoleARN" name="RoleARN" data-ng-model="credentialReq.record.userName"  data-ng-change="helpText.roleARN=false;" />
				<span class="help-block" data-ng-show="helpText.roleARN"><cv:msg key="error.roleArn" bundle="servers" /></span>
			</div>
		</div>
		<div class="form-group" data-ng-if="azure.azureADAccount">
			<label for="tenantId" class="col-sm-5 col-xs-5" >
				<cv-help-text help-label="<cv:msg key="label.tenantId" bundle="servers" />" help-text="'<cv:msg key='label.tenantIdHelpText' bundle='servers' />'"/>
			</label>
			<div class="col-sm-7 col-xs-7">
				<input type="text" id="tenantId" name="tenantId" data-ng-model="credentialReq.additionalInformation.azureCredInfo.tenantId" data-ng-change="helpText.tenantId=false;" autofocus required />
				<span class="help-block" data-ng-show="helpText.tenantId"><cv:msg key="error.tenantId" bundle="servers" /></span>
			</div>
		</div>
		<div class="form-group" data-ng-if="azure.azureADAccount">
			<label for="applicationId" class="col-sm-5 col-xs-5" >
				<cv-help-text help-label="<cv:msg key="label.applicationId" bundle="servers" />" help-text="'<cv:msg key='label.applicationIdHelpText' bundle='servers' />'"/>
			</label>
			<div class="col-sm-7 col-xs-7">
				<input type="text" id="applicationId" name="applicationId" data-ng-model="credentialReq.additionalInformation.azureCredInfo.applicationId" data-ng-change="helpText.applicationId=false;" autofocus required />
				<span class="help-block" data-ng-show="helpText.applicationId"><cv:msg key="error.applicationId" bundle="servers" /></span>
			</div>
		</div>
		<div class="form-group" data-ng-if="azure.azureADAccount">
			<label for="applicationPassword" class="col-sm-5 col-xs-5" >
				<cv:msg key="label.applicationSecret" bundle="servers" />
			</label>
			<div class="col-sm-7 col-xs-7">
				<input type="password" id="applicationPassword" name="applicationPassword" data-ng-model="azure.appPassword" placeholder='{{ editMode ? "<cv:msg key="placeholder.editUserPassword" bundle="users" />" : "" }}' data-ng-change="helpText.appPassword=false;" autofocus/>
				<span class="help-block" data-ng-show="helpText.appPassword"><cv:msg key="error.applicationSecret" bundle="servers" /></span>
			</div>
		</div>
		<div class="form-group" data-ng-if="(editMode || showInputs) && cloudAccount && azure.azureADAccount">
			<label for="environmentList" class="col-sm-5 col-xs-5">
				<cv-help-text help-label="<cv:msg key="label.environment" bundle="servers" />" help-text="'<cv:msg key='label.environmentHelpText' bundle='servers' />'"/>
			</label>
			<div class="col-sm-7 col-xs-7" data-ng-if="environmentList.length" data-ng-disabled="editMode">
				<isteven-multi-select
					directive-id="environmentList"
					input-model="environmentList"
					output-model="azure.environment"
					button-label="name"
					item-label="name"
					id="environmentList"
					tick-property="selected"
					class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
					helper-elements="filter"
					selection-mode="single"
					on-item-click="changeEnvironment(data)"
					search-property="name"
				>
				</isteven-multi-select>
				<span class="help-block" data-ng-show="helpText.environment"><cv:msg key="error.environment" bundle="servers"/></span>
			</div>
		</div>
		<div class="form-group margin-0">
			<div class="col-xs-12 offset-md-5 offset-lg-5" style="text-align: center;">
				<small data-ng-click="showEndpoints()" data-ng-if="azure.azureADAccount">
					<a href=""><cv:msg key="label.showEndpoints" bundle="servers" /></a>
			   </small>
			</div>
		</div>
		<div class="form-group" data-ng-if="azure.azureADAccount && showEndpoint">
			<label for="authenticationEndpoint" class="col-sm-5 col-xs-5" >
				<cv:msg key="label.authenticationEndpoint" bundle="servers" />
			</label>
			<div class="col-sm-7 col-xs-7">
				<input type="text" id="authenticationEndpoint" name="authenticationEndpoint" data-ng-model="credentialReq.additionalInformation.azureCredInfo.endpoints.activeDirectoryEndpoint" data-ng-change="helpText.authenticationEndpoint=false;" autofocus required />
				<span class="help-block" data-ng-show="helpText.authenticationEndpoint"><cv:msg key="error.authenticationEndpoint" bundle="servers" /></span>
			</div>
		</div>
		<div class="form-group" data-ng-if="azure.azureADAccount && showEndpoint">
			<label for="storageEndpoint" class="col-sm-5 col-xs-5" >
				<cv:msg key="label.storageEndpoint" bundle="servers" />
			</label>
			<div class="col-sm-7 col-xs-7">
				<input type="text" id="storageEndpoint" name="storageEndpoint" data-ng-model="credentialReq.additionalInformation.azureCredInfo.endpoints.storageEndpoint" data-ng-change="helpText.storageEndpoint=false;" autofocus required />
				<span class="help-block" data-ng-show="helpText.storageEndpoint"><cv:msg key="error.storageEndpoint" bundle="servers" /></span>
			</div>
		</div>
		<div class="form-group" data-ng-if="azure.azureADAccount && showEndpoint">
			<label for="managementEndpoint" class="col-sm-5 col-xs-5" >
				<cv:msg key="label.managementEndpoint" bundle="servers" />
			</label>
			<div class="col-sm-7 col-xs-7">
				<input type="text" id="managementEndpoint" name="managementEndpoint" data-ng-model="credentialReq.additionalInformation.azureCredInfo.endpoints.resourceManagerEndpoint" data-ng-change="helpText.managementEndpoint=false;" autofocus required />
				<span class="help-block" data-ng-show="helpText.managementEndpoint"><cv:msg key="error.managementEndpoint" bundle="servers" /></span>
			</div>
		</div>
		<div class="form-group" data-ng-if="editMode || showInputs">
			<div class="col-sm-5 col-xs-5">
				<label for="description"><cv:msg key="label.description" bundle="archiving"/></label>
			</div>
			<div class="col-sm-7 col-xs-7">
				<input type="text" id="description" name="description" data-ng-model="credentialReq.description" autofocus/>
			</div>
		</div>
		<div class="form-group" data-ng-if="editMode || showInputs">
			<uib-accordion close-others="true" class="text-left">
				<div uib-accordion-group data-is-open="accordion1.open">
					<uib-accordion-heading>
						<cv:msg key="label.security" bundle="snapArray"/>
						<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': accordion1.open, 'glyphicon-chevron-right': !accordion1.open}"></i>
					</uib-accordion-heading>
					<div class="form-group">
						<div class="col-sm-5 col-xs-5">
							<label for="createAs"><cv:msg key="label.owner" bundle="users"/></label>
						</div>
						<div class="col-sm-7 col-xs-7">
							<cv-select-2 id='createAs' search-options="searchConfigOwner" output-model="selectedOwner"></cv-select-2>
							<span class="help-block" data-ng-show="helpText.createAs"><cv:msg key="error.owner" bundle="users" /></span>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-5 col-xs-5"><cv:msg key="label.userOrGroupName" bundle="users" /></label>
						<div class="col-sm-7 col-xs-7">
							<cv-select-2 id='userAccess' search-options="searchConfig" output-model="selectedUserAndGroup"></cv-select-2>
						</div>
					</div>
				</div>
			</uib-accordion>
		</div>
		<div class="button-container">
			<button id="addEditCredentialManager_button_#9942" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages" /></button>
			<button id="addEditCredentialManager_button_#4428" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages" /></button>
		</div>
	</form>
</div>
