export const getColumnTemplate = function(angularLibs) {
	const columnList = [
		getCredentialName(angularLibs.cvLoc),
		getRecordType(angularLibs.cvLoc),
		getDescription(angularLibs.cvLoc),
		getActionsColumn(angularLibs.cvLoc)
	];
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};
export const getCredentialName = cvLoc => {
	return {
		'credentialRecord.credentialName': {
			title: cvLoc('label.credential'),
			template: '<a class="crop k-grid-keyDetail">#:credentialRecord.credentialName#</a>',
			sortType: 'string'
		}
	};
};
export const getRecordType = cvLoc => {
	return {
		recordType: {
			title: cvLoc('label.type'),
			template:
				'<div class="crop" title="#:recordTypeFormatted#">#:recordTypeFormatted ? recordTypeFormatted : ""#</div>'
		}
	};
};
export const getDescription = cvLoc => {
	return {
		description: {
			title: cvLoc('label.description'),
			width: '30%',
			template: '<div class="crop" title="#:description#">#:description ? description : ""#</div>'
		}
	};
};
export const getActionsColumn = function(cvLoc) {
	return {
		action: {
			title: cvLoc('label.actions'),
			type: 'string',
			template: `<div class="permittedActions"></div>`,
			disableViewFiltering: true,
			sortable: false,
			disableColumnFilter: true,
			width: '15%',
			attributes: {
				class: 'permitted-actions'
			}
		}
	};
};
