import 'credentialManager/js/services/credentialManager.svc.js';
import 'credentialManager/js/constants/credentialManager.constant.js';
import 'adminConsole/js/services/security.svc.js';
import 'credentialManager/js/factory/credentialManager.factory.js';

import { acAppcredentialManagerModule } from 'common/js/modules';

var credentialManagerModule = acAppcredentialManagerModule;
var controllers = {};

controllers.credentialManagerCreateController = [
	'$scope',
	'$state',
	'$uibModalInstance',
	'cvLoc',
	'cvToaster',
	'credentialManagerService',
	'cvUtil',
	'CREDENTIAL_TYPE',
	'CREDENTIAL_TYPE_BASE',
	'cancelReloadApp',
	'AccountTypeId',
	'showInputs',
	'accountTypes',
	'credentialManagerFactory',
	'AMAZON_AUTH_TYPE',
	'AZURE_AUTH_TYPE',
	'CLOUD_VENDOR_TYPE',
	function(
		$scope,
		$state,
		$modalInstance,
		cvLoc,
		cvToaster,
		credentialManagerService,
		cvUtil,
		CREDENTIAL_TYPE,
		CREDENTIAL_TYPE_BASE,
		cancelReloadApp,
		AccountTypeId,
		showInputs,
		accountTypes,
		credentialManagerFactory,
		AMAZON_AUTH_TYPE,
		AZURE_AUTH_TYPE,
		CLOUD_VENDOR_TYPE
	) {
		$scope.editMode = false;
		$scope.cred = {};
		$scope.azure = {};
		$scope.azure.azureADAccount = false;
		$scope.vmRole = false;

		$scope.azureADAccountID = 4;

		$scope.credentialReq = credentialManagerFactory.initCredentialReq();
		$scope.serverMessage = cvUtil.emptyMsg();
		$scope.showInputs = showInputs;
		$scope.dummy = {};
		$scope.accordion1 = {
			open: true
		};
		$scope.hideCloudInputs = false;
		$scope.cloudAccount = false;
		$scope.recordTypeList = [];
		$scope.vendorTypeList = [];
		$scope.authenticationTypeList = [];
		$scope.environmentList = credentialManagerFactory.populateEnvironment();
		$scope.azure.environment = [];
		$scope.disableAuthType = true;
		$scope.dummyStr = 'DUMMY';
		$scope.disableAuthType = true;
		$scope.vendorSelection = {
			vendorType: [{ value: '' }]
		};
		$scope.vendorSelection = {
			authType: [{ value: '' }]
		};
		$scope.helpText = {};
		$scope.userNameError = '';
		$scope.passwordError = '';

		$scope.userAndUserGroupsList = [];
		$scope.userNameLabel = 'label.userName';
		$scope.passwordLabel = 'label.password';

		$scope.helpText.createAs = false;

		$scope.accountTypeId = AccountTypeId;
		$scope.authTypeId = 0;
		$scope.accountTypes = accountTypes;

		credentialManagerFactory
			.populateRecordTypeList($scope.editMode, $scope.credentialReq, $scope.accountTypeId, $scope.accountTypes)
			.then(recTypeList => {
				$scope.recordTypeList = recTypeList;

				if ($scope.accountTypeId === CREDENTIAL_TYPE.STORAGE_ARRAY_ACCOUNT) {
					$scope.disableList = true;
				} else {
					$scope.changeEnvironment($scope.environmentList[0]);
					credentialManagerFactory
						.populateCloudVendorTypeList(
							$scope.editMode,
							$scope.credentialReq,
							$scope.vendorSelection,
							$scope.accountTypeId
						)
						.then(cloudVendorList => {
							$scope.vendorTypeList = cloudVendorList;
							$scope.disableList = false;
							if ($scope.accountTypeId) {
								$scope.initializeInputs();
							}
						});
				}
			});

		$scope.credAcctTypeTranslation = credentialManagerService.getCredentialTypePlaceholder();

		$scope.cloudVendorTypeTranslation = credentialManagerService.getCloudVendorTypePlaceholder();

		$scope.cancel = function() {
			$modalInstance.dismiss();
		};

		$scope.addNewCredentials = function() {
			let credentialReq = angular.copy($scope.credentialReq);
			let validationResult = credentialManagerFactory.validate(
				credentialReq,
				$scope.cloudAccount,
				$scope.vendorSelection,
				$scope.helpText,
				$scope.accordion1,
				$scope.cred.password,
				$scope.azure.appPassword
			);
			if (!validationResult.isValid) {
				$scope.passwordError = validationResult.passwordError;
				$scope.userNameError = validationResult.userNameError;
				return;
			}

			var isAzureADAccount =
				$scope.cloudAccount &&
				$scope.vendorSelection.vendorType[0].value === 'MICROSOFT_AZURE_TYPE' &&
				$scope.vendorSelection.authType[0].value === 'AZUREACCOUNT';
			if (isAzureADAccount) {
				let azureValidation = credentialManagerFactory.azureAccountValidate(
					credentialReq,
					$scope.azure.environment,
					$scope.helpText,
					$scope.azure.appPassword
				);

				if (!azureValidation.isValid) {
					return;
				}
			}

			if (_.has(credentialReq, 'createAs.userGroup.userGroupId')) {
				delete credentialReq.createAs.user.user;
			}
			if (_.has(credentialReq, 'createAs.user.user.userId')) {
				delete credentialReq.createAs.userGroup;
			}
			$scope.serverMessage = cvUtil.infoMsgLoc('Loading');
			if (isAzureADAccount) {
				credentialReq.record.password = cvUtil.getBytes($scope.azure.appPassword);
				credentialReq.record.userName = credentialReq.additionalInformation.azureCredInfo.applicationId;
				credentialReq.additionalInformation.azureCredInfo.environment = $scope.azure.environment[0].name;
			} else if ($scope.vendorSelection.authType[0].value === 'AMAZON_STS_IAM_ROLE') {
				//send Dummy string for password, username will have role ARN
				$scope.credentialReq.record.password = cvUtil.getBytes($scope.dummyStr);
			} else {
				credentialReq.record.password = cvUtil.getBytes($scope.cred.password);
			}
			credentialManagerService.setCredentialRecType(credentialReq, $scope.vendorSelection);
			credentialManagerService.addCredentialRecord(credentialReq).then(
				function(result) {
					$scope.credentialId = result.data;
					$scope.serverMessage = cvUtil.emptyMsg();
					$modalInstance.dismiss({
						msg: 'createSucessful',
						name: $scope.credentialReq.credentialRecord.credentialName
					});
					!cancelReloadApp && $state.forceReload();
				},
				function(error) {
					$scope.serverMessage = cvUtil.errMsg(error.data);
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: error.data
					});
				}
			);
		};

		$scope.changeUserPasswordLabels = function(data) {
			$scope.helpText.recordType = false;
			$scope.helpText.vendorType = false;
			$scope.azure.azureADAccount = data.value === 'AZUREACCOUNT';
			$scope.showRoleARN = data.value === 'AMAZON_STS_IAM_ROLE';
			$scope.vmRole = data.value === 'AMAZON_STS_IAM_ROLE';

			if (!$scope.azure.azureADAccount) {
				let userPasswordLabels = credentialManagerService.getRecTypeLabels(data.value);
				$scope.userNameLabel = userPasswordLabels.userNameLabel;
				$scope.passwordLabel = userPasswordLabels.passwordLabel;
			}

			$scope.credentialReq.record.userName = '';
			$scope.cred.password = '';
			$scope.azure.appPassword = ''; // used for azureADAccount
		};

		$scope.showEndpoint = false;

		$scope.showEndpoints = () => {
			$scope.showEndpoint = !$scope.showEndpoint;
		};

		$scope.changeEnvironment = function(data) {
			$scope.credentialReq.additionalInformation.azureCredInfo.endpoints.storageEndpoint = credentialManagerService.getStorageEndpoint(
				data
			);
			$scope.credentialReq.additionalInformation.azureCredInfo.endpoints.resourceManagerEndpoint = credentialManagerService.getManagementEndpoint(
				data
			);
			$scope.credentialReq.additionalInformation.azureCredInfo.endpoints.activeDirectoryEndpoint = credentialManagerService.getAuthenticationEndpoint(
				data
			);
			$scope.helpText.environment = false;
			$scope.helpText.authenticationEndpoint = false;
			$scope.helpText.storageEndpoint = false;
			$scope.helpText.managementEndpoint = false;
		};

		$scope.setCloudAccountInputs = function(data) {
			if (data.value == 'CLOUD_ACCOUNT') {
				$scope.cloudAccount = true;
				if (
					!$scope.vendorSelection.vendorType ||
					$scope.vendorSelection.vendorType.length === 0 ||
					$scope.vendorSelection.vendorType[0].value === ''
				) {
					$scope.changeUserPasswordLabels($scope.vendorTypeList[0]);
				} else {
					$scope.changeUserPasswordLabels($scope.vendorSelection.vendorType[0]);
				}
			} else {
				$scope.azure.azureADAccount = false;
				$scope.cloudAccount = false;
				$scope.showAuthType = false;
				$scope.changeUserPasswordLabels(data);
			}
		};
		$scope.initializeInputs = function() {
			$scope.disableAuthType = true;
			$scope.showAuthType = false;
			$scope.disableList = true;
			if (
				$scope.accountTypeId === CLOUD_VENDOR_TYPE.AMAZON ||
				$scope.accountTypeId === CLOUD_VENDOR_TYPE.MICROSOFT_AZURE_TYPE
			) {
				$scope.disableAuthType = false;
			} else if (
				$scope.accountTypeId === AMAZON_AUTH_TYPE.AMAZON_S3 ||
				$scope.accountTypeId === AMAZON_AUTH_TYPE.AMAZON_STS_IAM_ROLE
			) {
				$scope.showAuthType = true;
				$scope.disableAuthType = true;
				$scope.authTypeId = $scope.accountTypeId;
				$scope.accountTypeId = CLOUD_VENDOR_TYPE.AMAZON;
			} else if (
				$scope.accountTypeId === AZURE_AUTH_TYPE.AZUREACCOUNT ||
				$scope.accountTypeId === AZURE_AUTH_TYPE.MICROSOFT_AZURE
			) {
				$scope.showRoleARN = false;
				$scope.disableAuthType = true;
				$scope.authTypeId = $scope.accountTypeId;
				$scope.accountTypeId = CLOUD_VENDOR_TYPE.MICROSOFT_AZURE_TYPE;
			}

			if (
				$scope.accountTypeId > CREDENTIAL_TYPE_BASE['CLOUD'] ||
				$scope.accountTypeId === $scope.azureADAccountID ||
				$scope.accountTypeId === CLOUD_VENDOR_TYPE.AMAZON ||
				$scope.accountTypeId === AMAZON_AUTH_TYPE.AMAZON_STS_IAM_ROLE ||
				$scope.accountTypeId === CLOUD_VENDOR_TYPE.MICROSOFT_AZURE_TYPE ||
				$scope.accountTypeId === CLOUD_VENDOR_TYPE.SALESFORCE_CONNECTED_APP
			) {
				$scope.cloudAccount = true;
				$scope.hideCloudInputs = true;
				let selectedIndex = 0;
				if (
					$scope.accountTypeId === CLOUD_VENDOR_TYPE.AMAZON ||
					$scope.accountTypeId === CLOUD_VENDOR_TYPE.MICROSOFT_AZURE_TYPE
				) {
					$scope.showAuthType = true;
					if (!$scope.disableAuthType) {
						//For Storage Accelerator show cloud inputs
						$scope.hideCloudInputs = false;
					}
					credentialManagerFactory
						.populateAuthTypeList(
							$scope.editMode,
							$scope.credentialReq,
							$scope.accountTypeId,
							$scope.authTypeId,
							$scope.accountTypes
						)
						.then(authTypeList => {
							$scope.authenticationTypeList = authTypeList;
							$scope.authenticationTypeList.forEach(function(item, index) {
								if (item.selected) {
									selectedIndex = index;
									$scope.vendorSelection.authType[0] = item;
								}
							});
							$scope.changeUserPasswordLabels($scope.authenticationTypeList[selectedIndex]);
						});
				} else {
					$scope.vendorTypeList.forEach(function(item, index) {
						if (item.selected) {
							selectedIndex = index;
						}
					});
					$scope.changeUserPasswordLabels($scope.vendorTypeList[selectedIndex]);
				}
			}
		};
		$scope.setVendorTypeInputs = function(data) {
			if (data.value === 'AMAZON' || data.value === 'MICROSOFT_AZURE_TYPE') {
				$scope.authTypeId = AMAZON_AUTH_TYPE.AMAZON_S3;
				$scope.showAuthType = true;
				if (data.value === 'MICROSOFT_AZURE_TYPE') {
					$scope.authTypeId = AZURE_AUTH_TYPE.AZUREACCOUNT;
				}
				credentialManagerFactory
					.populateAuthTypeList(
						$scope.editMode,
						$scope.credentialReq,
						CLOUD_VENDOR_TYPE[data.value],
						$scope.authTypeId,
						$scope.accountTypes
					)
					.then(authTypeList => {
						$scope.authenticationTypeList = authTypeList;
						let selectedIndex = 0;
						$scope.authenticationTypeList.forEach(function(item, index) {
							if (item.selected) {
								selectedIndex = index;
							}
						});
						$scope.authTypeId = $scope.authenticationTypeList[selectedIndex].value;
						$scope.changeUserPasswordLabels($scope.authenticationTypeList[selectedIndex]);
					});
			} else {
				$scope.azure.azureADAccount = false;
				$scope.showAuthType = false;
				$scope.changeUserPasswordLabels(data);
			}
		};

		if (cv.sessionContext && _.isNil(cv.sessionContext.operatorCompanyId)) {
			$scope.selectedOwner = credentialManagerFactory.setupOwner($scope.credentialReq, $scope.userAndUserGroupsList);
		}

		$scope.addOwner = function(data) {
			$scope.helpText.createAs = false;
			credentialManagerFactory.addSelectedUserOrGroupOwner($scope.credentialReq, $scope.userAndUserGroupsList, data);
		};

		$scope.addUserAndGroupSelected = function(value) {
			credentialManagerFactory.addUserAndGroupSelected(
				$scope.credentialReq,
				$scope.userAndUserGroupsList,
				$scope.selectedOwner,
				value
			);
		};

		$scope.updateSelectedUserOrGroupOnDelete = function(value) {
			credentialManagerFactory.updateSelectedUserOrGroupOnDelete(
				$scope.credentialReq,
				$scope.userAndUserGroupsList,
				value
			);
		};

		//Owner
		$scope.searchConfigOwner = {
			placeholder: 'placeholder.enterOwner',
			httpConfig: {
				method: 'GET',
				url: 'getUserSuggestionsListPlan.do',
				params: {
					getDomainGroups: false,
					getDomainUsers: false
				}
			},
			payloadPath: 'params.term',
			onSelect: data => {
				$scope.addOwner(data);
			},
			iconClass: entity => {
				switch (entity.userInfo.userType) {
					case 'EXTERNAL_GROUP':
					case 'COMMCELL_GROUP':
						return 'k-i-myspace';
					case 'USER':
						return 'k-i-user';
					default:
						return 'k-i-user';
				}
			}
		};

		//User/Group
		$scope.searchConfig = {
			placeholder: 'placeholder.enterUsersOrGroups',
			httpConfig: {
				method: 'GET',
				url: 'getUserSuggestionsListPlan.do',
				params: {
					getDomainGroups: false,
					getDomainUsers: false
				}
			},
			payloadPath: 'params.term',
			multiSelectionEnabled: true,
			onSelect: value => {
				$scope.addUserAndGroupSelected(value);
				if ($scope.searchConfig.multiSelectionEnabled === true) {
					$scope.searchConfig.placeholder = 'placeholder.reSearch';
				}
			},
			onDelete: value => {
				$scope.updateSelectedUserOrGroupOnDelete(value);
			},
			iconClass: entity => {
				switch (entity.userInfo.userType) {
					case 'EXTERNAL_GROUP':
					case 'COMMCELL_GROUP':
						return 'k-i-myspace';
					case 'USER':
						return 'k-i-user';
					default:
						return 'k-i-user';
				}
			}
		};
	}
];

controllers.credentialManagerEditController = [
	'$scope',
	'$state',
	'$uibModalInstance',
	'cvLoc',
	'cvToaster',
	'credentialManagerService',
	'cvUtil',
	'CREDENTIAL_TYPE',
	'credentialManagerFactory',
	'CREDENTIAL_TYPE_BASE',
	'credentialEntity',
	'CLOUD_VENDOR_TYPE',
	'cancelReloadApp',
	'CREDENTIAL_PROPERTY_LEVEL',
	'AMAZON_AUTH_TYPE',
	'AZURE_AUTH_TYPE',
	'fromCredListPage',
	function(
		$scope,
		$state,
		$modalInstance,
		cvLoc,
		cvToaster,
		credentialManagerService,
		cvUtil,
		CREDENTIAL_TYPE,
		credentialManagerFactory,
		CREDENTIAL_TYPE_BASE,
		credentialEntity,
		CLOUD_VENDOR_TYPE,
		cancelReloadApp,
		CREDENTIAL_PROPERTY_LEVEL,
		AMAZON_AUTH_TYPE,
		AZURE_AUTH_TYPE,
		fromCredListPage
	) {
		$scope.editMode = true;
		$scope.hideCloudInputs = !fromCredListPage;
		$scope.azureADAccountID = 4;
		$scope.cred = {};
		$scope.vendorSelection = {
			vendorType: [{ value: '' }]
		};
		$scope.vendorSelection = {
			authType: [{ value: '' }]
		};
		$scope.accordion1 = {
			open: false
		};

		$scope.cloudAccount = false;
		$scope.showAuthType = false;
		$scope.vmRole = false;
		$scope.credAcctTypeTranslation = credentialManagerService.getCredentialTypePlaceholder();
		$scope.cloudVendorTypeTranslation = credentialManagerService.getCloudVendorTypePlaceholder();
		$scope.recordTypeList = [];
		$scope.vendorTypeList = [];
		$scope.userAndUserGroupsList = [];
		$scope.selectedUserAndGroup = [];
		$scope.userGroupsList = [];
		$scope.usersList = [];
		$scope.selectedOwner = {};
		$scope.azure = {};
		$scope.environmentList = credentialManagerFactory.populateEnvironment();
		$scope.azure.environment = [];
		$scope.userNameLabel = 'label.userName';
		$scope.passwordLabel = 'label.password';
		$scope.showRoleARN = false;
		$scope.helpText = {};
		$scope.credentialReq = credentialManagerFactory.initCredentialReq();

		credentialManagerService
			.getCredentialRecord(CREDENTIAL_PROPERTY_LEVEL.DETAILED, 0, credentialEntity.credentialName)
			.then(function(result) {
				let credEntity = result.data[0];
				$scope.credentialReq.credentialRecord = {
					credentialId: credEntity.credentialRecord.credentialId,
					credentialName: credEntity.credentialRecord.credentialName
				};
				$scope.credentialReq.record = {
					userName: _.get(credEntity, 'record.userName')
				};
				$scope.credentialReq.recordType = credEntity.recordType;
				$scope.credentialReq.description = credEntity.description;
				$scope.initializeForEdit(credEntity);

				$scope.selectedAssocGroups = _.filter(
					_.get(credEntity, 'securityAssociations.associations'),
					'userOrGroup[0].userGroupId'
				);
				$scope.selectedAssocGroups = _.concat(
					$scope.selectedAssocGroups,
					_.filter(_.get(credEntity, 'securityAssociations.associations'), 'userOrGroup[0].groupId')
				);
				$scope.selectedAssocUsers = _.filter(
					_.get(credEntity, 'securityAssociations.associations'),
					'userOrGroup[0].userId'
				);

				if (_.has(credEntity, 'createAs.user.user.userId')) {
					$scope.credentialReq.createAs.user.user.userName = credEntity.createAs.user.user.userName;
					$scope.credentialReq.createAs.user.user.userId = credEntity.createAs.user.user.userId;
					$scope.credentialReq.createAs.userGroup = {};
				} else if (_.has(credEntity, 'createAs.userGroup.userGroupId')) {
					$scope.credentialReq.createAs.userGroup.userGroupName = credEntity.createAs.userGroup.userGroupName;
					$scope.credentialReq.createAs.userGroup.userGroupId = credEntity.createAs.userGroup.userGroupId;
					$scope.credentialReq.createAs.user.user = {};
				}

				credentialManagerFactory
					.populateRecordTypeList($scope.editMode, $scope.credentialReq, $scope.accountTypeId, null)
					.then(recTypeList => {
						$scope.recordTypeList = recTypeList;
						credentialManagerFactory
							.populateCloudVendorTypeList(
								$scope.editMode,
								$scope.credentialReq,
								$scope.vendorSelection,
								$scope.accountTypeId
							)
							.then(cloudVendorList => {
								$scope.vendorTypeList = cloudVendorList;
								if (
									$scope.accountTypeId > CREDENTIAL_TYPE_BASE['CLOUD'] ||
									$scope.accountTypeId === $scope.azureADAccountID ||
									$scope.accountTypeId === CLOUD_VENDOR_TYPE.AMAZON ||
									$scope.accountTypeId === CLOUD_VENDOR_TYPE.MICROSOFT_AZURE_TYPE ||
									$scope.accountTypeId === CLOUD_VENDOR_TYPE.SALESFORCE_CONNECTED_APP
								) {
									$scope.cloudAccount = true;
								} else {
									//For non cloud credentials
									$scope.hideCloudInputs = false;
								}
							});
						credentialManagerFactory
							.populateAuthTypeList(
								$scope.editMode,
								$scope.credentialReq,
								$scope.accountTypeId,
								$scope.authTypeId,
								$scope.accountTypes
							)
							.then(authTypeList => {
								$scope.authenticationTypeList = authTypeList;
							});
					});

				let userOwnerList = credentialManagerFactory.populateUserGroups(
					$scope.editMode,
					$scope.selectedAssocGroups,
					$scope.selectedAssocUsers
				);
				$scope.selectedOwner = userOwnerList[0];
				$scope.selectedUserAndGroup = userOwnerList[1];
				$scope.userAndUserGroupsList = userOwnerList[2];
				$scope.credentialReq.securityAssociations.associations = userOwnerList[3];
			});
		$scope.showEndpoint = false;

		$scope.showEndpoints = () => {
			$scope.showEndpoint = !$scope.showEndpoint;
		};

		$scope.addOwner = function(data) {
			$scope.helpText.createAs = false;
			credentialManagerFactory.addSelectedUserOrGroupOwner($scope.credentialReq, $scope.userAndUserGroupsList, data);
		};

		$scope.addUserAndGroupSelected = function(value) {
			credentialManagerFactory.addUserAndGroupSelected(
				$scope.credentialReq,
				$scope.userAndUserGroupsList,
				$scope.selectedOwner,
				value
			);
		};

		$scope.updateSelectedUserOrGroupOnDelete = function(value) {
			credentialManagerFactory.updateSelectedUserOrGroupOnDelete(
				$scope.credentialReq,
				$scope.userAndUserGroupsList,
				value
			);
		};

		$scope.initializeForEdit = function(credEntity) {
			let cloudVendorTypes = credentialManagerFactory.getCloudVendorTypes();
			$scope.cloudAccount = true;
			$scope.showAuthType = false;

			let amazonTypes = credentialManagerFactory.getAmazonAuthTypes();
			if (amazonTypes.includes(credEntity.recordType)) {
				$scope.accountTypeId = CLOUD_VENDOR_TYPE['AMAZON'];
				$scope.showAuthType = true;
				$scope.authTypeId = AMAZON_AUTH_TYPE[credEntity.recordType];
				$scope.showRoleARN = $scope.authTypeId === AMAZON_AUTH_TYPE.AMAZON_STS_IAM_ROLE;
				$scope.vmRole = $scope.authTypeId === AMAZON_AUTH_TYPE.AMAZON_STS_IAM_ROLE;
			} else if (credentialManagerFactory.getAzureAuthTypes().includes(credEntity.recordType)) {
				$scope.accountTypeId = CLOUD_VENDOR_TYPE['MICROSOFT_AZURE_TYPE'];
				$scope.showAuthType = true;
				$scope.authTypeId = AZURE_AUTH_TYPE[credEntity.recordType];
				$scope.vmRole = $scope.authTypeId === AZURE_AUTH_TYPE.AZUREACCOUNT;
			} else if (cloudVendorTypes.includes(credEntity.recordType)) {
				$scope.accountTypeId = CLOUD_VENDOR_TYPE[credEntity.recordType];
			} else {
				$scope.accountTypeId = CREDENTIAL_TYPE[credEntity.recordType];
				$scope.cloudAccount = false;
			}
			if ($scope.authTypeId === $scope.azureADAccountID) {
				var selectedEnvironment = credEntity.additionalInformation.azureCredInfo.environment;
				$scope.azure.environment = credentialManagerFactory.getEnvironment(selectedEnvironment);
				$scope.environmentList.forEach(environment => {
					if (typeof selectedEnvironment != 'undefined' && selectedEnvironment == environment.name) {
						environment.selected = true;
					}
				});

				$scope.azure.azureADAccount = true;
				$scope.azure.appPassword = '';
				$scope.credentialReq.additionalInformation.azureCredInfo.tenantId =
					credEntity.additionalInformation.azureCredInfo.tenantId;
				$scope.credentialReq.additionalInformation.azureCredInfo.applicationId =
					credEntity.additionalInformation.azureCredInfo.applicationId;
				$scope.credentialReq.additionalInformation.azureCredInfo.endpoints.resourceManagerEndpoint =
					credEntity.additionalInformation.azureCredInfo.endpoints.resourceManagerEndpoint;
				$scope.credentialReq.additionalInformation.azureCredInfo.endpoints.activeDirectoryEndpoint =
					credEntity.additionalInformation.azureCredInfo.endpoints.activeDirectoryEndpoint;
				$scope.credentialReq.additionalInformation.azureCredInfo.endpoints.storageEndpoint =
					credEntity.additionalInformation.azureCredInfo.endpoints.storageEndpoint;
			} else {
				let userPasswordLabels = credentialManagerService.getRecTypeLabels($scope.credentialReq.recordType);
				$scope.userNameLabel = userPasswordLabels.userNameLabel;
				$scope.passwordLabel = userPasswordLabels.passwordLabel;
			}
		};
		//Owner
		$scope.searchConfigOwner = {
			placeholder: 'placeholder.enterOwner',
			httpConfig: {
				method: 'GET',
				url: 'getUserSuggestionsListPlan.do',
				params: {
					getDomainGroups: false,
					getDomainUsers: false
				}
			},
			payloadPath: 'params.term',
			onSelect: data => {
				$scope.addOwner(data);
			},
			iconClass: entity => {
				switch (entity.userInfo.userType) {
					case 'EXTERNAL_GROUP':
					case 'COMMCELL_GROUP':
						return 'k-i-myspace';
					case 'USER':
						return 'k-i-user';
					default:
						return 'k-i-user';
				}
			}
		};

		//User/Group
		$scope.searchConfig = {
			placeholder: 'placeholder.enterUsersOrGroups',
			httpConfig: {
				method: 'GET',
				url: 'getUserSuggestionsListPlan.do',
				params: {
					getDomainGroups: false,
					getDomainUsers: false
				}
			},
			payloadPath: 'params.term',
			multiSelectionEnabled: true,
			onSelect: value => {
				$scope.addUserAndGroupSelected(value);
				if ($scope.searchConfig.multiSelectionEnabled === true) {
					$scope.searchConfig.placeholder = 'placeholder.reSearch';
				}
			},
			onDelete: value => {
				$scope.updateSelectedUserOrGroupOnDelete(value);
			},
			iconClass: entity => {
				switch (entity.userInfo.userType) {
					case 'EXTERNAL_GROUP':
					case 'COMMCELL_GROUP':
						return 'k-i-myspace';
					case 'USER':
						return 'k-i-user';
					default:
						return 'k-i-user';
				}
			}
		};

		$scope.cancel = function() {
			$modalInstance.dismiss();
		};

		$scope.addNewCredentials = function() {
			let validationResult = credentialManagerFactory.validate(
				$scope.credentialReq,
				$scope.cloudAccount,
				$scope.vendorSelection,
				$scope.helpText,
				$scope.accordion1,
				$scope.cred.password,
				$scope.azure.appPassword,
				true
			);
			if (!validationResult.isValid) {
				$scope.passwordError = validationResult.passwordError;
				$scope.userNameError = validationResult.userNameError;
				return;
			}

			if (_.has($scope.credentialReq, 'createAs.userGroup.userGroupId')) {
				delete $scope.credentialReq.createAs.user.user;
			}

			if (_.has($scope.credentialReq, 'createAs.user.user.userId')) {
				delete $scope.credentialReq.createAs.userGroup;
			}

			$scope.serverMessage = cvUtil.infoMsgLoc('Loading');
			if ($scope.azure.azureADAccount) {
				$scope.credentialReq.record.password = cvUtil.getBytes($scope.azure.appPassword);
				$scope.credentialReq.record.userName = $scope.credentialReq.additionalInformation.azureCredInfo.applicationId;
				$scope.credentialReq.additionalInformation.azureCredInfo.environment = $scope.azure.environment[0].name;
			} else if ($scope.vendorSelection.authType[0].value === 'AMAZON_STS_IAM_ROLE') {
				//send Dummy string for password, username will have role ARN
				$scope.credentialReq.record.password = cvUtil.getBytes($scope.dummyStr);
			} else {
				$scope.credentialReq.record.password = cvUtil.getBytes($scope.cred.password);
				$scope.credentialReq.record.confirmPassword = cvUtil.getBytes($scope.confirmPassword);
			}

			credentialManagerService.setCredentialRecType($scope.credentialReq, $scope.vendorSelection);
			credentialManagerService.editCredentialRecord($scope.credentialReq).then(
				function(result) {
					$scope.credentialId = result.data;
					$scope.serverMessage = cvUtil.emptyMsg();
					cvToaster.showInfoMessage({
						ttl: '10000', //10 sec
						message: 'Record updated. '
					});
					$modalInstance.dismiss({ msg: 'editSucessful', name: $scope.credentialReq.credentialRecord.credentialName });
					!cancelReloadApp && $state.forceReload();
				},
				function(error) {
					$scope.serverMessage = cvUtil.errMsg(error.data);
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: error.data
					});
					$modalInstance.dismiss();
				}
			);
		};
	}
];

credentialManagerModule.controller(controllers);

export default credentialManagerModule;
