import { acAppcredentialManagerModule } from 'common/js/modules';

export const credentialType = acAppcredentialManagerModule.constant('CREDENTIAL_TYPE', {
	WINDOWSACCOUNT: 1,
	LINUXACCOUNT: 2,
	SSHACCOUNT: 3,
	VMWAREACCOUNT: 5,
	ORACLEACCOUNT: 6,
	HYPERVACCOUNT: 7,
	STORAGE_ARRAY_ACCOUNT: 10,
	CLOUD_ACCOUNT: 11
});

export const cloudVendorType = acAppcredentialManagerModule.constant('CLOUD_VENDOR_TYPE', {
	AMAZON: 13,
	MICROSOFT_AZURE_TYPE: 17,
	RACKSPACE_CLOUD_FILES: 105,
	EMC_ATMOS: 109,
	ATT_SYNAPTIC: 110,
	HDS_HCP: 112,
	OPENSTACK: 114,
	AMPLIDATA: 115,
	CMCC_ONEST: 116,
	VERIZON_CLOUD: 118,
	GOOGLE_CLOUD: 119,
	ALICLOUD_OSS: 123,
	HUAWEI_OSS: 124,
	TELEFONICA_OPEN_CLOUD_OBJECT_STORAGE: 127,
	INSPUR_CLOUD: 129,
	IBM_CLOUD: 130,
	KINGSOFT_KS3: 132,
	IRON_MOUNTAIN_CLOUD: 134,
	S3_COMPATIBLE: 140,
	AMAZON_GLACIER: 153,
	CEPH_OBJECT_GATEWAY_S3: 300,
	CLOUDIAN_HYPERSTORE: 301,
	DELL_EMC_ECS_S3: 302,
	FUJITSU_STORAGE_ETERNUS: 303,
	HITACHI_VANTARA_HCP_S3: 304,
	IBM_CLOUD_S3: 305,
	NETAPP_STORAGEGRID: 306,
	REVERA_VAULT: 307,
	SCALITY_RING: 308,
	WASABI_HOT_CLOUD_STORAGE: 309,
	NUTANIX_BUCKETS: 310,
	SALESFORCE_CONNECTED_APP: 12
});

// Amazon cloud authentication types
export const amazonAuthType = acAppcredentialManagerModule.constant('AMAZON_AUTH_TYPE', {
	AMAZON_S3: 102,
	AMAZON_STS_IAM_ROLE: 16
});

export const azurAuthType = acAppcredentialManagerModule.constant('AZURE_AUTH_TYPE', {
	MICROSOFT_AZURE: 103,
	AZUREACCOUNT: 4
});

acAppcredentialManagerModule.constant('PERMISSION_TYPE', {
	USERCREDENTIAL: 218
});

acAppcredentialManagerModule.constant('CREDENTIAL_TYPE_BASE', {
	CLOUD: 100
});

acAppcredentialManagerModule.constant('CREATE_CREDENTIAL_DEFAULT', {
	connectString: '',
	dbName: '',
	userGroupId: '1',
	userGroupName: 'master',
	applicationId: '',
	environment: '',
	subscriptionId: '',
	tenantId: '',
	activeDirectoryEndpoint: '',
	storageEndpoint: '',
	resourceManagerEndpoint: '',
	sharedSecret: '2',
	roleARN: ''
});

acAppcredentialManagerModule.constant('CREDENTIAL_TYPE_ENVIRONMENT', {
	0: 'AzureCloud',
	1: 'AzureUSGov',
	2: 'AzureGermanCloud',
	3: 'AzureChinaCloud',
	4: 'AzureStack'
});

acAppcredentialManagerModule.constant('MANAGEMENT_ENDPOINT', {
	0: 'https://management.azure.com/',
	1: 'https://management.usgovcloudapi.net/',
	2: 'https://management.microsoftazure.de/',
	3: 'https://management.chinacloudapi.cn/'
});

acAppcredentialManagerModule.constant('AUTHENTICATION_ENDPOINT', {
	0: 'https://login.microsoftonline.com/',
	1: 'https://login.microsoftonline.us/',
	2: 'https://login.microsoftonline.de/',
	3: 'https://login.chinacloudapi.cn/'
});

acAppcredentialManagerModule.constant('KEY_VAULT_ENDPOINT', {
	0: 'vault.azure.net',
	1: 'vault.usgovcloudapi.net',
	2: 'vault.microsoftazure.de',
	3: 'vault.azure.cn'
});

acAppcredentialManagerModule.constant('STORAGE_ENDPOINT', {
	0: 'blob.core.windows.net',
	1: 'blob.core.usgovcloudapi.net',
	2: 'blob.core.cloudapi.de',
	3: 'blob.core.chinacloudapi.cn'
});

acAppcredentialManagerModule.constant('CREDENTIAL_PROPERTY_LEVEL', {
	MINIMAL_PROPS: 10,
	MINIMAL_WITH_DESC: 20,
	DETAILED: 30
});

export default acAppcredentialManagerModule;
