<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.commcell"></cv:cvMessages>
	<cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
</script>
<div class="setup-title">
	<h3><cv:msg key="header.associations" bundle="commcell" /></h3>
</div>

<span class="server-message {{securityAssocCtrl.serverMessage.type}}">{{securityAssocCtrl.serverMessage.message}}</span>

<div class="setup-content padding-15 multicommcell-association">
	<div class="margin-top-10 bootstrap-wrapper padding-bottom-0">
		<div class="row">
			<label class="col-xs-12 col-sm-4 margin-left-0 margin-right-0"><cv:msg key="label.providerUserGroup" bundle="commcell" /></label>
			<div class="col-xs-12 col-sm-8">
				<cv-select-2 search-options="securityAssocCtrl.searchConfig" output-model="securityAssocCtrl.selectedUser" class="fullWidthTable"></cv-select-2>
				<div class="cv-help-block text-left" ng-show="securityAssocCtrl.errorMessages.showAssociationEntityNotSelected">
					<span><cv:msg key="error.noUserUsergroupSelected" bundle="commcell" /></span>
				</div>
			</div>
		</div>
		<!-- <div class="row">
			<label class="col-xs-12 col-sm-4 margin-left-0 margin-right-0"><cv:msg key="label.Role" bundle="users" /></label>
			<div class="col-xs-12 col-sm-8">
				<isteven-multi-select id="editGlobalCSAssociation_isteven-multi-select_#2453"
					input-model="securityAssocCtrl.roles"
					output-model="securityAssocCtrl.selectedRole"
					item-label="roleName"
					button-label="roleName"
					class="isteven-multi-select"
					directive-id="rulesList"
					tick-property="selected"
					translation="securityAssocCtrl.labelConfigRole"
					selection-mode="single"
					disable-property="isItemDisabled"
					>
				</isteven-multi-select>
				<div class="cv-help-block text-left" ng-show="securityAssocCtrl.errorMessages.showRoleNotSelected">
					<span><cv:msg key="error.noRoleSelected" bundle="commcell" /></span>
				</div>
			</div>
		</div> -->
		<div class="row" ng-show="securityAssocCtrl.showCommcellDropdown">
			<label class="col-xs-12 col-sm-4 margin-left-0 margin-right-0"><cv:msg key="label.commcells" bundle="commcell" /></label>
			<div class="col-xs-12 col-sm-8">
				<isteven-multi-select id="editGlobalCSAssociation_isteven-multi-select_#4253"
					input-model="securityAssocCtrl.commcells"
					output-model="securityAssocCtrl.selectedCommcells"
					item-label="displayName"
					button-label="displayName"
					class="isteven-multi-select"
					directive-id="commcellList"
					tick-property="selected"
					group-property="commcellGroup"
					helper-elements="filter"
					translation="securityAssocCtrl.labelConfigCommcell"
					>
				</isteven-multi-select>
				<div class="cv-help-block text-left" ng-show="securityAssocCtrl.errorMessages.showCommcellNotSelected">
					<span ng-if="securityAssocCtrl.commcellList.length"><cv:msg key="error.noCommcellsSelected" bundle="commcell" /></span>
					<span ng-if="!securityAssocCtrl.commcellList.length"><cv:msg key="error.noCommcellsConfiguredAsIDP" bundle="commcell" /></span>
				</div>
			</div>
		</div>
		<div class="text-right margin-top-20">
			<button id="editGlobalCSAssociation_button_#2857" class="btn btn-primary cvBusyOnAjax" ng-click="securityAssocCtrl.addAssociation()" ng-disabled="!securityAssocCtrl.commcellList.length && securityAssocCtrl.showCommcellDropdown"><cv:msg key="label.add" bundle="users" /></button>
		</div>
	</div>
	<div class="margin-top-30 margin-bottom-50" ng-if="securityAssocCtrl.gridOptions">
		<cv-kendo-grid cv-grid-options="securityAssocCtrl.gridOptions"></cv-kendo-grid>
	</div>
	<div class="button-container">
		<div class="btn btn-default" ng-click="securityAssocCtrl.closeModal()"><cv:msg key="action.cancel" bundle="users" /></div>
		<div class="btn btn-primary cvBusyOnAjax" ng-click="securityAssocCtrl.saveAssociations()" ng-disabled="!securityAssocCtrl.commcellList.length && securityAssocCtrl.showCommcellDropdown"><cv:msg key="action.save" bundle="users" /></div>
	</div>
</div>