import 'modules/commcellRegistration/js/services/commcellRegistration.svc.js';
import 'modules/commcellRegistration/js/controllers/registerRouterCommcell.ctrl.js';
import 'modules/commcellRegistration/js/controllers/editSecurityAssociation.ctrl.js';
import 'modules/commcellRegistration/js/factory/serviceCommcell.constant.js';
import 'modules/commcellRegistration/js/factory/commcellRoles.constant.js';

import { acAppSecurityModule } from 'common/js/modules';

var commcellRegistrationMod = acAppSecurityModule;

commcellRegistrationMod.factory('commcellRegistrationFactory', [
	'cvUtil',
	'cvLoc',
	'commcellRegistrationService',
	'$uibModal',
	'serviceCommcellConstants',
	'serviceType',
	'ENTITY_ICONS',
	'cvToaster',
	'multiCommcellFactory',
	'commcellRole',
	function(
		cvUtil,
		cvLoc,
		commcellRegistrationService,
		$modal,
		serviceCommcellConstants,
		serviceType,
		ENTITY_ICONS,
		cvToaster,
		multiCommcellFactory,
		commcellRole
	) {
		var factory = {};

		factory.registeredCommcellList = [];

		factory.commcellSpecificActions = function() {
			return {
				REFRESH: {
					label: cvLoc('action.commcell.refresh'),
					value: 'REFRESH'
				}
			};
		};

		factory.loadRegisteredCommcells = function() {
			return commcellRegistrationService.getRegisteredCommcells();
		};

		factory.registerRemoteCommCell = function() {
			$modal.open({
				templateUrl: appUtil.appRoot + 'modules/commcellRegistration/partials/registerRouterCommcell.jsp',
				backdrop: 'static',
				controller: 'registerRouterCommcellController',
				controllerAs: 'regCcCtrl'
			});
		};

		factory.synchronizeDynamicApps = function() {
			commcellRegistrationService
				.synchronizeDynamicApps()
				.success(function() {
					cvToaster.showSuccessMessage({
						ttl: '10000',
						message: cvLoc('label.synchronizeDynamicApps.success')
					});
				})
				.error(function() {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: cvUtil.errMsgLoc('label.synchronizeDynamicApps.error')
					});
				});
		};

		factory.editAssociations = (registeredCommcellList, commcellAssociationsList, commcellId, commcellName) => {
			return $modal.open({
				templateUrl: appUtil.appRoot + '/modules/commcellRegistration/partials/editGlobalCSAssociation.jsp',
				backdrop: 'static',
				controller: 'editSecurityAssociationController',
				controllerAs: 'securityAssocCtrl',
				resolve: {
					commcellList: () => registeredCommcellList,
					commcellId: () => commcellId,
					commcellAssociationsList: () => commcellAssociationsList,
					commcellName: () => commcellName
				}
			}).result;
		};

		factory.updateCvAppOnUnregister = ($scope, deletedCommcell) => {
			if (!factory.registeredCommcellList.length) return;

			let isIdpCommcellPresent = false;

			if (factory.registeredCommcellList.length === 1) {
				cvApp.commcellInfo = {
					commcellType: serviceCommcellConstants.COMMCELL_UNCONFIGURED,
					commcellRole: commcellRole.NOTCONFIGURED,
					globalIdpCommcellName: '',
					globalIdpCommcellWebconsoleUrl: ''
				};

				$scope.$emit('commcellDeleted', _.get(deletedCommcell, 'commCell.commCellName', ''));
				return;
			}

			let updatedRole = commcellRole.NOTCONFIGURED;

			_.forEach(factory.registeredCommcellList, commcell => {
				// Check if atleast one commcell is configured for IDP then set flag
				if (commcell.commCell.commCellId !== deletedCommcell.commCell.commCellId) {
					if (
						(updatedRole & commcellRole.IDPCOMMCELL) === 0 &&
						multiCommcellFactory.checkRoleExist(commcell.commcellRoleInt, commcellRole.IDPCOMMCELL_SERVICECOMMCELL)
					) {
						updatedRole = updatedRole | commcellRole.IDPCOMMCELL;
					}

					if (
						(updatedRole & commcellRole.ROUTERCOMMCELL) === 0 &&
						multiCommcellFactory.checkRoleExist(commcell.commcellRoleInt, commcellRole.ROUTERCOMMCELL_SERVICECOMMCELL)
					) {
						updatedRole = updatedRole | commcellRole.ROUTERCOMMCELL;
					}

					if (
						(updatedRole & commcellRole.ONPRIM_SUBSCRIBER_OF_CLOUDSERVICE) === 0 &&
						multiCommcellFactory.checkRoleExist(commcell.commcellRoleInt, commcellRole.CLOUDSERVICE)
					) {
						updatedRole = updatedRole | commcellRole.ONPRIM_SUBSCRIBER_OF_CLOUDSERVICE;
					}
				}
			});

			cvApp.commcellInfo = {
				commcellType: isIdpCommcellPresent
					? serviceCommcellConstants.ROUTERCOMMCELL_AS_GLOBALIDP
					: serviceCommcellConstants.ROUTERCOMMCELL,
				globalIdpCommcellName: '',
				commcellRole: updatedRole,
				globalIdpCommcellWebconsoleUrl: ''
			};

			$scope.$emit('commcellDeleted', _.get(deletedCommcell, 'commCell.commCellName', ''));
		};

		factory.updateCvAppOnRegistration = ($scope, isGlobalIDPCommcell) => {
			let currentCommcellRole = _.get(cvApp, 'commcellInfo.commcellRole', 0);

			if (isGlobalIDPCommcell) {
				cvApp.commcellInfo = {
					commcellType: serviceCommcellConstants.ROUTERCOMMCELL_AS_GLOBALIDP,
					globalIdpCommcellName: '',
					globalIdpCommcellWebconsoleUrl: ''
				};

				cvApp.commcellInfo.commcellRole = currentCommcellRole | commcellRole.IDPCOMMCELL;

				$scope.$emit('commcellAdded');
			} else if (_.get(cvApp, 'commcellInfo.commcellType') !== serviceCommcellConstants.ROUTERCOMMCELL_AS_GLOBALIDP) {
				cvApp.commcellInfo = {
					commcellType: serviceCommcellConstants.ROUTERCOMMCELL,
					globalIdpCommcellName: '',
					globalIdpCommcellWebconsoleUrl: ''
				};

				cvApp.commcellInfo.commcellRole = currentCommcellRole | commcellRole.ROUTERCOMMCELL;
			}
		};

		factory.groupAssociationsByName = associations => {
			let getIdFromassociation = userOrGroup => {
				switch (userOrGroup._type_) {
					case serviceCommcellConstants.PROVIDER_TYPE:
						return `${userOrGroup._type_}-${userOrGroup.providerId}`;
					case serviceCommcellConstants.USER_GROUP_TYPE:
						return `${userOrGroup._type_}-${userOrGroup.userGroupId}`;
					case serviceCommcellConstants.USER_TYPE:
						return `${userOrGroup._type_}-${userOrGroup.userId}`;
				}
			};

			let map = {};

			let mergedAssociations = _.reduce(
				associations,
				(accumulator, association) => {
					let selector = getIdFromassociation(association.userOrGroup);

					if (!map[selector]) {
						map[selector] = association;
						accumulator.push(association);
						let role = _.get(association, 'properties.role');
						role.roleNameCS = role.roleName;
					} else {
						let baseAssociation = map[selector];
						let role = _.get(baseAssociation, 'properties.role');
						role.roleNameCS = role.roleNameCS.concat(`, ${_.get(association, 'properties.role.roleName', '')}`);
						baseAssociation.role = role;
					}

					return accumulator;
				},
				[]
			);

			return mergedAssociations;
		};

		factory.classifyItemsWithProviderType = (providerType, classifier) => {
			switch (providerType) {
				case serviceType.AD:
					return classifier.AD;
				case serviceType.LDAP:
				case serviceType.LADP_JUMPCLOUD:
				case serviceType.LADP_RADIUS:
				case serviceType.LADP_OPENDIRECTORY:
				case serviceType.LADP_ORACLE:
				case serviceType.LADP_OPEN_LDAP:
					return classifier.LDAP;
				case serviceType.PROVIDER:
					return classifier.COMPANY;
				case serviceType.DUMMY_SAML:
					return classifier.SAML;
				default:
					return classifier.DEFAULT || null;
			}
		};

		factory.getProviderEntityTypeName = providerType => {
			let classifier = {
				AD: cvLoc('label.ad'),
				LDAP: cvLoc('label.ldap'),
				COMPANY: cvLoc('label.companyType'),
				SAML: cvLoc('label.saml')
			};

			return factory.classifyItemsWithProviderType(providerType, classifier);
		};

		factory.getEntityTypeFromUserSuggestion = userSuggestionObject => {
			switch (userSuggestionObject.userInfo.userType) {
				case serviceCommcellConstants.EXTERNAL_GROUP:
				case serviceCommcellConstants.COMMCELL_GROUP:
					return cvLoc('label.userGroup');
				case serviceCommcellConstants.USER:
					return cvLoc('label.user');
				case serviceCommcellConstants.PROVIDER:
					return factory.getProviderEntityTypeName(userSuggestionObject.providerType);
			}
		};

		factory.getIconsForProviderType = providerType => {
			let classifier = {
				AD: ENTITY_ICONS.LDAP,
				LDAP: ENTITY_ICONS.LDAP,
				COMPANY: ENTITY_ICONS.COMPANY,
				SAML: ENTITY_ICONS.SAML
			};

			return factory.classifyItemsWithProviderType(providerType, classifier);
		};

		factory.getUrlForProviderType = (providerObject, providerType) => {
			let classifier = {
				AD: `adDomainDetails/${providerObject.providerId}`,
				LDAP: `adDomainDetails/${providerObject.providerId}`,
				COMPANY: `subscriptions/${providerObject.providerId}`,
				SAML: `identityServer/${providerObject.providerDomainName}`,
				DEFAULT: ''
			};

			return factory.classifyItemsWithProviderType(providerType, classifier);
		};

		return factory;
	}
]);

export default commcellRegistrationMod;
