import { acAppSecurityModule } from 'common/js/modules';

var commcellRegistrationMod = acAppSecurityModule;

commcellRegistrationMod.directive('foldArray', () => {
	return {
		restrict: 'E',
		template: `
			<div class="cv-flex fold-array-container">
				<div ng-if="!array.length && emptyMessage"><span ng-bind="emptyMessage"></span></div>
				<div ng-if="!isLink">
					<span class="crop" ng-repeat="displayItem in displayArray" ng-bind="displayItem[displayName]"></span>
				</div>
				<div ng-if="isLink">
					<span ng-repeat="displayItem in displayArray"><a ng-bind="displayItem[displayName]" href="{{ displayItem.link }}"></a><span ng-if="!$last">,&nbsp;</span></span>
				</div>
				<span class="more-text cursor-pointer" ng-if="moreValues > 0" uib-popover-html="templateText" popover-trigger="outsideClick" popover-placement="bottom"><span class="k-icon k-i-plus plus-more-icon"></span>{{ 'label.nmore'|cvLoc: moreValues }}</span>
			</div>
		`,
		scope: {
			array: '=',
			offset: '=',
			isLink: '=',
			displayName: '@',
			emptyMessage: '@'
		},
		link: $scope => {
			let offset = parseInt($scope.offset);
			let isLink = $scope.isLink || false;
			if (!offset) {
				offset = 1;
			}

			let unWatchArray = $scope.$watch('array', () => {
				$scope.moreValues = !$scope.array || offset > $scope.array.length ? 0 : $scope.array.length - offset;

				if ($scope.array && $scope.array.length > 0 && offset > 0) {
					let displayArray = $scope.array.slice(0, offset);
					let moreArray = $scope.array.slice(offset);

					$scope.templateText = '';

					$scope.displayArray = displayArray;

					_.forEach(moreArray, item => {
						if (!isLink) $scope.templateText = `${$scope.templateText}<div>${_.get(item, $scope.displayName)}</div>`;
						else
							$scope.templateText = `${$scope.templateText}<div><a href="${_.get(item, 'link')}">${_.get(
								item,
								$scope.displayName
							)}</a></div>`;
					});
				} else if ($scope.array && $scope.array.length === 0) {
					$scope.displayArray = [];
					$scope.moreArray = [];
					$scope.templateText = '';
				}
			});

			$scope.$on('$destroy', () => {
				unWatchArray();
			});
		}
	};
});

export default commcellRegistrationMod;
